"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BusinessService = void 0;
const commonUrls_1 = require("../commonUrls");
const utils_1 = require("../utils");
class BusinessService {
    static getBusinesses() {
        const url = commonUrls_1.commonUrls.business.getBusinesses();
        return utils_1.http.get(url);
    }
    static getStores(businessId) {
        const url = commonUrls_1.commonUrls.business.getStores(businessId);
        return utils_1.http.get(url);
    }
    static getStoresAndAssociates(businessId) {
        const url = commonUrls_1.commonUrls.business.getStoresWithAssociates(businessId);
        return utils_1.http.get(url);
    }
}
exports.BusinessService = BusinessService;
//# sourceMappingURL=BusinessService.js.map