"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UtilityService = exports.UploadServiceType = void 0;
const tslib_1 = require("tslib");
const commonUrls_1 = require("../commonUrls");
const utils_1 = require("../utils");
var UploadServiceType;
(function (UploadServiceType) {
    UploadServiceType[UploadServiceType["FASHTAG"] = 0] = "FASHTAG";
    UploadServiceType[UploadServiceType["QUESTIONNAIRE"] = 1] = "QUESTIONNAIRE";
})(UploadServiceType = exports.UploadServiceType || (exports.UploadServiceType = {}));
class UtilityService {
    static uploadFile(file, bucketName, uploadServiceType) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const formData = new FormData();
            formData.append('file', file);
            return utils_1.http.post(uploadServiceType === UploadServiceType.FASHTAG
                ? commonUrls_1.commonUrls.util.uploadFile(bucketName)
                : commonUrls_1.commonUrls.util.uploadFileQuestionnaire(bucketName), formData);
        });
    }
}
exports.UtilityService = UtilityService;
//# sourceMappingURL=UtilityService.js.map