"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BusinessStore = void 0;
const tslib_1 = require("tslib");
const utils_1 = require("../utils");
const services_1 = require("../services");
const mobx_1 = require("mobx");
class BusinessStore {
    constructor(loginStore) {
        this.loginStore = loginStore;
        this.storesResponse = utils_1.getDefaultNetworkResponse();
        this.selectedStoreId = null;
        this.otherStoreId = null;
        this.setSelectedStore = (storeId) => {
            mobx_1.runInAction(() => {
                this.selectedStoreId = storeId;
            });
        };
        mobx_1.autorun(() => this.getStores(this.loginStore.businessId, this.loginStore.isLoggedIn));
        mobx_1.autorun(() => {
            this.otherStoreId = null;
            if (!this.storesResponse.data || this.storesResponse.data.length === 0) {
                this.selectedStoreId = null;
            }
            else {
                this.selectedStoreId = this.storesResponse.data[0].externalId;
            }
            if (!this.storesResponse.data || this.storesResponse.data.length < 2) {
                this.otherStoreId = null;
            }
            else {
                this.otherStoreId = this.storesResponse.data[1].externalId;
            }
        });
    }
    get selectedStore() {
        if (!this.selectedStoreId || !this.storesResponse.data)
            return null;
        return (this.storesResponse.data.find((store) => store.externalId === this.selectedStoreId) || null);
    }
    get otherStore() {
        if (!this.otherStoreId || !this.storesResponse.data)
            return null;
        return (this.storesResponse.data.find((store) => store.externalId === this.otherStoreId) || null);
    }
    setOtherStore(storeId) {
        this.otherStoreId = storeId;
    }
    getStores(businessId, isLoggedIn) {
        if (!isLoggedIn) {
            utils_1.applyNetworkResponse(this.storesResponse, false, null, false);
            return;
        }
        utils_1.applyNetworkResponse(this.storesResponse, true, null, false);
        services_1.BusinessService.getStores(businessId)
            .then((response) => {
            if (businessId === this.loginStore.businessId) {
                utils_1.applyNetworkResponse(this.storesResponse, false, response, false);
            }
        })
            .catch((error) => {
            if (businessId === this.loginStore.businessId) {
                utils_1.applyNetworkResponse(this.storesResponse, false, null, error);
            }
        });
    }
}
tslib_1.__decorate([
    mobx_1.observable,
    tslib_1.__metadata("design:type", Object)
], BusinessStore.prototype, "storesResponse", void 0);
tslib_1.__decorate([
    mobx_1.observable,
    tslib_1.__metadata("design:type", Object)
], BusinessStore.prototype, "selectedStoreId", void 0);
tslib_1.__decorate([
    mobx_1.observable,
    tslib_1.__metadata("design:type", Object)
], BusinessStore.prototype, "otherStoreId", void 0);
tslib_1.__decorate([
    mobx_1.computed,
    tslib_1.__metadata("design:type", Object),
    tslib_1.__metadata("design:paramtypes", [])
], BusinessStore.prototype, "selectedStore", null);
tslib_1.__decorate([
    mobx_1.computed,
    tslib_1.__metadata("design:type", Object),
    tslib_1.__metadata("design:paramtypes", [])
], BusinessStore.prototype, "otherStore", null);
tslib_1.__decorate([
    mobx_1.action,
    tslib_1.__metadata("design:type", Object)
], BusinessStore.prototype, "setSelectedStore", void 0);
tslib_1.__decorate([
    mobx_1.action,
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [String]),
    tslib_1.__metadata("design:returntype", void 0)
], BusinessStore.prototype, "setOtherStore", null);
exports.BusinessStore = BusinessStore;
//# sourceMappingURL=BusinessStore.js.map