"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoginStore = void 0;
const tslib_1 = require("tslib");
const mobx_1 = require("mobx");
const services_1 = require("../services");
const utils_1 = require("../utils");
const storage = tslib_1.__importStar(require("../utils/storage"));
const SESSION_ID_HEADER = 'session_id';
class LoginStore {
    constructor() {
        // FIXME: [FIXTURES] this is temporary to work with fixtures
        this.businessIdsResponse = utils_1.getDefaultNetworkResponse();
        this.loginResponse = utils_1.getDefaultNetworkResponse();
        this.setBusinessIds = (businessIds) => {
            this.businessIdsResponse = {
                data: businessIds,
                error: null,
                isLoading: false,
            };
        };
        this.updateSavedLogin = () => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                utils_1.applyNetworkResponse(this.loginResponse, true, null, null);
                const savedLogin = yield storage.getLogin();
                if (savedLogin) {
                    utils_1.applyNetworkResponse(this.loginResponse, false, savedLogin, null);
                }
            }
            catch (e) {
                utils_1.applyNetworkResponse(this.loginResponse, false, null, e);
            }
        });
        this.login = (loginFormData) => {
            const promise = services_1.LoginService.login(loginFormData.username, loginFormData.password, loginFormData.businessId);
            utils_1.applyNetworkResponseForPromise(this.loginResponse, promise.then((resp) => ({
                userId: resp.userEntity.externalId,
                sessionId: resp.shiroSession.id,
                businessId: resp.userEntity.businessId,
            })));
        };
        this.logout = () => {
            const loginResponseData = this.loginResponse.data;
            if (!loginResponseData)
                return;
            services_1.LoginService.logout(loginResponseData.sessionId)
                .then(() => {
                utils_1.applyNetworkResponse(this.loginResponse, false, null, null);
            })
                .catch(() => {
                utils_1.applyNetworkResponse(this.loginResponse, false, null, null);
            });
        };
        this.addReactions();
        // FIXME: [FIXTURES] this is temporary to work with fixtures.
        utils_1.applyNetworkResponseForPromise(this.businessIdsResponse, services_1.BusinessService.getBusinesses().then((resp) => resp.map((business) => business.externalId)));
        this.updateSavedLogin();
        // observe local storage to logout if logged out from other tab (other document)
        window.addEventListener('storage', this.updateSavedLogin);
        utils_1.http.addErrorInterceptor((response) => {
            if (response.status === 401 && this.loginResponse.data) {
                utils_1.applyNetworkResponse(this.loginResponse, false, null, {
                    message: 'Session timed out',
                });
            }
        });
    }
    get isLoggedIn() {
        // FIXME: [FIXTURES] this is temporary to work with business
        const businessIds = this.businessIdsResponse.data;
        return businessIds !== null && businessIds.length > 0;
    }
    get businessId() {
        // FIXME: [FIXTURES] this is temporary to work with business
        const businessIds = this.businessIdsResponse.data || [
            'ea1ca4b6-a9cf-43b7-8fe3-7f74429c10e2',
        ];
        if (!businessIds)
            throw new Error('No Business Id');
        return businessIds[0];
    }
    addReactions() {
        // whenever login response changes, update storage.
        mobx_1.reaction(() => this.loginResponse.data, () => {
            const loginResponse = this.loginResponse.data;
            if (loginResponse) {
                // eslint-disable-next-line @typescript-eslint/camelcase
                utils_1.http.addHeader(SESSION_ID_HEADER, loginResponse.sessionId);
                storage.saveLogin(loginResponse);
            }
            else {
                utils_1.http.removeHeader(SESSION_ID_HEADER);
                storage.deleteLogin();
            }
        });
    }
}
tslib_1.__decorate([
    mobx_1.observable,
    tslib_1.__metadata("design:type", Object)
], LoginStore.prototype, "businessIdsResponse", void 0);
tslib_1.__decorate([
    mobx_1.observable,
    tslib_1.__metadata("design:type", Object)
], LoginStore.prototype, "loginResponse", void 0);
tslib_1.__decorate([
    mobx_1.computed,
    tslib_1.__metadata("design:type", Boolean),
    tslib_1.__metadata("design:paramtypes", [])
], LoginStore.prototype, "isLoggedIn", null);
tslib_1.__decorate([
    mobx_1.computed,
    tslib_1.__metadata("design:type", String),
    tslib_1.__metadata("design:paramtypes", [])
], LoginStore.prototype, "businessId", null);
tslib_1.__decorate([
    mobx_1.action,
    tslib_1.__metadata("design:type", Object)
], LoginStore.prototype, "setBusinessIds", void 0);
exports.LoginStore = LoginStore;
//# sourceMappingURL=LoginStore.js.map