import { ReactNode } from 'react';
export declare enum NotificationType {
    WARNING = "WARNING",
    ERROR = "ERROR",
    SUCCESS = "SUCCESS",
    INFO = "INFO"
}
export interface NotificationActionButton {
    label: string;
    action: () => void;
}
export interface Notification {
    id?: string;
    type?: NotificationType;
    message: string | ReactNode;
    persist?: boolean;
    actionButtons?: NotificationActionButton[];
}
export declare class NotificationStore {
    notifications: Notification[];
    pushNotification: (notification: Notification) => void;
    clearQueue: () => void;
}
