"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationStore = exports.NotificationType = void 0;
const tslib_1 = require("tslib");
const mobx_1 = require("mobx");
var NotificationType;
(function (NotificationType) {
    NotificationType["WARNING"] = "WARNING";
    NotificationType["ERROR"] = "ERROR";
    NotificationType["SUCCESS"] = "SUCCESS";
    NotificationType["INFO"] = "INFO";
})(NotificationType = exports.NotificationType || (exports.NotificationType = {}));
class NotificationStore {
    constructor() {
        this.notifications = [];
        this.pushNotification = (notification) => {
            this.notifications.push(notification);
        };
        this.clearQueue = () => {
            this.notifications = [];
        };
    }
}
tslib_1.__decorate([
    mobx_1.observable,
    tslib_1.__metadata("design:type", Array)
], NotificationStore.prototype, "notifications", void 0);
tslib_1.__decorate([
    mobx_1.action,
    tslib_1.__metadata("design:type", Object)
], NotificationStore.prototype, "pushNotification", void 0);
tslib_1.__decorate([
    mobx_1.action,
    tslib_1.__metadata("design:type", Object)
], NotificationStore.prototype, "clearQueue", void 0);
exports.NotificationStore = NotificationStore;
//# sourceMappingURL=NotificationStore.js.map