"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.QuestionnaireLoginStore = void 0;
const tslib_1 = require("tslib");
const mobx_1 = require("mobx");
const QuestionnaireBusinessService_1 = require("../services/QuestionnaireBusinessService");
const storage_1 = require("../utils/storage");
class QuestionnaireLoginStore {
    constructor() {
        this.questionnaireBusiness = {
            data: null,
            error: null,
            isLoading: false,
        };
        this.questionnaireUserResponse = {
            data: null,
            error: null,
            isLoading: false,
        };
        this.fetchUser = (emailId) => {
            this.setBusiness(true, null, null);
            this.setUser(true, null, null);
            QuestionnaireBusinessService_1.QuestionnaireBusinessService.fetchUser(emailId)
                .then((result) => {
                var _a;
                this.setBusiness(false, null, result.privateBusiness);
                this.setUser(false, null, result.user);
                storage_1.saveQuestionnaireLogin({
                    businessId: result.privateBusiness.id,
                    email: (_a = result.user.email) !== null && _a !== void 0 ? _a : '',
                });
            })
                .catch((error) => {
                this.setBusiness(false, error, null);
                this.setUser(false, error, null);
            });
        };
        this.updateUser = (emailId, user) => {
            this.setUser(true, null, null);
            QuestionnaireBusinessService_1.QuestionnaireBusinessService.updateUser(emailId, user)
                .then((result) => {
                this.setUser(false, null, result);
            })
                .catch((error) => {
                this.setUser(false, error, null);
            });
        };
        this.setBusiness = (isLoading, error, value) => {
            this.questionnaireBusiness = {
                data: value,
                error,
                isLoading,
            };
        };
        this.clearBusiness = () => {
            this.setBusiness(false, false, null);
        };
        this.setUser = (isLoading, error, value) => {
            this.questionnaireUserResponse = {
                data: value,
                error,
                isLoading,
            };
        };
        this.clearUser = () => {
            this.setUser(false, false, null);
        };
    }
    get isLoggedIn() {
        // FIXME: [FIXTURES] this is temporary to work with business
        const businessIds = this.questionnaireBusiness.data;
        return businessIds !== null;
    }
    get businessId() {
        // FIXME: [FIXTURES] this is temporary to work with business
        const savedQuestionnaireLogin = storage_1.getQuestionnaireLogin();
        const businessIds = savedQuestionnaireLogin === null || savedQuestionnaireLogin === void 0 ? void 0 : savedQuestionnaireLogin.businessId;
        // if (!businessIds) throw new Error('No Business Id');
        return businessIds !== null && businessIds !== void 0 ? businessIds : '';
    }
}
tslib_1.__decorate([
    mobx_1.observable,
    tslib_1.__metadata("design:type", Object)
], QuestionnaireLoginStore.prototype, "questionnaireBusiness", void 0);
tslib_1.__decorate([
    mobx_1.observable,
    tslib_1.__metadata("design:type", Object)
], QuestionnaireLoginStore.prototype, "questionnaireUserResponse", void 0);
tslib_1.__decorate([
    mobx_1.action,
    tslib_1.__metadata("design:type", Object)
], QuestionnaireLoginStore.prototype, "setBusiness", void 0);
tslib_1.__decorate([
    mobx_1.action,
    tslib_1.__metadata("design:type", Object)
], QuestionnaireLoginStore.prototype, "setUser", void 0);
tslib_1.__decorate([
    mobx_1.computed,
    tslib_1.__metadata("design:type", Boolean),
    tslib_1.__metadata("design:paramtypes", [])
], QuestionnaireLoginStore.prototype, "isLoggedIn", null);
tslib_1.__decorate([
    mobx_1.computed,
    tslib_1.__metadata("design:type", String),
    tslib_1.__metadata("design:paramtypes", [])
], QuestionnaireLoginStore.prototype, "businessId", null);
exports.QuestionnaireLoginStore = QuestionnaireLoginStore;
//# sourceMappingURL=QuestionnaireLoginStore.js.map