"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.http = exports.put = exports.deleteApi = exports.post = exports.get = exports.ajax = exports.RequestMethod = void 0;
const tslib_1 = require("tslib");
var RequestMethod;
(function (RequestMethod) {
    RequestMethod["GET"] = "GET";
    RequestMethod["POST"] = "POST";
    RequestMethod["DELETE"] = "DELETE";
    RequestMethod["PUT"] = "PUT";
})(RequestMethod = exports.RequestMethod || (exports.RequestMethod = {}));
let _headers = {};
const _requestInterceptors = [];
const _responseInterceptors = [];
const _errorInterceptors = [];
function addHeader(name, value) {
    _headers[name] = value;
}
function removeHeader(name) {
    delete _headers[name];
}
function clearHeaders() {
    _headers = {};
}
function addRequestInterceptor(interceptor) {
    _requestInterceptors.push(interceptor);
}
function removeRequestInterceptor(interceptor) {
    const index = _requestInterceptors.indexOf(interceptor);
    if (index !== -1)
        _requestInterceptors.splice(index, 1);
}
function clearRequestInterceptors() {
    _requestInterceptors.splice(0, _requestInterceptors.length);
}
function addResponseInterceptor(interceptor) {
    _responseInterceptors.push(interceptor);
}
function removeResponseInterceptor(interceptor) {
    const index = _responseInterceptors.indexOf(interceptor);
    if (index !== -1)
        _responseInterceptors.splice(index, 1);
}
function clearResponseInterceptors() {
    _responseInterceptors.splice(0, _responseInterceptors.length);
}
function addErrorInterceptor(interceptor) {
    _errorInterceptors.push(interceptor);
}
function removeErrorInterceptor(interceptor) {
    const index = _errorInterceptors.indexOf(interceptor);
    if (index !== -1)
        _errorInterceptors.splice(index, 1);
}
function clearErrorInterceptors() {
    _errorInterceptors.splice(0, _errorInterceptors.length);
}
// function rawGetApi(
//   url: string,
//   successCB?:
//     | ((
//         status: number,
//         response: SearchResponseDTO[],
//         xhr: XMLHttpRequest
//       ) => void)
//     | undefined,
//   errorCB?: () => void
// ) {
//   const xhr = new XMLHttpRequest();
//   xhr.open('GET', url, true);
//
//   xhr.onload = () => {
//     if (xhr.status === 200) {
//       if (successCB) {
//         successCB(xhr.status, JSON.parse(xhr.response), xhr);
//       }
//     } else if (errorCB) {
//       errorCB();
//     }
//   };
//
//   xhr.onerror = () => {
//     if (errorCB) {
//       errorCB();
//     }
//   };
//
//   Object.keys(_headers).forEach(headerName => {
//     const headerValue = _headers[headerName];
//     if (!headerValue) return;
//     xhr.setRequestHeader(headerName, headerValue);
//   });
//
//   xhr.send();
//
//   return xhr;
// }
function ajax(url, method, requestBody, init) {
    var _a;
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const _b = init !== null && init !== void 0 ? init : {}, { parseJSON = true } = _b, requestOptions = tslib_1.__rest(_b, ["parseJSON"]);
        // did not extract (requestBody instanceof FormData) init variable
        // because type inference fails for RequestInit
        const body = requestBody instanceof FormData
            ? requestBody
            : requestBody && JSON.stringify(requestBody);
        const headers = Object.assign(Object.assign({ 'Content-Type': 'application/json' }, _headers), requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.headers);
        const requestInit = Object.assign({ method,
            headers,
            body, mode: 'cors' }, requestOptions);
        if (requestBody instanceof FormData) {
            if ((_a = requestInit.headers) === null || _a === void 0 ? void 0 : _a['Content-Type']) {
                delete requestInit.headers['Content-Type'];
            }
        }
        _requestInterceptors.forEach((interceptor) => {
            interceptor(url, requestInit);
        });
        const response = yield fetch(url, requestInit);
        if (!response.ok) {
            _errorInterceptors.forEach((interceptor) => {
                interceptor(response);
            });
            return Promise.reject(response);
        }
        const data = parseJSON ? yield response.json() : response;
        _responseInterceptors.forEach((interceptor) => {
            interceptor(data, response.status);
        });
        return data;
    });
}
exports.ajax = ajax;
function get(url, init) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return ajax(url, RequestMethod.GET, undefined, init);
    });
}
exports.get = get;
function post(url, requestBody, init) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return ajax(url, RequestMethod.POST, requestBody, init);
    });
}
exports.post = post;
function deleteApi(url, requestBody, init) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return ajax(url, RequestMethod.DELETE, requestBody, init);
    });
}
exports.deleteApi = deleteApi;
function put(url, requestBody, init) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return ajax(url, RequestMethod.PUT, requestBody, init);
    });
}
exports.put = put;
exports.http = {
    addHeader,
    removeHeader,
    clearHeaders,
    addRequestInterceptor,
    removeRequestInterceptor,
    clearRequestInterceptors,
    addResponseInterceptor,
    removeResponseInterceptor,
    clearResponseInterceptors,
    addErrorInterceptor,
    removeErrorInterceptor,
    clearErrorInterceptors,
    ajax,
    get,
    post,
    delete: deleteApi,
    put,
};
//# sourceMappingURL=http.js.map