"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.retrieveItem = exports.storeItem = exports.deleteQuestionnaireLogin = exports.saveQuestionnaireLogin = exports.getQuestionnaireLogin = exports.deleteLogin = exports.saveLogin = exports.getLogin = void 0;
const tslib_1 = require("tslib");
// we store session id and user id in local storage
const SESSION_ID_KEY = 'session_id';
const USER_ID_KEY = 'user_id';
const BUSINESS_ID_KEY = 'business_id';
const QUESTIONNAIRE_USER_EMAIL = 'q_email';
const QUESTIONNAIRE_BUSINESS_EXTERNAL_ID = 'q_external_id';
const QUESTIONNAIRE_ACCESS_TOKEN = 'q_access_token';
function getLogin() {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const sessionId = localStorage.getItem(SESSION_ID_KEY);
        const userId = localStorage.getItem(USER_ID_KEY);
        const businessId = localStorage.getItem(BUSINESS_ID_KEY);
        if (!sessionId || !userId || !businessId)
            return null;
        return {
            sessionId,
            userId,
            businessId,
        };
    });
}
exports.getLogin = getLogin;
function saveLogin(loginResponse) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        localStorage.setItem(SESSION_ID_KEY, loginResponse.sessionId);
        localStorage.setItem(USER_ID_KEY, loginResponse.userId);
        localStorage.setItem(BUSINESS_ID_KEY, loginResponse.businessId);
    });
}
exports.saveLogin = saveLogin;
function deleteLogin() {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        localStorage.removeItem(SESSION_ID_KEY);
        localStorage.removeItem(USER_ID_KEY);
        localStorage.removeItem(BUSINESS_ID_KEY);
    });
}
exports.deleteLogin = deleteLogin;
function getQuestionnaireLogin() {
    const email = localStorage.getItem(QUESTIONNAIRE_USER_EMAIL);
    const businessId = localStorage.getItem(QUESTIONNAIRE_BUSINESS_EXTERNAL_ID);
    if (!email || !businessId)
        return null;
    return {
        email,
        businessId,
    };
}
exports.getQuestionnaireLogin = getQuestionnaireLogin;
function saveQuestionnaireLogin(savedQuestionnaireLogin) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        if (savedQuestionnaireLogin.email) {
            localStorage.setItem(QUESTIONNAIRE_USER_EMAIL, savedQuestionnaireLogin.email);
        }
        if (savedQuestionnaireLogin.businessId) {
            localStorage.setItem(QUESTIONNAIRE_BUSINESS_EXTERNAL_ID, savedQuestionnaireLogin.businessId);
        }
        if (savedQuestionnaireLogin.accessToken) {
            localStorage.setItem(QUESTIONNAIRE_ACCESS_TOKEN, savedQuestionnaireLogin.accessToken);
        }
    });
}
exports.saveQuestionnaireLogin = saveQuestionnaireLogin;
function deleteQuestionnaireLogin() {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        localStorage.removeItem(QUESTIONNAIRE_USER_EMAIL);
        localStorage.removeItem(QUESTIONNAIRE_BUSINESS_EXTERNAL_ID);
        localStorage.removeItem(QUESTIONNAIRE_ACCESS_TOKEN);
    });
}
exports.deleteQuestionnaireLogin = deleteQuestionnaireLogin;
function storeItem(key, value) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        localStorage.setItem(key, JSON.stringify(value));
    });
}
exports.storeItem = storeItem;
function retrieveItem(key) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const strVal = localStorage.getItem(key);
        if (!strVal)
            return null;
        return JSON.parse(strVal);
    });
}
exports.retrieveItem = retrieveItem;
//# sourceMappingURL=storage.js.map