"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.provideStore = exports.provideWithRootStore = exports.getDefaultNetworkResponse = exports.applyNetworkResponseForPromise = exports.applyNetworkResponse = exports.useSelector = exports.useStores = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
const mobx_react_1 = require("mobx-react");
const mobx_1 = require("mobx");
function useStores() {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    return react_1.useContext(mobx_react_1.MobXProviderContext);
}
exports.useStores = useStores;
function useSelector(selector) {
    const rootStore = useStores();
    return mobx_react_1.useObserver(() => selector(rootStore));
}
exports.useSelector = useSelector;
exports.applyNetworkResponse = function setNetworkResponse(store, isLoading, response, error) {
    mobx_1.runInAction(() => {
        store.isLoading = isLoading;
        store.data = response;
        store.error = error;
    });
};
function applyNetworkResponseForPromise(store, promise, successAction, failureAction) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        exports.applyNetworkResponse(store, true, null, null);
        try {
            const response = yield promise;
            exports.applyNetworkResponse(store, false, response, null);
            if (successAction)
                successAction(response);
        }
        catch (error) {
            exports.applyNetworkResponse(store, false, null, error);
            if (failureAction)
                failureAction(error);
        }
    });
}
exports.applyNetworkResponseForPromise = applyNetworkResponseForPromise;
function getDefaultNetworkResponse() {
    return {
        data: null,
        error: null,
        isLoading: false,
    };
}
exports.getDefaultNetworkResponse = getDefaultNetworkResponse;
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function hasDestructor(store) {
    return store && store.destructor && typeof store.destructor === 'function';
}
function provideWithRootStore(StoreClass, WrappedComponent) {
    return function MergedStoreProvider(props) {
        const rootStore = useStores();
        const [store, setStore] = react_1.useState();
        react_1.useEffect(() => {
            const _store = new StoreClass(rootStore);
            setStore(_store);
            return () => {
                if (hasDestructor(_store)) {
                    _store.destructor();
                }
            };
            /* eslint-disable-next-line react-hooks/exhaustive-deps */
        }, []);
        if (!store)
            return null;
        return (react_1.default.createElement(mobx_react_1.Provider, Object.assign({}, rootStore, store),
            react_1.default.createElement(WrappedComponent, Object.assign({}, props))));
    };
}
exports.provideWithRootStore = provideWithRootStore;
function provideStore(StoreClass, WrappedComponent) {
    return function StoreProvider(props) {
        const [store, setStore] = react_1.useState();
        react_1.useEffect(() => {
            const _store = new StoreClass();
            setStore(_store);
            return () => {
                if (hasDestructor(_store)) {
                    _store.destructor();
                }
            };
            /* eslint-disable-next-line react-hooks/exhaustive-deps */
        }, []);
        if (!store)
            return null;
        return (react_1.default.createElement(mobx_react_1.Provider, Object.assign({}, store),
            react_1.default.createElement(WrappedComponent, Object.assign({}, props))));
    };
}
exports.provideStore = provideStore;
//# sourceMappingURL=store.js.map