# Setup
Install questionnaire-web-sdk using the following command
```
# npm
npm install questionnaire-web-sdk-to-be-replaced@latest
# yarn
yarn add questionnaire-web-sdk-to-be-replaced@latest
```
or download the minified file.
```
<script src="https://somecdn.com/path/questionnaire-web-sdk"></script>
```

# Integration:
The questionnaire web sdk can be integrated as a React component or using javascript methods exposed.

## Integrating as React component
Obtain the ConsumerWebSDK object.

```
# using package manager
import { ConsumerWebSDK } from 'questionnaire-web-sdk-to-be-replaced@latest'
# using CDN build
const ConsumerWebSDK = window.ConsumerWebSDK;
```

The components can be integrated as below.

```
<ConsumerWebSDK
  onExit={onExit}
  initData={data}
  apiKey={'your api key here'}
/>
```

### Props

`initData: ConsumerWebSDKData`

This data is used to initialize the questionnaire web sdk. More details are available below.

`onExit: ()=>void;`

This callback is called when there are no more questions. This can be used to do the cleanup.
The component can be safely unmounted without loss of data.

`apiKey: string`
Obtain the **API key** required to connect with Fashtag servers from the `Settings` section in your Fashtag questionnaire dashboard.

## Integrating using javascript functions
Obtain the functions to load and unload functions as below.

```
# using package manager
import { loadQuestionnaireWebSDK, unloadQuestionnaireWebSDK } from 'questionnaire-web-sdk-to-be-replaced@latest'
# using CDN build
const loadQuestionnaireWebSDK = window.loadQuestionnaireWebSDK;
const unloadQuestionnaireWebSDK = window.unloadQuestionnaireWebSDK;
```


### loadQuestionnaireWebSDK
```
loadQuestionnaireWebSDK: (
  container: HTMLElement,
  initData: ConsumerWebSDKData,
  onExit: () => void,
  apiKey: string
) => void
```
#### parameters
used to load questionnaire into container provided

- `container`: the HTML element into which the questionnaire should be loaded.
- `initData`: This data is used to initialize the questionnaire web sdk. More details are available below.
- `onExit`: This callback is called when there are no more questions. This can be used to do the cleanup. The questionnaire can be safely unloaded without loss of data.
- `apiKey`: Obtain the **API key** required to connect with Fashtag servers from the `Settings` section in your Fashtag questionnaire dashboard.

### unloadQuestionnaireWebSDK
```
unloadQuestionnaireWebSDK: (container: HTMLElement) => void
```

#### parameters
used to unload questionnaire from container provided

- `container`: the HTML element from which the questionnaire should be unloaded. This should be the same as the one passed to `loadQuestionnaireWebSDK`. 


# Init Data
The init data has the following properties
```
interface ConsumerWebSDKData {
  businessId: string;
  storeId?: string;
  context?: Record<string, VariableData>;
  questionnaireTags?: Array<string>;
  questionnaireId?: string;
  distributionType?: 'WEB_EMBED' | 'AUTO_EMAIL' | 'AUTO_SMS';
}
```

// the below section needs to be refined.

- `businessId: string;` - [Required] - The business ID registered.
- `storeId?: string;` [Optional] - Needs to be passed if used in fashtag mode.
- `context?: Record<string, VariableData>;` - [Optional] The variables used in the questionnaire.
- `questionnaireTags?: Array<string>;` - [Optional] If questionnaire needs to be fetched by tag, this has to be passed.
- `questionnaireId?: string;` - [Optional] If questionnaire needs to be fetched using its identifier, this has to be passed.
- `distributionType?: 'WEB_EMBED' | 'AUTO_EMAIL' | 'AUTO_SMS'` - [Optional] [default: WEB_EMBED] The distribution type to be used.
#### Note:
Either questionnaireId or non-empty questionnaire tags list has to be passed. If either is not passed, the component will throw an error.

## CSS Customization
The following classes can be used to customize the styles of the questionnaire consumer
- askribe-btn
- askribe-submit-btn
- askribe-exit-btn
- askribe-skip-btn
- askribe-back
- askribe-forward
- askribe-title
- askribe-description
- askribe-welcome-title
- askribe-welcome-description
- askribe-welcome-btn
- askribe-statement
- askribe-question
- askribe-dropdown
- askribe-option
- askribe-text-response
- askribe-mcq-question
- askribe-scq-question
- askribe-mcq-option
- askribe-scq-option
- askribe-scq-dropdown
- askribe-mcq-dropdown
- askribe-ranking-question
- askribe-ranking-option
- askribe-ranking-option-drag
- askribe-qualitative-question
- askribe-text-response
- askribe-audio-response
- askribe-video-response
- askribe-image-response
- askribe-date-response
- askribe-time-response
- askribe-rating-question
- askribe-rating-option
- askribe-rating-option-number
- askribe-rating-option-thumbsup
- askribe-rating-option-reaction
- askribe-rating-option-lightning
- askribe-rating-option-stars
- askribe-form
- askribe-form-title
- askribe-form-item
- askribe-form-button
- askribe-matrix-question
- askribe-matrix-row-label
- askribe-matrix-col-label
- askribe-matrix-checkbox
- askribe-ux-title
- askribe-ux-description
- askribe-ux-screenshot
- askribe-ux-screenshot-btn
- askribe-ux-feedback-context
- askribe-ux-feedback-context-btn
- askribe-ux-screenrecord
- askribe-ux-screenrecord-btn
- askribe-ux-feedback-text-response
- askribe-signature-title
- askribe-signature-description
- askribe-signature-draw
- askribe-signature-type
- askribe-signature-upload
- askribe-signature-clear-btn
- askribe-upload-title
- askribe-upload-uploaded-file
- askribe-upload-file-input
- askribe-thanks-title
- askribe-thanks-description
- askribe-thanks-btn
