import React, { PureComponent } from 'react';

function _inheritsLoose(subClass, superClass) {
  subClass.prototype = Object.create(superClass.prototype);
  subClass.prototype.constructor = subClass;

  _setPrototypeOf(subClass, superClass);
}

function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };

  return _setPrototypeOf(o, p);
}

function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;

  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }

  return target;
}

function createCommonjsModule(fn, module) {
	return module = { exports: {} }, fn(module, module.exports), module.exports;
}

/** @license React v16.13.1
 * react-is.production.min.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var b="function"===typeof Symbol&&Symbol.for,c=b?Symbol.for("react.element"):60103,d=b?Symbol.for("react.portal"):60106,e=b?Symbol.for("react.fragment"):60107,f=b?Symbol.for("react.strict_mode"):60108,g=b?Symbol.for("react.profiler"):60114,h=b?Symbol.for("react.provider"):60109,k=b?Symbol.for("react.context"):60110,l=b?Symbol.for("react.async_mode"):60111,m=b?Symbol.for("react.concurrent_mode"):60111,n=b?Symbol.for("react.forward_ref"):60112,p=b?Symbol.for("react.suspense"):60113,q=b?
Symbol.for("react.suspense_list"):60120,r=b?Symbol.for("react.memo"):60115,t=b?Symbol.for("react.lazy"):60116,v=b?Symbol.for("react.block"):60121,w=b?Symbol.for("react.fundamental"):60117,x=b?Symbol.for("react.responder"):60118,y=b?Symbol.for("react.scope"):60119;
function z(a){if("object"===typeof a&&null!==a){var u=a.$$typeof;switch(u){case c:switch(a=a.type,a){case l:case m:case e:case g:case f:case p:return a;default:switch(a=a&&a.$$typeof,a){case k:case n:case t:case r:case h:return a;default:return u}}case d:return u}}}function A(a){return z(a)===m}var AsyncMode=l;var ConcurrentMode=m;var ContextConsumer=k;var ContextProvider=h;var Element=c;var ForwardRef=n;var Fragment=e;var Lazy=t;var Memo=r;var Portal=d;
var Profiler=g;var StrictMode=f;var Suspense=p;var isAsyncMode=function(a){return A(a)||z(a)===l};var isConcurrentMode=A;var isContextConsumer=function(a){return z(a)===k};var isContextProvider=function(a){return z(a)===h};var isElement=function(a){return "object"===typeof a&&null!==a&&a.$$typeof===c};var isForwardRef=function(a){return z(a)===n};var isFragment=function(a){return z(a)===e};var isLazy=function(a){return z(a)===t};
var isMemo=function(a){return z(a)===r};var isPortal=function(a){return z(a)===d};var isProfiler=function(a){return z(a)===g};var isStrictMode=function(a){return z(a)===f};var isSuspense=function(a){return z(a)===p};
var isValidElementType=function(a){return "string"===typeof a||"function"===typeof a||a===e||a===m||a===g||a===f||a===p||a===q||"object"===typeof a&&null!==a&&(a.$$typeof===t||a.$$typeof===r||a.$$typeof===h||a.$$typeof===k||a.$$typeof===n||a.$$typeof===w||a.$$typeof===x||a.$$typeof===y||a.$$typeof===v)};var typeOf=z;

var reactIs_production_min = {
	AsyncMode: AsyncMode,
	ConcurrentMode: ConcurrentMode,
	ContextConsumer: ContextConsumer,
	ContextProvider: ContextProvider,
	Element: Element,
	ForwardRef: ForwardRef,
	Fragment: Fragment,
	Lazy: Lazy,
	Memo: Memo,
	Portal: Portal,
	Profiler: Profiler,
	StrictMode: StrictMode,
	Suspense: Suspense,
	isAsyncMode: isAsyncMode,
	isConcurrentMode: isConcurrentMode,
	isContextConsumer: isContextConsumer,
	isContextProvider: isContextProvider,
	isElement: isElement,
	isForwardRef: isForwardRef,
	isFragment: isFragment,
	isLazy: isLazy,
	isMemo: isMemo,
	isPortal: isPortal,
	isProfiler: isProfiler,
	isStrictMode: isStrictMode,
	isSuspense: isSuspense,
	isValidElementType: isValidElementType,
	typeOf: typeOf
};

var reactIs_development = createCommonjsModule(function (module, exports) {



if (process.env.NODE_ENV !== "production") {
  (function() {

// The Symbol used to tag the ReactElement-like types. If there is no native Symbol
// nor polyfill, then a plain number is used for performance.
var hasSymbol = typeof Symbol === 'function' && Symbol.for;
var REACT_ELEMENT_TYPE = hasSymbol ? Symbol.for('react.element') : 0xeac7;
var REACT_PORTAL_TYPE = hasSymbol ? Symbol.for('react.portal') : 0xeaca;
var REACT_FRAGMENT_TYPE = hasSymbol ? Symbol.for('react.fragment') : 0xeacb;
var REACT_STRICT_MODE_TYPE = hasSymbol ? Symbol.for('react.strict_mode') : 0xeacc;
var REACT_PROFILER_TYPE = hasSymbol ? Symbol.for('react.profiler') : 0xead2;
var REACT_PROVIDER_TYPE = hasSymbol ? Symbol.for('react.provider') : 0xeacd;
var REACT_CONTEXT_TYPE = hasSymbol ? Symbol.for('react.context') : 0xeace; // TODO: We don't use AsyncMode or ConcurrentMode anymore. They were temporary
// (unstable) APIs that have been removed. Can we remove the symbols?

var REACT_ASYNC_MODE_TYPE = hasSymbol ? Symbol.for('react.async_mode') : 0xeacf;
var REACT_CONCURRENT_MODE_TYPE = hasSymbol ? Symbol.for('react.concurrent_mode') : 0xeacf;
var REACT_FORWARD_REF_TYPE = hasSymbol ? Symbol.for('react.forward_ref') : 0xead0;
var REACT_SUSPENSE_TYPE = hasSymbol ? Symbol.for('react.suspense') : 0xead1;
var REACT_SUSPENSE_LIST_TYPE = hasSymbol ? Symbol.for('react.suspense_list') : 0xead8;
var REACT_MEMO_TYPE = hasSymbol ? Symbol.for('react.memo') : 0xead3;
var REACT_LAZY_TYPE = hasSymbol ? Symbol.for('react.lazy') : 0xead4;
var REACT_BLOCK_TYPE = hasSymbol ? Symbol.for('react.block') : 0xead9;
var REACT_FUNDAMENTAL_TYPE = hasSymbol ? Symbol.for('react.fundamental') : 0xead5;
var REACT_RESPONDER_TYPE = hasSymbol ? Symbol.for('react.responder') : 0xead6;
var REACT_SCOPE_TYPE = hasSymbol ? Symbol.for('react.scope') : 0xead7;

function isValidElementType(type) {
  return typeof type === 'string' || typeof type === 'function' || // Note: its typeof might be other than 'symbol' or 'number' if it's a polyfill.
  type === REACT_FRAGMENT_TYPE || type === REACT_CONCURRENT_MODE_TYPE || type === REACT_PROFILER_TYPE || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || type === REACT_SUSPENSE_LIST_TYPE || typeof type === 'object' && type !== null && (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE || type.$$typeof === REACT_FUNDAMENTAL_TYPE || type.$$typeof === REACT_RESPONDER_TYPE || type.$$typeof === REACT_SCOPE_TYPE || type.$$typeof === REACT_BLOCK_TYPE);
}

function typeOf(object) {
  if (typeof object === 'object' && object !== null) {
    var $$typeof = object.$$typeof;

    switch ($$typeof) {
      case REACT_ELEMENT_TYPE:
        var type = object.type;

        switch (type) {
          case REACT_ASYNC_MODE_TYPE:
          case REACT_CONCURRENT_MODE_TYPE:
          case REACT_FRAGMENT_TYPE:
          case REACT_PROFILER_TYPE:
          case REACT_STRICT_MODE_TYPE:
          case REACT_SUSPENSE_TYPE:
            return type;

          default:
            var $$typeofType = type && type.$$typeof;

            switch ($$typeofType) {
              case REACT_CONTEXT_TYPE:
              case REACT_FORWARD_REF_TYPE:
              case REACT_LAZY_TYPE:
              case REACT_MEMO_TYPE:
              case REACT_PROVIDER_TYPE:
                return $$typeofType;

              default:
                return $$typeof;
            }

        }

      case REACT_PORTAL_TYPE:
        return $$typeof;
    }
  }

  return undefined;
} // AsyncMode is deprecated along with isAsyncMode

var AsyncMode = REACT_ASYNC_MODE_TYPE;
var ConcurrentMode = REACT_CONCURRENT_MODE_TYPE;
var ContextConsumer = REACT_CONTEXT_TYPE;
var ContextProvider = REACT_PROVIDER_TYPE;
var Element = REACT_ELEMENT_TYPE;
var ForwardRef = REACT_FORWARD_REF_TYPE;
var Fragment = REACT_FRAGMENT_TYPE;
var Lazy = REACT_LAZY_TYPE;
var Memo = REACT_MEMO_TYPE;
var Portal = REACT_PORTAL_TYPE;
var Profiler = REACT_PROFILER_TYPE;
var StrictMode = REACT_STRICT_MODE_TYPE;
var Suspense = REACT_SUSPENSE_TYPE;
var hasWarnedAboutDeprecatedIsAsyncMode = false; // AsyncMode should be deprecated

function isAsyncMode(object) {
  {
    if (!hasWarnedAboutDeprecatedIsAsyncMode) {
      hasWarnedAboutDeprecatedIsAsyncMode = true; // Using console['warn'] to evade Babel and ESLint

      console['warn']('The ReactIs.isAsyncMode() alias has been deprecated, ' + 'and will be removed in React 17+. Update your code to use ' + 'ReactIs.isConcurrentMode() instead. It has the exact same API.');
    }
  }

  return isConcurrentMode(object) || typeOf(object) === REACT_ASYNC_MODE_TYPE;
}
function isConcurrentMode(object) {
  return typeOf(object) === REACT_CONCURRENT_MODE_TYPE;
}
function isContextConsumer(object) {
  return typeOf(object) === REACT_CONTEXT_TYPE;
}
function isContextProvider(object) {
  return typeOf(object) === REACT_PROVIDER_TYPE;
}
function isElement(object) {
  return typeof object === 'object' && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
}
function isForwardRef(object) {
  return typeOf(object) === REACT_FORWARD_REF_TYPE;
}
function isFragment(object) {
  return typeOf(object) === REACT_FRAGMENT_TYPE;
}
function isLazy(object) {
  return typeOf(object) === REACT_LAZY_TYPE;
}
function isMemo(object) {
  return typeOf(object) === REACT_MEMO_TYPE;
}
function isPortal(object) {
  return typeOf(object) === REACT_PORTAL_TYPE;
}
function isProfiler(object) {
  return typeOf(object) === REACT_PROFILER_TYPE;
}
function isStrictMode(object) {
  return typeOf(object) === REACT_STRICT_MODE_TYPE;
}
function isSuspense(object) {
  return typeOf(object) === REACT_SUSPENSE_TYPE;
}

exports.AsyncMode = AsyncMode;
exports.ConcurrentMode = ConcurrentMode;
exports.ContextConsumer = ContextConsumer;
exports.ContextProvider = ContextProvider;
exports.Element = Element;
exports.ForwardRef = ForwardRef;
exports.Fragment = Fragment;
exports.Lazy = Lazy;
exports.Memo = Memo;
exports.Portal = Portal;
exports.Profiler = Profiler;
exports.StrictMode = StrictMode;
exports.Suspense = Suspense;
exports.isAsyncMode = isAsyncMode;
exports.isConcurrentMode = isConcurrentMode;
exports.isContextConsumer = isContextConsumer;
exports.isContextProvider = isContextProvider;
exports.isElement = isElement;
exports.isForwardRef = isForwardRef;
exports.isFragment = isFragment;
exports.isLazy = isLazy;
exports.isMemo = isMemo;
exports.isPortal = isPortal;
exports.isProfiler = isProfiler;
exports.isStrictMode = isStrictMode;
exports.isSuspense = isSuspense;
exports.isValidElementType = isValidElementType;
exports.typeOf = typeOf;
  })();
}
});

var reactIs = createCommonjsModule(function (module) {

if (process.env.NODE_ENV === 'production') {
  module.exports = reactIs_production_min;
} else {
  module.exports = reactIs_development;
}
});

/*
object-assign
(c) Sindre Sorhus
@license MIT
*/
/* eslint-disable no-unused-vars */
var getOwnPropertySymbols = Object.getOwnPropertySymbols;
var hasOwnProperty = Object.prototype.hasOwnProperty;
var propIsEnumerable = Object.prototype.propertyIsEnumerable;

function toObject(val) {
	if (val === null || val === undefined) {
		throw new TypeError('Object.assign cannot be called with null or undefined');
	}

	return Object(val);
}

function shouldUseNative() {
	try {
		if (!Object.assign) {
			return false;
		}

		// Detect buggy property enumeration order in older V8 versions.

		// https://bugs.chromium.org/p/v8/issues/detail?id=4118
		var test1 = new String('abc');  // eslint-disable-line no-new-wrappers
		test1[5] = 'de';
		if (Object.getOwnPropertyNames(test1)[0] === '5') {
			return false;
		}

		// https://bugs.chromium.org/p/v8/issues/detail?id=3056
		var test2 = {};
		for (var i = 0; i < 10; i++) {
			test2['_' + String.fromCharCode(i)] = i;
		}
		var order2 = Object.getOwnPropertyNames(test2).map(function (n) {
			return test2[n];
		});
		if (order2.join('') !== '0123456789') {
			return false;
		}

		// https://bugs.chromium.org/p/v8/issues/detail?id=3056
		var test3 = {};
		'abcdefghijklmnopqrst'.split('').forEach(function (letter) {
			test3[letter] = letter;
		});
		if (Object.keys(Object.assign({}, test3)).join('') !==
				'abcdefghijklmnopqrst') {
			return false;
		}

		return true;
	} catch (err) {
		// We don't expect any of the above to throw, but better to be safe.
		return false;
	}
}

var objectAssign = shouldUseNative() ? Object.assign : function (target, source) {
	var from;
	var to = toObject(target);
	var symbols;

	for (var s = 1; s < arguments.length; s++) {
		from = Object(arguments[s]);

		for (var key in from) {
			if (hasOwnProperty.call(from, key)) {
				to[key] = from[key];
			}
		}

		if (getOwnPropertySymbols) {
			symbols = getOwnPropertySymbols(from);
			for (var i = 0; i < symbols.length; i++) {
				if (propIsEnumerable.call(from, symbols[i])) {
					to[symbols[i]] = from[symbols[i]];
				}
			}
		}
	}

	return to;
};

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

var ReactPropTypesSecret = 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED';

var ReactPropTypesSecret_1 = ReactPropTypesSecret;

var printWarning = function() {};

if (process.env.NODE_ENV !== 'production') {
  var ReactPropTypesSecret$1 = ReactPropTypesSecret_1;
  var loggedTypeFailures = {};
  var has = Function.call.bind(Object.prototype.hasOwnProperty);

  printWarning = function(text) {
    var message = 'Warning: ' + text;
    if (typeof console !== 'undefined') {
      console.error(message);
    }
    try {
      // --- Welcome to debugging React ---
      // This error was thrown as a convenience so that you can use this stack
      // to find the callsite that caused this warning to fire.
      throw new Error(message);
    } catch (x) {}
  };
}

/**
 * Assert that the values match with the type specs.
 * Error messages are memorized and will only be shown once.
 *
 * @param {object} typeSpecs Map of name to a ReactPropType
 * @param {object} values Runtime values that need to be type-checked
 * @param {string} location e.g. "prop", "context", "child context"
 * @param {string} componentName Name of the component for error messages.
 * @param {?Function} getStack Returns the component stack.
 * @private
 */
function checkPropTypes(typeSpecs, values, location, componentName, getStack) {
  if (process.env.NODE_ENV !== 'production') {
    for (var typeSpecName in typeSpecs) {
      if (has(typeSpecs, typeSpecName)) {
        var error;
        // Prop type validation may throw. In case they do, we don't want to
        // fail the render phase where it didn't fail before. So we log it.
        // After these have been cleaned up, we'll let them throw.
        try {
          // This is intentionally an invariant that gets caught. It's the same
          // behavior as without this statement except with a better message.
          if (typeof typeSpecs[typeSpecName] !== 'function') {
            var err = Error(
              (componentName || 'React class') + ': ' + location + ' type `' + typeSpecName + '` is invalid; ' +
              'it must be a function, usually from the `prop-types` package, but received `' + typeof typeSpecs[typeSpecName] + '`.'
            );
            err.name = 'Invariant Violation';
            throw err;
          }
          error = typeSpecs[typeSpecName](values, typeSpecName, componentName, location, null, ReactPropTypesSecret$1);
        } catch (ex) {
          error = ex;
        }
        if (error && !(error instanceof Error)) {
          printWarning(
            (componentName || 'React class') + ': type specification of ' +
            location + ' `' + typeSpecName + '` is invalid; the type checker ' +
            'function must return `null` or an `Error` but returned a ' + typeof error + '. ' +
            'You may have forgotten to pass an argument to the type checker ' +
            'creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and ' +
            'shape all require an argument).'
          );
        }
        if (error instanceof Error && !(error.message in loggedTypeFailures)) {
          // Only monitor this failure once because there tends to be a lot of the
          // same error.
          loggedTypeFailures[error.message] = true;

          var stack = getStack ? getStack() : '';

          printWarning(
            'Failed ' + location + ' type: ' + error.message + (stack != null ? stack : '')
          );
        }
      }
    }
  }
}

/**
 * Resets warning cache when testing.
 *
 * @private
 */
checkPropTypes.resetWarningCache = function() {
  if (process.env.NODE_ENV !== 'production') {
    loggedTypeFailures = {};
  }
};

var checkPropTypes_1 = checkPropTypes;

var has$1 = Function.call.bind(Object.prototype.hasOwnProperty);
var printWarning$1 = function() {};

if (process.env.NODE_ENV !== 'production') {
  printWarning$1 = function(text) {
    var message = 'Warning: ' + text;
    if (typeof console !== 'undefined') {
      console.error(message);
    }
    try {
      // --- Welcome to debugging React ---
      // This error was thrown as a convenience so that you can use this stack
      // to find the callsite that caused this warning to fire.
      throw new Error(message);
    } catch (x) {}
  };
}

function emptyFunctionThatReturnsNull() {
  return null;
}

var factoryWithTypeCheckers = function(isValidElement, throwOnDirectAccess) {
  /* global Symbol */
  var ITERATOR_SYMBOL = typeof Symbol === 'function' && Symbol.iterator;
  var FAUX_ITERATOR_SYMBOL = '@@iterator'; // Before Symbol spec.

  /**
   * Returns the iterator method function contained on the iterable object.
   *
   * Be sure to invoke the function with the iterable as context:
   *
   *     var iteratorFn = getIteratorFn(myIterable);
   *     if (iteratorFn) {
   *       var iterator = iteratorFn.call(myIterable);
   *       ...
   *     }
   *
   * @param {?object} maybeIterable
   * @return {?function}
   */
  function getIteratorFn(maybeIterable) {
    var iteratorFn = maybeIterable && (ITERATOR_SYMBOL && maybeIterable[ITERATOR_SYMBOL] || maybeIterable[FAUX_ITERATOR_SYMBOL]);
    if (typeof iteratorFn === 'function') {
      return iteratorFn;
    }
  }

  /**
   * Collection of methods that allow declaration and validation of props that are
   * supplied to React components. Example usage:
   *
   *   var Props = require('ReactPropTypes');
   *   var MyArticle = React.createClass({
   *     propTypes: {
   *       // An optional string prop named "description".
   *       description: Props.string,
   *
   *       // A required enum prop named "category".
   *       category: Props.oneOf(['News','Photos']).isRequired,
   *
   *       // A prop named "dialog" that requires an instance of Dialog.
   *       dialog: Props.instanceOf(Dialog).isRequired
   *     },
   *     render: function() { ... }
   *   });
   *
   * A more formal specification of how these methods are used:
   *
   *   type := array|bool|func|object|number|string|oneOf([...])|instanceOf(...)
   *   decl := ReactPropTypes.{type}(.isRequired)?
   *
   * Each and every declaration produces a function with the same signature. This
   * allows the creation of custom validation functions. For example:
   *
   *  var MyLink = React.createClass({
   *    propTypes: {
   *      // An optional string or URI prop named "href".
   *      href: function(props, propName, componentName) {
   *        var propValue = props[propName];
   *        if (propValue != null && typeof propValue !== 'string' &&
   *            !(propValue instanceof URI)) {
   *          return new Error(
   *            'Expected a string or an URI for ' + propName + ' in ' +
   *            componentName
   *          );
   *        }
   *      }
   *    },
   *    render: function() {...}
   *  });
   *
   * @internal
   */

  var ANONYMOUS = '<<anonymous>>';

  // Important!
  // Keep this list in sync with production version in `./factoryWithThrowingShims.js`.
  var ReactPropTypes = {
    array: createPrimitiveTypeChecker('array'),
    bool: createPrimitiveTypeChecker('boolean'),
    func: createPrimitiveTypeChecker('function'),
    number: createPrimitiveTypeChecker('number'),
    object: createPrimitiveTypeChecker('object'),
    string: createPrimitiveTypeChecker('string'),
    symbol: createPrimitiveTypeChecker('symbol'),

    any: createAnyTypeChecker(),
    arrayOf: createArrayOfTypeChecker,
    element: createElementTypeChecker(),
    elementType: createElementTypeTypeChecker(),
    instanceOf: createInstanceTypeChecker,
    node: createNodeChecker(),
    objectOf: createObjectOfTypeChecker,
    oneOf: createEnumTypeChecker,
    oneOfType: createUnionTypeChecker,
    shape: createShapeTypeChecker,
    exact: createStrictShapeTypeChecker,
  };

  /**
   * inlined Object.is polyfill to avoid requiring consumers ship their own
   * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
   */
  /*eslint-disable no-self-compare*/
  function is(x, y) {
    // SameValue algorithm
    if (x === y) {
      // Steps 1-5, 7-10
      // Steps 6.b-6.e: +0 != -0
      return x !== 0 || 1 / x === 1 / y;
    } else {
      // Step 6.a: NaN == NaN
      return x !== x && y !== y;
    }
  }
  /*eslint-enable no-self-compare*/

  /**
   * We use an Error-like object for backward compatibility as people may call
   * PropTypes directly and inspect their output. However, we don't use real
   * Errors anymore. We don't inspect their stack anyway, and creating them
   * is prohibitively expensive if they are created too often, such as what
   * happens in oneOfType() for any type before the one that matched.
   */
  function PropTypeError(message) {
    this.message = message;
    this.stack = '';
  }
  // Make `instanceof Error` still work for returned errors.
  PropTypeError.prototype = Error.prototype;

  function createChainableTypeChecker(validate) {
    if (process.env.NODE_ENV !== 'production') {
      var manualPropTypeCallCache = {};
      var manualPropTypeWarningCount = 0;
    }
    function checkType(isRequired, props, propName, componentName, location, propFullName, secret) {
      componentName = componentName || ANONYMOUS;
      propFullName = propFullName || propName;

      if (secret !== ReactPropTypesSecret_1) {
        if (throwOnDirectAccess) {
          // New behavior only for users of `prop-types` package
          var err = new Error(
            'Calling PropTypes validators directly is not supported by the `prop-types` package. ' +
            'Use `PropTypes.checkPropTypes()` to call them. ' +
            'Read more at http://fb.me/use-check-prop-types'
          );
          err.name = 'Invariant Violation';
          throw err;
        } else if (process.env.NODE_ENV !== 'production' && typeof console !== 'undefined') {
          // Old behavior for people using React.PropTypes
          var cacheKey = componentName + ':' + propName;
          if (
            !manualPropTypeCallCache[cacheKey] &&
            // Avoid spamming the console because they are often not actionable except for lib authors
            manualPropTypeWarningCount < 3
          ) {
            printWarning$1(
              'You are manually calling a React.PropTypes validation ' +
              'function for the `' + propFullName + '` prop on `' + componentName  + '`. This is deprecated ' +
              'and will throw in the standalone `prop-types` package. ' +
              'You may be seeing this warning due to a third-party PropTypes ' +
              'library. See https://fb.me/react-warning-dont-call-proptypes ' + 'for details.'
            );
            manualPropTypeCallCache[cacheKey] = true;
            manualPropTypeWarningCount++;
          }
        }
      }
      if (props[propName] == null) {
        if (isRequired) {
          if (props[propName] === null) {
            return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required ' + ('in `' + componentName + '`, but its value is `null`.'));
          }
          return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required in ' + ('`' + componentName + '`, but its value is `undefined`.'));
        }
        return null;
      } else {
        return validate(props, propName, componentName, location, propFullName);
      }
    }

    var chainedCheckType = checkType.bind(null, false);
    chainedCheckType.isRequired = checkType.bind(null, true);

    return chainedCheckType;
  }

  function createPrimitiveTypeChecker(expectedType) {
    function validate(props, propName, componentName, location, propFullName, secret) {
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== expectedType) {
        // `propValue` being instance of, say, date/regexp, pass the 'object'
        // check, but we can offer a more precise error message here rather than
        // 'of type `object`'.
        var preciseType = getPreciseType(propValue);

        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + preciseType + '` supplied to `' + componentName + '`, expected ') + ('`' + expectedType + '`.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createAnyTypeChecker() {
    return createChainableTypeChecker(emptyFunctionThatReturnsNull);
  }

  function createArrayOfTypeChecker(typeChecker) {
    function validate(props, propName, componentName, location, propFullName) {
      if (typeof typeChecker !== 'function') {
        return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside arrayOf.');
      }
      var propValue = props[propName];
      if (!Array.isArray(propValue)) {
        var propType = getPropType(propValue);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an array.'));
      }
      for (var i = 0; i < propValue.length; i++) {
        var error = typeChecker(propValue, i, componentName, location, propFullName + '[' + i + ']', ReactPropTypesSecret_1);
        if (error instanceof Error) {
          return error;
        }
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createElementTypeChecker() {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      if (!isValidElement(propValue)) {
        var propType = getPropType(propValue);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createElementTypeTypeChecker() {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      if (!reactIs.isValidElementType(propValue)) {
        var propType = getPropType(propValue);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement type.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createInstanceTypeChecker(expectedClass) {
    function validate(props, propName, componentName, location, propFullName) {
      if (!(props[propName] instanceof expectedClass)) {
        var expectedClassName = expectedClass.name || ANONYMOUS;
        var actualClassName = getClassName(props[propName]);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + actualClassName + '` supplied to `' + componentName + '`, expected ') + ('instance of `' + expectedClassName + '`.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createEnumTypeChecker(expectedValues) {
    if (!Array.isArray(expectedValues)) {
      if (process.env.NODE_ENV !== 'production') {
        if (arguments.length > 1) {
          printWarning$1(
            'Invalid arguments supplied to oneOf, expected an array, got ' + arguments.length + ' arguments. ' +
            'A common mistake is to write oneOf(x, y, z) instead of oneOf([x, y, z]).'
          );
        } else {
          printWarning$1('Invalid argument supplied to oneOf, expected an array.');
        }
      }
      return emptyFunctionThatReturnsNull;
    }

    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      for (var i = 0; i < expectedValues.length; i++) {
        if (is(propValue, expectedValues[i])) {
          return null;
        }
      }

      var valuesString = JSON.stringify(expectedValues, function replacer(key, value) {
        var type = getPreciseType(value);
        if (type === 'symbol') {
          return String(value);
        }
        return value;
      });
      return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of value `' + String(propValue) + '` ' + ('supplied to `' + componentName + '`, expected one of ' + valuesString + '.'));
    }
    return createChainableTypeChecker(validate);
  }

  function createObjectOfTypeChecker(typeChecker) {
    function validate(props, propName, componentName, location, propFullName) {
      if (typeof typeChecker !== 'function') {
        return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside objectOf.');
      }
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== 'object') {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an object.'));
      }
      for (var key in propValue) {
        if (has$1(propValue, key)) {
          var error = typeChecker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret_1);
          if (error instanceof Error) {
            return error;
          }
        }
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createUnionTypeChecker(arrayOfTypeCheckers) {
    if (!Array.isArray(arrayOfTypeCheckers)) {
      process.env.NODE_ENV !== 'production' ? printWarning$1('Invalid argument supplied to oneOfType, expected an instance of array.') : void 0;
      return emptyFunctionThatReturnsNull;
    }

    for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
      var checker = arrayOfTypeCheckers[i];
      if (typeof checker !== 'function') {
        printWarning$1(
          'Invalid argument supplied to oneOfType. Expected an array of check functions, but ' +
          'received ' + getPostfixForTypeWarning(checker) + ' at index ' + i + '.'
        );
        return emptyFunctionThatReturnsNull;
      }
    }

    function validate(props, propName, componentName, location, propFullName) {
      for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
        var checker = arrayOfTypeCheckers[i];
        if (checker(props, propName, componentName, location, propFullName, ReactPropTypesSecret_1) == null) {
          return null;
        }
      }

      return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`.'));
    }
    return createChainableTypeChecker(validate);
  }

  function createNodeChecker() {
    function validate(props, propName, componentName, location, propFullName) {
      if (!isNode(props[propName])) {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`, expected a ReactNode.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createShapeTypeChecker(shapeTypes) {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== 'object') {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
      }
      for (var key in shapeTypes) {
        var checker = shapeTypes[key];
        if (!checker) {
          continue;
        }
        var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret_1);
        if (error) {
          return error;
        }
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createStrictShapeTypeChecker(shapeTypes) {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== 'object') {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
      }
      // We need to check all keys in case some are required but missing from
      // props.
      var allKeys = objectAssign({}, props[propName], shapeTypes);
      for (var key in allKeys) {
        var checker = shapeTypes[key];
        if (!checker) {
          return new PropTypeError(
            'Invalid ' + location + ' `' + propFullName + '` key `' + key + '` supplied to `' + componentName + '`.' +
            '\nBad object: ' + JSON.stringify(props[propName], null, '  ') +
            '\nValid keys: ' +  JSON.stringify(Object.keys(shapeTypes), null, '  ')
          );
        }
        var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret_1);
        if (error) {
          return error;
        }
      }
      return null;
    }

    return createChainableTypeChecker(validate);
  }

  function isNode(propValue) {
    switch (typeof propValue) {
      case 'number':
      case 'string':
      case 'undefined':
        return true;
      case 'boolean':
        return !propValue;
      case 'object':
        if (Array.isArray(propValue)) {
          return propValue.every(isNode);
        }
        if (propValue === null || isValidElement(propValue)) {
          return true;
        }

        var iteratorFn = getIteratorFn(propValue);
        if (iteratorFn) {
          var iterator = iteratorFn.call(propValue);
          var step;
          if (iteratorFn !== propValue.entries) {
            while (!(step = iterator.next()).done) {
              if (!isNode(step.value)) {
                return false;
              }
            }
          } else {
            // Iterator will provide entry [k,v] tuples rather than values.
            while (!(step = iterator.next()).done) {
              var entry = step.value;
              if (entry) {
                if (!isNode(entry[1])) {
                  return false;
                }
              }
            }
          }
        } else {
          return false;
        }

        return true;
      default:
        return false;
    }
  }

  function isSymbol(propType, propValue) {
    // Native Symbol.
    if (propType === 'symbol') {
      return true;
    }

    // falsy value can't be a Symbol
    if (!propValue) {
      return false;
    }

    // 19.4.3.5 Symbol.prototype[@@toStringTag] === 'Symbol'
    if (propValue['@@toStringTag'] === 'Symbol') {
      return true;
    }

    // Fallback for non-spec compliant Symbols which are polyfilled.
    if (typeof Symbol === 'function' && propValue instanceof Symbol) {
      return true;
    }

    return false;
  }

  // Equivalent of `typeof` but with special handling for array and regexp.
  function getPropType(propValue) {
    var propType = typeof propValue;
    if (Array.isArray(propValue)) {
      return 'array';
    }
    if (propValue instanceof RegExp) {
      // Old webkits (at least until Android 4.0) return 'function' rather than
      // 'object' for typeof a RegExp. We'll normalize this here so that /bla/
      // passes PropTypes.object.
      return 'object';
    }
    if (isSymbol(propType, propValue)) {
      return 'symbol';
    }
    return propType;
  }

  // This handles more types than `getPropType`. Only used for error messages.
  // See `createPrimitiveTypeChecker`.
  function getPreciseType(propValue) {
    if (typeof propValue === 'undefined' || propValue === null) {
      return '' + propValue;
    }
    var propType = getPropType(propValue);
    if (propType === 'object') {
      if (propValue instanceof Date) {
        return 'date';
      } else if (propValue instanceof RegExp) {
        return 'regexp';
      }
    }
    return propType;
  }

  // Returns a string that is postfixed to a warning about an invalid type.
  // For example, "undefined" or "of type array"
  function getPostfixForTypeWarning(value) {
    var type = getPreciseType(value);
    switch (type) {
      case 'array':
      case 'object':
        return 'an ' + type;
      case 'boolean':
      case 'date':
      case 'regexp':
        return 'a ' + type;
      default:
        return type;
    }
  }

  // Returns class name of the object, if any.
  function getClassName(propValue) {
    if (!propValue.constructor || !propValue.constructor.name) {
      return ANONYMOUS;
    }
    return propValue.constructor.name;
  }

  ReactPropTypes.checkPropTypes = checkPropTypes_1;
  ReactPropTypes.resetWarningCache = checkPropTypes_1.resetWarningCache;
  ReactPropTypes.PropTypes = ReactPropTypes;

  return ReactPropTypes;
};

function emptyFunction() {}
function emptyFunctionWithReset() {}
emptyFunctionWithReset.resetWarningCache = emptyFunction;

var factoryWithThrowingShims = function() {
  function shim(props, propName, componentName, location, propFullName, secret) {
    if (secret === ReactPropTypesSecret_1) {
      // It is still safe when called from React.
      return;
    }
    var err = new Error(
      'Calling PropTypes validators directly is not supported by the `prop-types` package. ' +
      'Use PropTypes.checkPropTypes() to call them. ' +
      'Read more at http://fb.me/use-check-prop-types'
    );
    err.name = 'Invariant Violation';
    throw err;
  }  shim.isRequired = shim;
  function getShim() {
    return shim;
  }  // Important!
  // Keep this list in sync with production version in `./factoryWithTypeCheckers.js`.
  var ReactPropTypes = {
    array: shim,
    bool: shim,
    func: shim,
    number: shim,
    object: shim,
    string: shim,
    symbol: shim,

    any: shim,
    arrayOf: getShim,
    element: shim,
    elementType: shim,
    instanceOf: getShim,
    node: shim,
    objectOf: getShim,
    oneOf: getShim,
    oneOfType: getShim,
    shape: getShim,
    exact: getShim,

    checkPropTypes: emptyFunctionWithReset,
    resetWarningCache: emptyFunction
  };

  ReactPropTypes.PropTypes = ReactPropTypes;

  return ReactPropTypes;
};

var propTypes = createCommonjsModule(function (module) {
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

if (process.env.NODE_ENV !== 'production') {
  var ReactIs = reactIs;

  // By explicitly using `prop-types` you are opting into new development behavior.
  // http://fb.me/prop-types-in-prod
  var throwOnDirectAccess = true;
  module.exports = factoryWithTypeCheckers(ReactIs.isElement, throwOnDirectAccess);
} else {
  // By explicitly using `prop-types` you are opting into new production behavior.
  // http://fb.me/prop-types-in-prod
  module.exports = factoryWithThrowingShims();
}
});

var History = /*#__PURE__*/function () {
  function History(undoLimit, debug) {
    if (undoLimit === void 0) {
      undoLimit = 10;
    }

    if (debug === void 0) {
      debug = false;
    }

    this.undoLimit = undoLimit;
    this.undoList = [];
    this.redoList = [];
    this.current = null;
    this.debug = debug;
  }

  var _proto = History.prototype;

  _proto.getUndoLimit = function getUndoLimit() {
    return this.undoLimit;
  };

  _proto.getCurrent = function getCurrent() {
    return this.current;
  };

  _proto.keep = function keep(obj) {
    try {
      this.redoList = [];

      if (this.current) {
        this.undoList.push(this.current);
      }

      if (this.undoList.length > this.undoLimit) {
        this.undoList.shift();
      }

      this.current = obj;
    } finally {
      this.print();
    }
  };

  _proto.undo = function undo() {
    try {
      if (this.current) {
        this.redoList.push(this.current);

        if (this.redoList.length > this.undoLimit) {
          this.redoList.shift();
        }

        if (this.undoList.length === 0) this.current = null;
      }

      if (this.undoList.length > 0) {
        this.current = this.undoList.pop();
        return this.current;
      }

      return null;
    } finally {
      this.print();
    }
  };

  _proto.redo = function redo() {
    try {
      if (this.redoList.length > 0) {
        if (this.current) this.undoList.push(this.current);
        this.current = this.redoList.pop();
        return this.current;
      }

      return null;
    } finally {
      this.print();
    }
  };

  _proto.canRedo = function canRedo() {
    return this.redoList.length > 0;
  };

  _proto.canUndo = function canUndo() {
    return this.undoList.length > 0 || this.current !== null;
  };

  _proto.clear = function clear() {
    this.undoList = [];
    this.redoList = [];
    this.current = null;
    this.print();
  };

  _proto.print = function print() {
    if (this.debug) {
      console.log(this.undoList, ' -> ' + this.current + ' <- ', this.redoList.slice(0).reverse());
    }
  };

  return History;
}();

var linearDistance = function linearDistance(point1, point2) {
  var xs = point2.x - point1.x;
  var ys = point2.y - point1.y;
  return Math.sqrt(xs * xs + ys * ys);
};
var uuid4 = function uuid4() {
  var uuid = '',
      ii;

  for (ii = 0; ii < 32; ii += 1) {
    switch (ii) {
      case 8:
      case 20:
        uuid += '-';
        uuid += (Math.random() * 16 | 0).toString(16);
        break;

      case 12:
        uuid += '-';
        uuid += '4';
        break;

      case 16:
        uuid += '-';
        uuid += (Math.random() * 4 | 8).toString(16);
        break;

      default:
        uuid += (Math.random() * 16 | 0).toString(16);
    }
  }

  return uuid;
};
var hexToRgbA = function hexToRgbA(hex, opacity) {
  if (!opacity) {
    opacity = 0.4;
  }

  var c;

  if (/^#([A-Fa-f0-9]{3}){1,2}$/.test(hex)) {
    c = hex.substring(1).split('');

    if (c.length == 3) {
      c = [c[0], c[0], c[1], c[1], c[2], c[2]];
    }

    c = '0x' + c.join('');
    return 'rgba(' + [c >> 16 & 255, c >> 8 & 255, c & 255].join(',') + ',' + opacity + ')';
  }

  throw new Error('Bad Hex');
};
var colorNameToHex = function colorNameToHex(color) {
  var colors = {
    "aliceblue": "#f0f8ff",
    "antiquewhite": "#faebd7",
    "aqua": "#00ffff",
    "aquamarine": "#7fffd4",
    "azure": "#f0ffff",
    "beige": "#f5f5dc",
    "bisque": "#ffe4c4",
    "black": "#000000",
    "blanchedalmond": "#ffebcd",
    "blue": "#0000ff",
    "blueviolet": "#8a2be2",
    "brown": "#a52a2a",
    "burlywood": "#deb887",
    "cadetblue": "#5f9ea0",
    "chartreuse": "#7fff00",
    "chocolate": "#d2691e",
    "coral": "#ff7f50",
    "cornflowerblue": "#6495ed",
    "cornsilk": "#fff8dc",
    "crimson": "#dc143c",
    "cyan": "#00ffff",
    "darkblue": "#00008b",
    "darkcyan": "#008b8b",
    "darkgoldenrod": "#b8860b",
    "darkgray": "#a9a9a9",
    "darkgreen": "#006400",
    "darkkhaki": "#bdb76b",
    "darkmagenta": "#8b008b",
    "darkolivegreen": "#556b2f",
    "darkorange": "#ff8c00",
    "darkorchid": "#9932cc",
    "darkred": "#8b0000",
    "darksalmon": "#e9967a",
    "darkseagreen": "#8fbc8f",
    "darkslateblue": "#483d8b",
    "darkslategray": "#2f4f4f",
    "darkturquoise": "#00ced1",
    "darkviolet": "#9400d3",
    "deeppink": "#ff1493",
    "deepskyblue": "#00bfff",
    "dimgray": "#696969",
    "dodgerblue": "#1e90ff",
    "firebrick": "#b22222",
    "floralwhite": "#fffaf0",
    "forestgreen": "#228b22",
    "fuchsia": "#ff00ff",
    "gainsboro": "#dcdcdc",
    "ghostwhite": "#f8f8ff",
    "gold": "#ffd700",
    "goldenrod": "#daa520",
    "gray": "#808080",
    "green": "#008000",
    "greenyellow": "#adff2f",
    "honeydew": "#f0fff0",
    "hotpink": "#ff69b4",
    "indianred ": "#cd5c5c",
    "indigo": "#4b0082",
    "ivory": "#fffff0",
    "khaki": "#f0e68c",
    "lavender": "#e6e6fa",
    "lavenderblush": "#fff0f5",
    "lawngreen": "#7cfc00",
    "lemonchiffon": "#fffacd",
    "lightblue": "#add8e6",
    "lightcoral": "#f08080",
    "lightcyan": "#e0ffff",
    "lightgoldenrodyellow": "#fafad2",
    "lightgrey": "#d3d3d3",
    "lightgreen": "#90ee90",
    "lightpink": "#ffb6c1",
    "lightsalmon": "#ffa07a",
    "lightseagreen": "#20b2aa",
    "lightskyblue": "#87cefa",
    "lightslategray": "#778899",
    "lightsteelblue": "#b0c4de",
    "lightyellow": "#ffffe0",
    "lime": "#00ff00",
    "limegreen": "#32cd32",
    "linen": "#faf0e6",
    "magenta": "#ff00ff",
    "maroon": "#800000",
    "mediumaquamarine": "#66cdaa",
    "mediumblue": "#0000cd",
    "mediumorchid": "#ba55d3",
    "mediumpurple": "#9370d8",
    "mediumseagreen": "#3cb371",
    "mediumslateblue": "#7b68ee",
    "mediumspringgreen": "#00fa9a",
    "mediumturquoise": "#48d1cc",
    "mediumvioletred": "#c71585",
    "midnightblue": "#191970",
    "mintcream": "#f5fffa",
    "mistyrose": "#ffe4e1",
    "moccasin": "#ffe4b5",
    "navajowhite": "#ffdead",
    "navy": "#000080",
    "oldlace": "#fdf5e6",
    "olive": "#808000",
    "olivedrab": "#6b8e23",
    "orange": "#ffa500",
    "orangered": "#ff4500",
    "orchid": "#da70d6",
    "palegoldenrod": "#eee8aa",
    "palegreen": "#98fb98",
    "paleturquoise": "#afeeee",
    "palevioletred": "#d87093",
    "papayawhip": "#ffefd5",
    "peachpuff": "#ffdab9",
    "peru": "#cd853f",
    "pink": "#ffc0cb",
    "plum": "#dda0dd",
    "powderblue": "#b0e0e6",
    "purple": "#800080",
    "rebeccapurple": "#663399",
    "red": "#ff0000",
    "rosybrown": "#bc8f8f",
    "royalblue": "#4169e1",
    "saddlebrown": "#8b4513",
    "salmon": "#fa8072",
    "sandybrown": "#f4a460",
    "seagreen": "#2e8b57",
    "seashell": "#fff5ee",
    "sienna": "#a0522d",
    "silver": "#c0c0c0",
    "skyblue": "#87ceeb",
    "slateblue": "#6a5acd",
    "slategray": "#708090",
    "snow": "#fffafa",
    "springgreen": "#00ff7f",
    "steelblue": "#4682b4",
    "tan": "#d2b48c",
    "teal": "#008080",
    "thistle": "#d8bfd8",
    "tomato": "#ff6347",
    "turquoise": "#40e0d0",
    "violet": "#ee82ee",
    "wheat": "#f5deb3",
    "white": "#ffffff",
    "whitesmoke": "#f5f5f5",
    "yellow": "#ffff00",
    "yellowgreen": "#9acd32"
  };
  if (typeof colors[color.toLowerCase()] != 'undefined') return colors[color.toLowerCase()];
  return false;
};

var FabricCanvasTool = /*#__PURE__*/function () {
  function FabricCanvasTool(canvas) {
    this._canvas = canvas;
  }

  var _proto = FabricCanvasTool.prototype;

  _proto.configureCanvas = function configureCanvas(props) {};

  _proto.doMouseUp = function doMouseUp(event) {};

  _proto.doMouseDown = function doMouseDown(event) {};

  _proto.doMouseMove = function doMouseMove(event) {};

  _proto.doMouseOut = function doMouseOut(event) {};

  return FabricCanvasTool;
}();

var Select = /*#__PURE__*/function (_FabricCanvasTool) {
  _inheritsLoose(Select, _FabricCanvasTool);

  function Select() {
    return _FabricCanvasTool.apply(this, arguments) || this;
  }

  var _proto = Select.prototype;

  _proto.configureCanvas = function configureCanvas(props) {
    var canvas = this._canvas;
    canvas.isDrawingMode = false;
    canvas.selection = true;
    canvas.forEachObject(function (o) {
      o.selectable = o.evented = true;
    });
  };

  return Select;
}(FabricCanvasTool);

var Pencil = /*#__PURE__*/function (_FabricCanvasTool) {
  _inheritsLoose(Pencil, _FabricCanvasTool);

  function Pencil() {
    return _FabricCanvasTool.apply(this, arguments) || this;
  }

  var _proto = Pencil.prototype;

  _proto.configureCanvas = function configureCanvas(props) {
    this._canvas.isDrawingMode = true;
    this._canvas.freeDrawingBrush.width = props.lineWidth;
    this._canvas.freeDrawingBrush.color = props.lineColor;
  };

  return Pencil;
}(FabricCanvasTool);

var fabric = require('fabric').fabric;

var Line = /*#__PURE__*/function (_FabricCanvasTool) {
  _inheritsLoose(Line, _FabricCanvasTool);

  function Line() {
    return _FabricCanvasTool.apply(this, arguments) || this;
  }

  var _proto = Line.prototype;

  _proto.configureCanvas = function configureCanvas(props) {
    var canvas = this._canvas;
    canvas.isDrawingMode = canvas.selection = false;
    canvas.forEachObject(function (o) {
      return o.selectable = o.evented = false;
    });
    this._width = props.lineWidth;
    this._color = props.lineColor;
  };

  _proto.doMouseDown = function doMouseDown(o) {
    this.isDown = true;
    var canvas = this._canvas;
    var pointer = canvas.getPointer(o.e);
    var points = [pointer.x, pointer.y, pointer.x, pointer.y];
    this.line = new fabric.Line(points, {
      strokeWidth: this._width,
      fill: this._color,
      stroke: this._color,
      originX: 'center',
      originY: 'center',
      selectable: false,
      evented: false
    });
    canvas.add(this.line);
  };

  _proto.doMouseMove = function doMouseMove(o) {
    if (!this.isDown) return;
    var canvas = this._canvas;
    var pointer = canvas.getPointer(o.e);
    this.line.set({
      x2: pointer.x,
      y2: pointer.y
    });
    this.line.setCoords();
    canvas.renderAll();
  };

  _proto.doMouseUp = function doMouseUp(o) {
    this.isDown = false;
  };

  _proto.doMouseOut = function doMouseOut(o) {
    this.isDown = false;
  };

  return Line;
}(FabricCanvasTool);

var fabric$1 = require('fabric').fabric;

var Arrow = /*#__PURE__*/function (_FabricCanvasTool) {
  _inheritsLoose(Arrow, _FabricCanvasTool);

  function Arrow() {
    return _FabricCanvasTool.apply(this, arguments) || this;
  }

  var _proto = Arrow.prototype;

  _proto.configureCanvas = function configureCanvas(props) {
    var canvas = this._canvas;
    canvas.isDrawingMode = canvas.selection = false;
    canvas.forEachObject(function (o) {
      return o.selectable = o.evented = false;
    });
    this._width = props.lineWidth;
    this._color = props.lineColor;
  };

  _proto.doMouseDown = function doMouseDown(o) {
    this.isDown = true;
    var canvas = this._canvas;
    var pointer = canvas.getPointer(o.e);
    var points = [pointer.x, pointer.y, pointer.x, pointer.y];
    this.line = new fabric$1.Line(points, {
      strokeWidth: this._width,
      fill: this._color,
      stroke: this._color,
      originX: 'center',
      originY: 'center',
      selectable: false,
      evented: false
    });
    this.head = new fabric$1.Triangle({
      fill: this._color,
      left: pointer.x,
      top: pointer.y,
      originX: 'center',
      originY: 'center',
      height: 3 * this._width,
      width: 3 * this._width,
      selectable: false,
      evented: false,
      angle: 90
    });
    canvas.add(this.line);
    canvas.add(this.head);
  };

  _proto.doMouseMove = function doMouseMove(o) {
    if (!this.isDown) return;
    var canvas = this._canvas;
    var pointer = canvas.getPointer(o.e);
    this.line.set({
      x2: pointer.x,
      y2: pointer.y
    });
    this.line.setCoords();
    var x_delta = pointer.x - this.line.x1;
    var y_delta = pointer.y - this.line.y1;
    this.head.set({
      left: pointer.x,
      top: pointer.y,
      angle: 90 + Math.atan2(y_delta, x_delta) * 180 / Math.PI
    });
    canvas.renderAll();
  };

  _proto.doMouseUp = function doMouseUp(o) {
    this.isDown = false;
    var canvas = this._canvas;
    canvas.remove(this.line);
    canvas.remove(this.head);
    var arrow = new fabric$1.Group([this.line, this.head]);
    canvas.add(arrow);
  };

  _proto.doMouseOut = function doMouseOut(o) {
    this.isDown = false;
  };

  return Arrow;
}(FabricCanvasTool);

var fabric$2 = require('fabric').fabric;

var Rectangle = /*#__PURE__*/function (_FabricCanvasTool) {
  _inheritsLoose(Rectangle, _FabricCanvasTool);

  function Rectangle() {
    return _FabricCanvasTool.apply(this, arguments) || this;
  }

  var _proto = Rectangle.prototype;

  _proto.configureCanvas = function configureCanvas(props) {
    var canvas = this._canvas;
    canvas.isDrawingMode = canvas.selection = false;
    canvas.forEachObject(function (o) {
      return o.selectable = o.evented = false;
    });
    this._width = props.lineWidth;
    this._color = props.lineColor;
    this._fill = props.fillColor;
  };

  _proto.doMouseDown = function doMouseDown(o) {
    var canvas = this._canvas;
    this.isDown = true;
    var pointer = canvas.getPointer(o.e);
    this.startX = pointer.x;
    this.startY = pointer.y;
    this.rect = new fabric$2.Rect({
      left: this.startX,
      top: this.startY,
      originX: 'left',
      originY: 'top',
      width: pointer.x - this.startX,
      height: pointer.y - this.startY,
      stroke: this._color,
      strokeWidth: this._width,
      fill: this._fill,
      transparentCorners: false,
      selectable: false,
      evented: false,
      strokeUniform: true,
      noScaleCache: false,
      angle: 0
    });
    canvas.add(this.rect);
  };

  _proto.doMouseMove = function doMouseMove(o) {
    if (!this.isDown) return;
    var canvas = this._canvas;
    var pointer = canvas.getPointer(o.e);

    if (this.startX > pointer.x) {
      this.rect.set({
        left: Math.abs(pointer.x)
      });
    }

    if (this.startY > pointer.y) {
      this.rect.set({
        top: Math.abs(pointer.y)
      });
    }

    this.rect.set({
      width: Math.abs(this.startX - pointer.x)
    });
    this.rect.set({
      height: Math.abs(this.startY - pointer.y)
    });
    this.rect.setCoords();
    canvas.renderAll();
  };

  _proto.doMouseUp = function doMouseUp(o) {
    this.isDown = false;
  };

  return Rectangle;
}(FabricCanvasTool);

var fabric$3 = require('fabric').fabric;

var Circle = /*#__PURE__*/function (_FabricCanvasTool) {
  _inheritsLoose(Circle, _FabricCanvasTool);

  function Circle() {
    return _FabricCanvasTool.apply(this, arguments) || this;
  }

  var _proto = Circle.prototype;

  _proto.configureCanvas = function configureCanvas(props) {
    var canvas = this._canvas;
    canvas.isDrawingMode = canvas.selection = false;
    canvas.forEachObject(function (o) {
      return o.selectable = o.evented = false;
    });
    this._width = props.lineWidth;
    this._color = props.lineColor;
    this._fill = props.fillColor;
  };

  _proto.doMouseDown = function doMouseDown(o) {
    var canvas = this._canvas;
    this.isDown = true;
    var pointer = canvas.getPointer(o.e);
    var _ref = [pointer.x, pointer.y];
    this.startX = _ref[0];
    this.startY = _ref[1];
    this.circle = new fabric$3.Circle({
      left: this.startX,
      top: this.startY,
      originX: 'left',
      originY: 'center',
      strokeWidth: this._width,
      stroke: this._color,
      fill: this._fill,
      selectable: false,
      evented: false,
      radius: 1
    });
    canvas.add(this.circle);
  };

  _proto.doMouseMove = function doMouseMove(o) {
    if (!this.isDown) return;
    var canvas = this._canvas;
    var pointer = canvas.getPointer(o.e);
    this.circle.set({
      radius: linearDistance({
        x: this.startX,
        y: this.startY
      }, {
        x: pointer.x,
        y: pointer.y
      }) / 2,
      angle: Math.atan2(pointer.y - this.startY, pointer.x - this.startX) * 180 / Math.PI
    });
    this.circle.setCoords();
    canvas.renderAll();
  };

  _proto.doMouseUp = function doMouseUp(o) {
    this.isDown = false;
  };

  return Circle;
}(FabricCanvasTool);

var fabric$4 = require('fabric').fabric;

var Pan = /*#__PURE__*/function (_FabricCanvasTool) {
  _inheritsLoose(Pan, _FabricCanvasTool);

  function Pan() {
    return _FabricCanvasTool.apply(this, arguments) || this;
  }

  var _proto = Pan.prototype;

  _proto.configureCanvas = function configureCanvas(props) {
    var canvas = this._canvas;
    canvas.isDrawingMode = canvas.selection = false;
    canvas.forEachObject(function (o) {
      return o.selectable = o.evented = false;
    });
    canvas.defaultCursor = 'move';
  };

  _proto.doMouseDown = function doMouseDown(o) {
    var canvas = this._canvas;
    this.isDown = true;
    var pointer = canvas.getPointer(o.e);
    this.startX = pointer.x;
    this.startY = pointer.y;
  };

  _proto.doMouseMove = function doMouseMove(o) {
    if (!this.isDown) return;
    var canvas = this._canvas;
    var pointer = canvas.getPointer(o.e);
    canvas.relativePan({
      x: pointer.x - this.startX,
      y: pointer.y - this.startY
    });
    canvas.renderAll();
  };

  _proto.doMouseUp = function doMouseUp(o) {
    this.isDown = false;
  };

  return Pan;
}(FabricCanvasTool);

var Tools = {
  Circle: 'circle',
  Line: 'line',
  Arrow: 'arrow',
  Pencil: 'pencil',
  Rectangle: 'rectangle',
  RectangleLabel: 'rectangle-label',
  Select: 'select',
  Pan: 'pan',
  Highlighter: 'highlighter',
  DefaultTool: 'default-tool',
  Eraser: 'eraser',
  Text: 'text',
  Stamp: 'stamp'
};

var Highlighter = /*#__PURE__*/function (_FabricCanvasTool) {
  _inheritsLoose(Highlighter, _FabricCanvasTool);

  function Highlighter() {
    return _FabricCanvasTool.apply(this, arguments) || this;
  }

  var _proto = Highlighter.prototype;

  _proto.configureCanvas = function configureCanvas(props) {
    this._canvas.isDrawingMode = true;
    this._canvas.freeDrawingBrush.width = props.lineWidth;
    this._canvas.freeDrawingBrush.color = props.lineColor.indexOf('#') > -1 ? hexToRgbA(props.lineColor, props.opacity) : hexToRgbA(colorNameToHex(props.lineColor), props.opacity);
  };

  return Highlighter;
}(FabricCanvasTool);

var fabric$5 = require('fabric').fabric;

var RectangleLabelObject = /*#__PURE__*/function () {
  function RectangleLabelObject(canvas, text, rectProps, textProps) {
    var _this = this;

    this.update = function (e) {
      if (!_this._textObj || !_this._rectObj) return;

      if (e.target === _this._rectObj) {
        _this._textObj.set({
          'width': _this._rectObj.getScaledWidth(),
          'scaleX': 1,
          'scaleY': 1,
          'top': _this._rectObj.top - _this._textObj.getScaledHeight(),
          'left': _this._rectObj.left
        });
      }
    };

    this._canvas = canvas;
    this._text = text;
    this._rectObj = new fabric$5.Rect(rectProps);
    this._textObj = new fabric$5.Textbox(text, textProps);
    canvas.on({
      'object:scaling': this.update
    });
    canvas.on({
      'object:moving': this.update
    });
  }

  var _proto = RectangleLabelObject.prototype;

  _proto.setText = function setText(text) {
    this._text = text;

    this._textObj.set({
      text: text
    });
  };

  return RectangleLabelObject;
}();

var RectangleLabel = /*#__PURE__*/function (_FabricCanvasTool) {
  _inheritsLoose(RectangleLabel, _FabricCanvasTool);

  function RectangleLabel() {
    return _FabricCanvasTool.apply(this, arguments) || this;
  }

  var _proto = RectangleLabel.prototype;

  _proto.configureCanvas = function configureCanvas(props) {
    var canvas = this._canvas;
    canvas.isDrawingMode = canvas.selection = false;
    canvas.forEachObject(function (o) {
      return o.selectable = o.evented = false;
    });
    this._width = props.lineWidth;
    this._color = props.lineColor;
    this._fill = props.fillColor;
    this._textString = props.text;
    this._maxFontSize = 12;
  };

  _proto.doMouseDown = function doMouseDown(o) {
    var canvas = this._canvas;
    this.isDown = true;
    var pointer = canvas.getPointer(o.e);
    this.startX = pointer.x;
    this.startY = pointer.y;
    this.rectangleLabel = new RectangleLabelObject(canvas, "New drawing", {
      left: this.startX,
      top: this.startY,
      originX: 'left',
      originY: 'top',
      width: pointer.x - this.startX,
      height: pointer.y - this.startY,
      stroke: this._color,
      strokeWidth: this._width,
      fill: this._fill,
      transparentCorners: false,
      selectable: false,
      evented: false,
      strokeUniform: true,
      noScaleCache: false,
      angle: 0
    }, {
      left: this.startX,
      top: this.startY - 12,
      originX: 'left',
      originY: 'top',
      width: pointer.x - this.startX - this._width,
      height: canvas.height / 3,
      fontSize: this._maxFontSize,
      noScaleCache: false,
      backgroundColor: this._color,
      transparentCorners: true,
      hasControls: false,
      angle: 0
    });
    if (this._objects && this._objects.length > 0) this._objects.push(this.rectangleLabel);else this._objects = [this.rectangleLabel];

    while (this.rectangleLabel._textObj.height > canvas.height / 3) {
      this.rectangleLabel._textObj.set({
        fontSize: this.rectangleLabel._textObj.fontSize - 1,
        top: this.startY - this.rectangleLabel._textObj.fontSize - 12
      });
    }

    canvas.add(this.rectangleLabel._rectObj);
    canvas.add(this.rectangleLabel._textObj);
    canvas.renderAll();
  };

  _proto.doMouseMove = function doMouseMove(o) {
    if (!this.isDown) return;
    var canvas = this._canvas;
    var pointer = canvas.getPointer(o.e);

    if (this.startX > pointer.x) {
      this.rectangleLabel._rectObj.set({
        left: Math.abs(pointer.x)
      });

      this.rectangleLabel._textObj.set({
        left: Math.abs(pointer.x)
      });
    }

    if (this.startY > pointer.y) {
      this.rectangleLabel._rectObj.set({
        left: Math.abs(pointer.x)
      });

      this.rectangleLabel._textObj.set({
        top: Math.abs(pointer.y)
      });
    }

    this.rectangleLabel._textObj.setCoords();

    this.rectangleLabel._rectObj.set({
      width: Math.abs(this.startX - pointer.x)
    });

    this.rectangleLabel._textObj.set({
      width: this.rectangleLabel._rectObj.getScaledWidth()
    });

    this.rectangleLabel._rectObj.set({
      height: Math.abs(this.startY - pointer.y)
    });

    this.rectangleLabel._rectObj.setCoords();

    canvas.renderAll();
  };

  _proto.doMouseUp = function doMouseUp(o) {
    this.isDown = false;
    var canvas = this._canvas;
    canvas.renderAll();
  };

  return RectangleLabel;
}(FabricCanvasTool);

var fabric$6 = require('fabric').fabric;

var DefaultTool = /*#__PURE__*/function (_FabricCanvasTool) {
  _inheritsLoose(DefaultTool, _FabricCanvasTool);

  function DefaultTool() {
    return _FabricCanvasTool.apply(this, arguments) || this;
  }

  var _proto = DefaultTool.prototype;

  _proto.configureCanvas = function configureCanvas(props) {
    var canvas = this._canvas;
    canvas.isDrawingMode = canvas.selection = false;
    canvas.forEachObject(function (o) {
      return o.selectable = o.evented = false;
    });
    canvas.discardActiveObject();
    canvas.defaultCursor = 'pointer';
    canvas.renderAll();
  };

  return DefaultTool;
}(FabricCanvasTool);

var fabric$7 = require('fabric').fabric;

var Eraser = /*#__PURE__*/function (_FabricCanvasTool) {
  _inheritsLoose(Eraser, _FabricCanvasTool);

  function Eraser() {
    return _FabricCanvasTool.apply(this, arguments) || this;
  }

  var _proto = Eraser.prototype;

  _proto.configureCanvas = function configureCanvas(props) {
    var canvas = this._canvas;
    canvas.isDrawingMode = canvas.selection = false;
    canvas.forEachObject(function (o) {
      return o.selectable = o.evented = false;
    });
    this._width = props.lineWidth;
    this._color = props.lineColor;
  };

  _proto.doMouseDown = function doMouseDown(o) {
    this.isDown = true;
    var canvas = this._canvas;
    var pointer = canvas.getPointer(o.e);
    this.lastX = pointer.x;
    this.lastY = pointer.y;
    var circle = new fabric$7.Circle({
      radius: this._width,
      fill: '#f55',
      top: pointer.y,
      left: pointer.x,
      globalCompositeOperation: "destination-out",
      selectable: false,
      evented: false
    });
    canvas.add(circle);
    canvas.renderAll();
  };

  _proto.doMouseMove = function doMouseMove(o) {
    if (!this.isDown) return;
    var canvas = this._canvas;
    var pointer = canvas.getPointer(o.e);
    var circle = new fabric$7.Circle({
      radius: this._width,
      fill: '#f55',
      top: pointer.y,
      left: pointer.x,
      globalCompositeOperation: "destination-out",
      selectable: false,
      evented: false
    });
    canvas.add(circle);
    canvas.renderAll();
  };

  _proto.doMouseUp = function doMouseUp(o) {
    this.isDown = false;
  };

  _proto.doMouseOut = function doMouseOut(o) {
    this.isDown = false;
  };

  return Eraser;
}(FabricCanvasTool);

var fabric$8 = require('fabric').fabric;

var Text = /*#__PURE__*/function (_FabricCanvasTool) {
  _inheritsLoose(Text, _FabricCanvasTool);

  function Text() {
    return _FabricCanvasTool.apply(this, arguments) || this;
  }

  var _proto = Text.prototype;

  _proto.configureCanvas = function configureCanvas(props) {
    var canvas = this._canvas;
    canvas.isDrawingMode = canvas.selection = false;
    canvas.forEachObject(function (o) {
      return o.selectable = o.evented = false;
    });
    this._setTool = props.setTool;
    this._fontSize = props.fontSize;
    this._color = props.lineColor;
  };

  _proto.doMouseDown = function doMouseDown(o) {
    var options = {};
    var canvas = this._canvas;

    if (!canvas.selection) {
      var pointer = canvas.getPointer(o.e);
      var iText = new fabric$8.IText("Add text here", options);
      var opts = {
        left: pointer.x,
        top: pointer.y
      };
      Object.assign(options, opts);
      iText.set({
        'left': options.left,
        'top': options.top,
        'fontSize': this._fontSize,
        'fill': this._color
      });
      canvas.add(iText);

      this._setTool(Tools.Select);
    }
  };

  return Text;
}(FabricCanvasTool);

var StampType = {
  Arrow: 'arrow',
  Check: 'check',
  Cross: 'cross',
  Star: 'star',
  Heart: 'heart',
  Question: 'question'
};

var fabric$9 = require('fabric').fabric;
var heartSVG = '<svg viewBox="0 -28 512.00002 512" xmlns="http://www.w3.org/2000/svg"><path d="m471.382812 44.578125c-26.503906-28.746094-62.871093-44.578125-102.410156-44.578125-29.554687 0-56.621094 9.34375-80.449218 27.769531-12.023438 9.300781-22.917969 20.679688-32.523438 33.960938-9.601562-13.277344-20.5-24.660157-32.527344-33.960938-23.824218-18.425781-50.890625-27.769531-80.445312-27.769531-39.539063 0-75.910156 15.832031-102.414063 44.578125-26.1875 28.410156-40.613281 67.222656-40.613281 109.292969 0 43.300781 16.136719 82.9375 50.78125 124.742187 30.992188 37.394531 75.535156 75.355469 127.117188 119.3125 17.613281 15.011719 37.578124 32.027344 58.308593 50.152344 5.476563 4.796875 12.503907 7.4375 19.792969 7.4375 7.285156 0 14.316406-2.640625 19.785156-7.429687 20.730469-18.128907 40.707032-35.152344 58.328125-50.171876 51.574219-43.949218 96.117188-81.90625 127.109375-119.304687 34.644532-41.800781 50.777344-81.4375 50.777344-124.742187 0-42.066407-14.425781-80.878907-40.617188-109.289063zm0 0"/></svg>';
var arrowSVG = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n<svg version=\"1.1\" id=\"Capa_1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" x=\"0px\" y=\"0px\"\n\t width=\"123.964px\" height=\"123.964px\" viewBox=\"0 0 123.964 123.964\" style=\"enable-background:new 0 0 123.964 123.964;\"\n\t xml:space=\"preserve\">\n<g>\n\t<path d=\"M121.7,57.681L83,26.881c-4-3.1-10-0.3-10,4.8v10.3c0,3.3-2.2,6.2-5.5,6.2H6c-3.3,0-6,2.4-6,5.8v16.2c0,3.2,2.7,6,6,6h61.5\n\t\tc3.3,0,5.5,2.601,5.5,5.9v10.3c0,5,6,7.8,9.9,4.7l38.6-30C124.7,64.781,124.8,60.081,121.7,57.681z\"/>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n</svg>\n";
var checkSVG = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n<svg version=\"1.1\" id=\"Capa_1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" x=\"0px\" y=\"0px\"\n\t width=\"405.272px\" height=\"405.272px\" viewBox=\"0 0 405.272 405.272\" style=\"enable-background:new 0 0 405.272 405.272;\"\n\t xml:space=\"preserve\">\n<g>\n\t<path d=\"M393.401,124.425L179.603,338.208c-15.832,15.835-41.514,15.835-57.361,0L11.878,227.836\n\t\tc-15.838-15.835-15.838-41.52,0-57.358c15.841-15.841,41.521-15.841,57.355-0.006l81.698,81.699L336.037,67.064\n\t\tc15.841-15.841,41.523-15.829,57.358,0C409.23,82.902,409.23,108.578,393.401,124.425z\"/>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n</svg>\n";
var crossSVG = "<svg height=\"365.696pt\" viewBox=\"0 0 365.696 365.696\" width=\"365.696pt\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"m243.1875 182.859375 113.132812-113.132813c12.5-12.5 12.5-32.765624 0-45.246093l-15.082031-15.082031c-12.503906-12.503907-32.769531-12.503907-45.25 0l-113.128906 113.128906-113.132813-113.152344c-12.5-12.5-32.765624-12.5-45.246093 0l-15.105469 15.082031c-12.5 12.503907-12.5 32.769531 0 45.25l113.152344 113.152344-113.128906 113.128906c-12.503907 12.503907-12.503907 32.769531 0 45.25l15.082031 15.082031c12.5 12.5 32.765625 12.5 45.246093 0l113.132813-113.132812 113.128906 113.132812c12.503907 12.5 32.769531 12.5 45.25 0l15.082031-15.082031c12.5-12.503906 12.5-32.769531 0-45.25zm0 0\"/></svg>";
var starSVG = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n<svg version=\"1.1\" id=\"Capa_1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" x=\"0px\" y=\"0px\"\n\t viewBox=\"0 0 512.002 512.002\" style=\"enable-background:new 0 0 512.002 512.002;\" xml:space=\"preserve\">\n<g>\n\t<g>\n\t\t<path d=\"M511.267,197.258c-1.764-5.431-6.457-9.389-12.107-10.209l-158.723-23.065L269.452,20.157\n\t\t\tc-2.526-5.12-7.741-8.361-13.45-8.361c-5.71,0-10.924,3.241-13.451,8.361l-70.988,143.827l-158.72,23.065\n\t\t\tc-5.649,0.82-10.344,4.778-12.108,10.208c-1.765,5.431-0.293,11.392,3.796,15.377l114.848,111.954L92.271,482.671\n\t\t\tc-0.966,5.628,1.348,11.314,5.967,14.671c2.613,1.898,5.708,2.864,8.818,2.864c2.388,0,4.784-0.569,6.978-1.723l141.967-74.638\n\t\t\tl141.961,74.637c5.055,2.657,11.178,2.215,15.797-1.141c4.619-3.356,6.934-9.044,5.969-14.672l-27.117-158.081l114.861-111.955\n\t\t\tC511.56,208.649,513.033,202.688,511.267,197.258z\"/>\n\t</g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n<g>\n</g>\n</svg>\n";
var questionSVG = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" width=\"16\" height=\"16\" viewBox=\"0 0 16 16\">\n<path fill=\"#444444\" d=\"M9 11h-3c0-3 1.6-4 2.7-4.6 0.4-0.2 0.7-0.4 0.9-0.6 0.5-0.5 0.3-1.2 0.2-1.4-0.3-0.7-1-1.4-2.3-1.4-2.1 0-2.5 1.9-2.5 2.3l-3-0.4c0.2-1.7 1.7-4.9 5.5-4.9 2.3 0 4.3 1.3 5.1 3.2 0.7 1.7 0.4 3.5-0.8 4.7-0.5 0.5-1.1 0.8-1.6 1.1-0.9 0.5-1.2 1-1.2 2z\"></path>\n<path fill=\"#444444\" d=\"M9.5 14c0 1.105-0.895 2-2 2s-2-0.895-2-2c0-1.105 0.895-2 2-2s2 0.895 2 2z\"></path>\n</svg>";

var Stamp = /*#__PURE__*/function (_FabricCanvasTool) {
  _inheritsLoose(Stamp, _FabricCanvasTool);

  function Stamp() {
    return _FabricCanvasTool.apply(this, arguments) || this;
  }

  var _proto = Stamp.prototype;

  _proto.configureCanvas = function configureCanvas(props) {
    var canvas = this._canvas;
    canvas.isDrawingMode = canvas.selection = false;
    canvas.forEachObject(function (o) {
      return o.selectable = o.evented = false;
    });
    this._stampType = props.stampType;
  };

  _proto.doMouseDown = function doMouseDown(o) {
    var canvas = this._canvas;
    var pointer = canvas.getPointer(o.e);
    var svg;

    switch (this._stampType) {
      case StampType.Arrow:
        svg = arrowSVG;
        break;

      case StampType.Heart:
        svg = heartSVG;
        break;

      case StampType.Check:
        svg = checkSVG;
        break;

      case StampType.Cross:
        svg = crossSVG;
        break;

      case StampType.Star:
        svg = starSVG;
        break;

      case StampType.Question:
        svg = questionSVG;
        break;
    }

    fabric$9.loadSVGFromString(svg, function (objects, options) {
      var obj = fabric$9.util.groupSVGElements(objects, options);
      obj.scaleToHeight(32).set({
        left: pointer.x - 16,
        top: pointer.y - 16
      });
      canvas.add(obj).renderAll();
      obj.setCoords();
    });
  };

  return Stamp;
}(FabricCanvasTool);

var fabric$a = require('fabric').fabric;

var SketchField = /*#__PURE__*/function (_PureComponent) {
  _inheritsLoose(SketchField, _PureComponent);

  function SketchField() {
    var _this;

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _PureComponent.call.apply(_PureComponent, [this].concat(args)) || this;
    _this.state = {
      action: true
    };

    _this._initTools = function (fabricCanvas) {
      _this._tools = {};
      _this._tools[Tools.Select] = new Select(fabricCanvas);
      _this._tools[Tools.Pencil] = new Pencil(fabricCanvas);
      _this._tools[Tools.Line] = new Line(fabricCanvas);
      _this._tools[Tools.Arrow] = new Arrow(fabricCanvas);
      _this._tools[Tools.Rectangle] = new Rectangle(fabricCanvas);
      _this._tools[Tools.RectangleLabel] = new RectangleLabel(fabricCanvas);
      _this._tools[Tools.Circle] = new Circle(fabricCanvas);
      _this._tools[Tools.Pan] = new Pan(fabricCanvas);
      _this._tools[Tools.Highlighter] = new Highlighter(fabricCanvas);
      _this._tools[Tools.Eraser] = new Eraser(fabricCanvas);
      _this._tools[Tools.Text] = new Text(fabricCanvas);
      _this._tools[Tools.DefaultTool] = new DefaultTool(fabricCanvas);
      _this._tools[Tools.Stamp] = new Stamp(fabricCanvas);
    };

    _this.enableTouchScroll = function () {
      var canvas = _this._fc;
      if (canvas.allowTouchScrolling) return;
      canvas.allowTouchScrolling = true;
    };

    _this.disableTouchScroll = function () {
      var canvas = _this._fc;

      if (canvas.allowTouchScrolling) {
        canvas.allowTouchScrolling = false;
      }
    };

    _this.addImg = function (dataUrl, options) {
      if (options === void 0) {
        options = {};
      }

      var canvas = _this._fc;
      fabric$a.Image.fromURL(dataUrl, function (oImg) {
        var opts = {
          left: Math.random() * (canvas.getWidth() - oImg.width * 0.5),
          top: Math.random() * (canvas.getHeight() - oImg.height * 0.5),
          scale: 0.5
        };
        Object.assign(opts, options);
        oImg.scale(opts.scale);
        oImg.set({
          'left': opts.left,
          'top': opts.top
        });
        canvas.add(oImg);
      });
    };

    _this._onObjectAdded = function (e) {
      var onObjectAdded = _this.props.onObjectAdded;

      if (!_this.state.action) {
        _this.setState({
          action: true
        });

        return;
      }

      var obj = e.target;
      obj.__version = 1;
      var objState = obj.toJSON();
      obj.__originalState = objState;
      var state = JSON.stringify(objState);

      _this._history.keep([obj, state, state]);

      onObjectAdded(e);
    };

    _this._onObjectMoving = function (e) {
      var onObjectMoving = _this.props.onObjectMoving;
      onObjectMoving(e);
    };

    _this._onObjectScaling = function (e) {
      var onObjectScaling = _this.props.onObjectScaling;
      onObjectScaling(e);
    };

    _this._onObjectRotating = function (e) {
      var onObjectRotating = _this.props.onObjectRotating;
      onObjectRotating(e);
    };

    _this._onObjectModified = function (e) {
      var onObjectModified = _this.props.onObjectModified;
      var obj = e.target;
      obj.__version += 1;
      var prevState = JSON.stringify(obj.__originalState);
      var objState = obj.toJSON();
      obj.__originalState = objState;
      var currState = JSON.stringify(objState);

      _this._history.keep([obj, prevState, currState]);

      onObjectModified(e);
    };

    _this._onObjectRemoved = function (e) {
      var onObjectRemoved = _this.props.onObjectRemoved;
      var obj = e.target;

      if (obj.__removed) {
        obj.__version += 1;
        return;
      }

      obj.__version = 0;
      onObjectRemoved(e);
    };

    _this._onMouseDown = function (e) {
      var onMouseDown = _this.props.onMouseDown;

      _this._selectedTool.doMouseDown(e);

      onMouseDown(e);
    };

    _this._onMouseMove = function (e) {
      var onMouseMove = _this.props.onMouseMove;

      _this._selectedTool.doMouseMove(e);

      onMouseMove(e);
    };

    _this._onMouseOut = function (e) {
      var onMouseOut = _this.props.onMouseOut;

      _this._selectedTool.doMouseOut(e);

      if (_this.props.onChange) {
        var onChange = _this.props.onChange;
        setTimeout(function () {
          onChange(e.e);
        }, 10);
      }

      onMouseOut(e);
    };

    _this._onMouseUp = function (e) {
      var onMouseUp = _this.props.onMouseUp;

      _this._selectedTool.doMouseUp(e);

      if (_this.props.tool !== Tools.Pencil) {
        var canvas = _this._fc;
        var objects = canvas.getObjects();
        var newObj = objects[objects.length - 1];

        if (newObj && newObj.__version === 1) {
          newObj.__originalState = newObj.toJSON();
        }
      }

      if (_this.props.onChange) {
        var onChange = _this.props.onChange;
        setTimeout(function () {
          onChange(e.e);
        }, 10);
      }

      onMouseUp(e);
    };

    _this._resize = function (e, canvasWidth, canvasHeight) {
      if (canvasWidth === void 0) {
        canvasWidth = null;
      }

      if (canvasHeight === void 0) {
        canvasHeight = null;
      }

      if (e) e.preventDefault();
      var _this$props = _this.props,
          widthCorrection = _this$props.widthCorrection,
          heightCorrection = _this$props.heightCorrection;
      var canvas = _this._fc;
      var _this$_container = _this._container,
          offsetWidth = _this$_container.offsetWidth,
          clientHeight = _this$_container.clientHeight;
      var prevWidth = canvasWidth || canvas.getWidth();
      var prevHeight = canvasHeight || canvas.getHeight();
      var wfactor = ((offsetWidth - widthCorrection) / prevWidth).toFixed(2);
      var hfactor = ((clientHeight - heightCorrection) / prevHeight).toFixed(2);
      canvas.setWidth(offsetWidth - widthCorrection);
      canvas.setHeight(clientHeight - heightCorrection);

      if (canvas.backgroundImage) {
        var bi = canvas.backgroundImage;
        bi.width = bi.width * wfactor;
        bi.height = bi.height * hfactor;
      }

      var objects = canvas.getObjects();

      for (var i in objects) {
        var obj = objects[i];
        var scaleX = obj.scaleX;
        var scaleY = obj.scaleY;
        var left = obj.left;
        var top = obj.top;
        var tempScaleX = scaleX * wfactor;
        var tempScaleY = scaleY * hfactor;
        var tempLeft = left * wfactor;
        var tempTop = top * hfactor;
        obj.scaleX = tempScaleX;
        obj.scaleY = tempScaleY;
        obj.left = tempLeft;
        obj.top = tempTop;
        obj.setCoords();
      }

      canvas.renderAll();
      canvas.calcOffset();
    };

    _this._backgroundColor = function (color) {
      if (!color) return;
      var canvas = _this._fc;
      canvas.setBackgroundColor(color, function () {
        return canvas.renderAll();
      });
    };

    _this.zoom = function (factor) {
      var canvas = _this._fc;
      var objects = canvas.getObjects();

      for (var i in objects) {
        objects[i].scaleX = objects[i].scaleX * factor;
        objects[i].scaleY = objects[i].scaleY * factor;
        objects[i].left = objects[i].left * factor;
        objects[i].top = objects[i].top * factor;
        objects[i].setCoords();
      }

      canvas.renderAll();
      canvas.calcOffset();
    };

    _this.undo = function () {
      var history = _this._history;

      var _history$getCurrent = history.getCurrent(),
          obj = _history$getCurrent[0],
          prevState = _history$getCurrent[1];

      history.undo();

      if (obj.__removed) {
        _this.setState({
          action: false
        }, function () {
          _this._fc.add(obj);

          obj.__version -= 1;
          obj.__removed = false;
        });
      } else if (obj.__version <= 1) {
        _this._fc.remove(obj);
      } else {
        obj.__version -= 1;
        obj.setOptions(JSON.parse(prevState));
        obj.setCoords();

        _this._fc.renderAll();
      }

      if (_this.props.onChange) {
        _this.props.onChange();
      }
    };

    _this.redo = function () {
      var history = _this._history;

      if (history.canRedo()) {
        var canvas = _this._fc;

        var _history$redo = history.redo(),
            obj = _history$redo[0],
            currState = _history$redo[2];

        if (obj.__version === 0) {
          _this.setState({
            action: false
          }, function () {
            canvas.add(obj);
            obj.__version = 1;
          });
        } else {
          obj.__version += 1;
          obj.setOptions(JSON.parse(currState));
        }

        obj.setCoords();
        canvas.renderAll();

        if (_this.props.onChange) {
          _this.props.onChange();
        }
      }
    };

    _this.canUndo = function () {
      return _this._history.canUndo();
    };

    _this.canRedo = function () {
      return _this._history.canRedo();
    };

    _this.toDataURL = function (options) {
      return _this._fc.toDataURL(options);
    };

    _this.toJSON = function (propertiesToInclude) {
      return _this._fc.toJSON(propertiesToInclude);
    };

    _this.fromJSON = function (json) {
      if (!json) return;
      var canvas = _this._fc;
      setTimeout(function () {
        canvas.loadFromJSON(json, function () {
          if (_this.props.tool === Tools.DefaultTool) {
            canvas.isDrawingMode = canvas.selection = false;
            canvas.forEachObject(function (o) {
              return o.selectable = o.evented = false;
            });
          }

          canvas.renderAll();

          if (_this.props.onChange) {
            _this.props.onChange();
          }
        });
      }, 100);
    };

    _this.clear = function (propertiesToInclude) {
      var discarded = _this.toJSON(propertiesToInclude);

      _this._fc.clear();

      _this._history.clear();

      return discarded;
    };

    _this.hasSelection = function () {
      var canvas = _this._fc;
      return !!canvas.getActiveObject();
    };

    _this.clearSelection = function () {
      var canvas = _this._fc;
      canvas.discardActiveObject();
      canvas.requestRenderAll();
    };

    _this.removeSelected = function () {
      var canvas = _this._fc;
      var activeObj = canvas.getActiveObject();

      if (activeObj) {
        var selected = [];

        if (activeObj.type === 'activeSelection') {
          activeObj.forEachObject(function (obj) {
            return selected.push(obj);
          });
        } else {
          selected.push(activeObj);
        }

        selected.forEach(function (obj) {
          obj.__removed = true;
          var objState = obj.toJSON();
          obj.__originalState = objState;
          var state = JSON.stringify(objState);

          _this._history.keep([obj, state, state]);

          canvas.remove(obj);
        });
        canvas.discardActiveObject();
        canvas.requestRenderAll();
      }
    };

    _this.copy = function () {
      var canvas = _this._fc;
      canvas.getActiveObject().clone(function (cloned) {
        return _this._clipboard = cloned;
      });
    };

    _this.paste = function () {
      _this._clipboard.clone(function (clonedObj) {
        var canvas = _this._fc;
        canvas.discardActiveObject();
        clonedObj.set({
          left: clonedObj.left + 10,
          top: clonedObj.top + 10,
          evented: true
        });

        if (clonedObj.type === 'activeSelection') {
          clonedObj.canvas = canvas;
          clonedObj.forEachObject(function (obj) {
            return canvas.add(obj);
          });
          clonedObj.setCoords();
        } else {
          canvas.add(clonedObj);
        }

        _this._clipboard.top += 10;
        _this._clipboard.left += 10;
        canvas.setActiveObject(clonedObj);
        canvas.requestRenderAll();
      });
    };

    _this.setBackgroundFromDataUrl = function (dataUrl, options) {
      if (options === void 0) {
        options = {};
      }

      var canvas = _this._fc;
      var img = new Image();
      img.setAttribute('crossOrigin', 'anonymous');

      var _options = options,
          stretched = _options.stretched,
          stretchedX = _options.stretchedX,
          stretchedY = _options.stretchedY,
          fabricOptions = _objectWithoutPropertiesLoose(_options, ["stretched", "stretchedX", "stretchedY"]);

      img.onload = function () {
        var imgObj = new fabric$a.Image(img);
        if (stretched || stretchedX) imgObj.scaleToWidth(canvas.width);
        if (stretched || stretchedY) imgObj.scaleToHeight(canvas.height);
        canvas.setBackgroundImage(imgObj, function () {
          return canvas.renderAll();
        }, fabricOptions);
      };

      img.src = dataUrl;
    };

    _this.addText = function (text, options) {
      if (options === void 0) {
        options = {};
      }

      var canvas = _this._fc;
      var iText = new fabric$a.IText(text, options);
      var opts = {
        left: (canvas.getWidth() - iText.width) * 0.5,
        top: (canvas.getHeight() - iText.height) * 0.5
      };
      Object.assign(options, opts);
      iText.set({
        'left': options.left,
        'top': options.top
      });
      canvas.add(iText);
    };

    _this.callEvent = function (e, eventFunction) {
      if (_this._selectedTool) eventFunction(e);
    };

    _this.componentDidMount = function () {
      var _this$props2 = _this.props,
          tool = _this$props2.tool,
          value = _this$props2.value,
          undoSteps = _this$props2.undoSteps,
          defaultValue = _this$props2.defaultValue,
          backgroundColor = _this$props2.backgroundColor;
      var canvas = _this._fc = new fabric$a.Canvas(_this._canvas);

      _this._initTools(canvas);

      _this._backgroundColor(backgroundColor);

      var selectedTool = _this._tools[tool];
      if (selectedTool) selectedTool.configureCanvas(_this.props);
      _this._selectedTool = selectedTool;
      window.addEventListener('resize', _this._resize, false);
      _this._history = new History(undoSteps);
      canvas.on('object:added', function (e) {
        return _this.callEvent(e, _this._onObjectAdded);
      });
      canvas.on('object:modified', function (e) {
        return _this.callEvent(e, _this._onObjectModified);
      });
      canvas.on('object:removed', function (e) {
        return _this.callEvent(e, _this._onObjectRemoved);
      });
      canvas.on('mouse:down', function (e) {
        return _this.callEvent(e, _this._onMouseDown);
      });
      canvas.on('mouse:move', function (e) {
        return _this.callEvent(e, _this._onMouseMove);
      });
      canvas.on('mouse:up', function (e) {
        return _this.callEvent(e, _this._onMouseUp);
      });
      canvas.on('mouse:out', function (e) {
        return _this.callEvent(e, _this._onMouseOut);
      });
      canvas.on('object:moving', function (e) {
        return _this.callEvent(e, _this._onObjectMoving);
      });
      canvas.on('object:scaling', function (e) {
        return _this.callEvent(e, _this._onObjectScaling);
      });
      canvas.on('object:rotating', function (e) {
        return _this.callEvent(e, _this._onObjectRotating);
      });

      _this.disableTouchScroll();

      _this._resize();

      (value || defaultValue) && _this.fromJSON(value || defaultValue);
    };

    _this.componentWillUnmount = function () {
      return window.removeEventListener('resize', _this._resize);
    };

    _this.componentDidUpdate = function (prevProps, prevState) {
      if (_this.props.width !== prevProps.width || _this.props.height !== prevProps.height) {
        _this._resize();
      }

      _this._selectedTool = _this._tools[_this.props.tool];

      if (_this._selectedTool) {
        _this._selectedTool.configureCanvas(_this.props);
      }

      if (_this.props.tool !== prevProps.tool) {
        _this._fc.defaultCursor = 'default';

        if (_this._selectedTool) {
          if (_this.props.tool !== Tools.Eraser) {
            var ctx = _this._canvas.getContext("2d");

            ctx.globalCompositeOperation = "source-over";
          }
        }
      }

      if (_this.props.backgroundColor !== prevProps.backgroundColor) {
        _this._backgroundColor(_this.props.backgroundColor);
      }

      if (_this.props.value !== prevProps.value || _this.props.value && _this.props.forceValue) {
        _this.fromJSON(_this.props.value);
      }
    };

    _this.changeSelectedTool = function (tool) {
      _this._selectedTool = _this._tools[tool];
    };

    _this.render = function () {
      var _this$props3 = _this.props,
          className = _this$props3.className,
          style = _this$props3.style,
          width = _this$props3.width,
          height = _this$props3.height;
      var canvasDivStyle = Object.assign({}, style ? style : {}, width ? {
        width: width
      } : {}, height ? {
        height: height
      } : {
        height: 512
      });
      return /*#__PURE__*/React.createElement("div", {
        className: className,
        ref: function ref(c) {
          return _this._container = c;
        },
        style: canvasDivStyle
      }, /*#__PURE__*/React.createElement("canvas", {
        id: uuid4(),
        ref: function ref(c) {
          return _this._canvas = c;
        }
      }, "Sorry, Canvas HTML5 element is not supported by your browser :("));
    };

    return _this;
  }

  return SketchField;
}(PureComponent);

SketchField.propTypes = {
  lineColor: propTypes.string,
  lineWidth: propTypes.number,
  fillColor: propTypes.string,
  backgroundColor: propTypes.string,
  opacity: propTypes.number,
  undoSteps: propTypes.number,
  tool: propTypes.string,
  imageFormat: propTypes.string,
  value: propTypes.object,
  forceValue: propTypes.bool,
  widthCorrection: propTypes.number,
  heightCorrection: propTypes.number,
  onChange: propTypes.func,
  defaultValue: propTypes.object,
  width: propTypes.number,
  height: propTypes.number,
  onObjectAdded: propTypes.func,
  onObjectModified: propTypes.func,
  onObjectRemoved: propTypes.func,
  onMouseDown: propTypes.func,
  onMouseMove: propTypes.func,
  onMouseUp: propTypes.func,
  onMouseOut: propTypes.func,
  onObjectMoving: propTypes.func,
  onObjectScaling: propTypes.func,
  onObjectRotating: propTypes.func,
  className: propTypes.string,
  style: propTypes.object,
  setTool: propTypes.func,
  fontSize: propTypes.number
};
SketchField.defaultProps = {
  lineColor: 'black',
  lineWidth: 10,
  fillColor: 'transparent',
  backgroundColor: 'transparent',
  opacity: 1.0,
  undoSteps: 25,
  tool: null,
  widthCorrection: 0,
  heightCorrection: 0,
  forceValue: false,
  onObjectAdded: function onObjectAdded() {
    return null;
  },
  onObjectModified: function onObjectModified() {
    return null;
  },
  onObjectRemoved: function onObjectRemoved() {
    return null;
  },
  onMouseDown: function onMouseDown() {
    return null;
  },
  onMouseMove: function onMouseMove() {
    return null;
  },
  onMouseUp: function onMouseUp() {
    return null;
  },
  onMouseOut: function onMouseOut() {
    return null;
  },
  onObjectMoving: function onObjectMoving() {
    return null;
  },
  onObjectScaling: function onObjectScaling() {
    return null;
  },
  onObjectRotating: function onObjectRotating() {
    return null;
  },
  fontSize: 16
};

var index = {
  SketchField: SketchField,
  Tools: Tools,
  StampType: StampType
};

export default index;
export { SketchField, StampType, Tools };
//# sourceMappingURL=index.modern.js.map
