<?php

require_once(plugin_dir_path( __FILE__ ) . 'class-talque-view-admin-page.php');


/**
 * The Main Talque menu in the Admin Panel
 *
 * @package    Talque_View
 * @subpackage Talque_View/admin
 * @author     Volker Braun <volker.braun@real-life-interaction.de>
 */
class Talque_View_Admin_Main extends Talque_View_Admin_Page {

    /**
     * The options defined in register_settings()
     */
    public static $options_list = array(
            'talque-org-id',
            'talque-view-id',
            'talque-backend',
    );
    
    /**
     * Initialize the class and set its properties.
     */
    public function __construct() {
        $this->load_dependencies();
    }

    /**
     * Dependency injection
     */
    private function load_dependencies() {
        $plugin = plugin_dir_path( dirname( __FILE__ ) );
        require_once $plugin . 'public/class-talque-view-api.php';
    }
    
    /**
     * Add the main Talque menu to the Admin Panel
     *
     * @mvc Controller
     */
    public function add_menu_page() {
        add_menu_page(
            'Talque',        // Page title
            'Talque',        // Menu entry
            self::REQUIRED_CAPABILITY,
            'talque_view_main',  // Slug
            __CLASS__ . '::page_html',
            $this->talque_logo_svg_data_uri(),
            20
        );
    }

    public function register_settings() {
        $org_id_args = array(
            'type' => 'string', 
            'default' => NULL,
        );
        register_setting('talque-group-main', 'talque-org-id', $org_id_args);

        $view_id_args = array(
            'type' => 'string', 
            'default' => NULL,
        );
        register_setting('talque-group-main', 'talque-view-id', $view_id_args);

        $backend_args = array(
            'type' => 'string', 
            'default' => Talque_View_API::DEFAULT_BACKEND,
        );
        register_setting('talque-group-main', 'talque-backend', $backend_args);
    }
    
    private function talque_logo_svg_data_uri() {
        $icon = plugin_dir_path( dirname( __FILE__ ) ) . 'admin/images/icon.svg';
        return 'data:image/svg+xml;base64,' . base64_encode(file_get_contents($icon));
    }
    
    public static function page_html() {
        // check user capabilities
        if (!current_user_can(self::REQUIRED_CAPABILITY)) {
            return;
        }
        require_once dirname(__FILE__) . '/partials/main-page.php';
    }
}

?>
