<?php

require_once plugin_dir_path( __FILE__ ) . 'class-talque-view-admin-page.php';


/**
 * The talque settings menu in the Admin Panel
 *
 * @package    Talque_View
 * @subpackage Talque_View/admin
 * @author     Volker Braun <volker.braun@real-life-interaction.de>
 */
class Talque_View_Admin_Settings extends Talque_View_Admin_Page {

    /**
     * The options from register_settings()
     */
    public static $options_list = array(
        'talque-url-speaker',
        'talque-url-lecture',
        'talque-url-vendor',
    );
    

    /**
     * Initialize the class and set its properties.
     */
    public function __construct() {
    }

    /**
     * Add the settings talque menu to the Admin Panel
     *
     * @mvc Controller
     */
    public function add_submenu_page() {
        add_submenu_page(
            'talque_view_main',      // Parent slug
            'Talque Settings',        // Page title
            'Settings',               // Menu entry
            self::REQUIRED_CAPABILITY,
            'talque_view_settings',  // Slug
            __CLASS__ . '::page_html'
        );
    }

    public function register_settings() {
        $speaker_args = array(
            'type' => 'string', 
            'default' => NULL,
        );
        register_setting('talque-group-url', 'talque-url-speaker', $speaker_args);
        
        $lecture_args = array(
            'type' => 'string', 
            'default' => NULL,
        );
        register_setting('talque-group-url', 'talque-url-lecture', $lecture_args);
        
        $vendor_args = array(
            'type' => 'string', 
            'default' => NULL,
        );
        register_setting('talque-group-url', 'talque-url-vendor', $vendor_args);
    }
    
    public static function page_html() {
        // check user capabilities
        if (!current_user_can(self::REQUIRED_CAPABILITY)) {
            return;
        }
        require_once dirname(__FILE__) . '/partials/settings-page.php';
    }
        
}


