<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://talque.com
 * @since      1.0.0
 *
 * @package    Talque_View
 * @subpackage Talque_View/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and the pages in the wp-admin interface
 *
 * @package    Talque_View
 * @subpackage Talque_View/admin
 * @author     Volker Braun <volker.braun@real-life-interaction.de>
 */
class Talque_View_Admin {

    /**
     * The ID of this plugin.
     *
     * @var      string    $plugin_name    The ID of this plugin.
     */
    private $plugin_name;

    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $version    The current version of this plugin.
     */
    private $version;

    private $page_main;
    private $page_settings;
    
    /**
     * Initialize the class and set its properties.
     *
     * @param      string    $plugin_name       The name of this plugin.
     * @param      string    $version    The version of this plugin.
     */
    public function __construct( $plugin_name, $version ) {
        $this->plugin_name = $plugin_name;
        $this->version = $version;
        $this->load_dependencies();
    }

    /**
     * Dependency injection
     */
    private function load_dependencies() {
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-talque-view-admin-main.php';
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-talque-view-admin-settings.php';
        $this->page_main = new Talque_View_Admin_Main();
        $this->page_settings = new Talque_View_Admin_Settings();
    }

    /**
     * Register the CSS and JavaScript for the admin area.
     */
    public function admin_enqueue_scripts_hook() {
        // wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/plugin-name-admin.css', array(), $this->version, 'all' );
        // wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/plugin-name-admin.js', array( 'jquery' ), $this->version, false );
    }

    /**
     * Initialize the admin area
     *
     * @mvc Controller
     */
    public function admin_init_hook() {
        $this->page_main->register_settings();
        $this->page_settings->register_settings();
    }

    /**
     * Adds pages to the Admin Panel menu
     *
     * @mvc Controller
     */
    public function admin_menu_hook() {
        $this->page_main->add_menu_page();
        $this->page_settings->add_submenu_page();
    }
}
    
