<?php

/**
 * Provide the main admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://talque.com
 * @since      1.0.0
 *
 * @package    Talque_View
 * @subpackage Talque_View/admin/partials
 */
?>


<div class="wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>

    <h2>Configuration</h2>

    <form action="options.php" method="post">

        <?php
        // output security fields for the registered setting "talque-view-main"
        settings_fields('talque-group-main');
        ?>

        <div>
            <label for="talque-org-id">Organization ID:</label>
            <input
                id="talque-org-id"
                type="text"
                name="talque-org-id"
                value="<?php echo esc_attr( get_option('talque-org-id') ); ?>" />
        </div>

        <div>
            <label for="talque-org-id">View ID:</label>
            <input
                id="talque-view-id"
                type="text"
                name="talque-view-id"
                value="<?php echo esc_attr( get_option('talque-view-id') ); ?>" />
        </div>

        <div>
            <label for="talque-backend">Backend:</label>
            <input
                id="talque-backend"
                type="text"
                name="talque-backend"
                value="<?php echo esc_attr( get_option('talque-backend') ); ?>" />
        </div>
        
        <?php
        // output save settings button
        submit_button('Save');
        ?>
        
    </form>

    <h2>Talque pages</h2>

    <p>
        The talque plugin comes with a set of predefined pages to
        display the content from your event. To add them to your
        Wordpress site menu, start by going to Appearance&rarr;Menus
        in the admin area and edit (or create) your menu.
    </p>

    <p>
        Click on <i>Screen Options</i> on the top right and make sure
        that Talque is selected under Boxes. Then you will see Talque
        as a source for menu entries, below Pages and Posts. The
        Talque options are:
    </p>

    <ul>
        <li>&bull;&nbsp;Sponsor Grid</li>
        <li>&bull;&nbsp;Exhibitor Grid</li>
        <li>&bull;&nbsp;Lecture List</li>
        <li>&bull;&nbsp;Lecture Grid</li>
        <li>&bull;&nbsp;Lecture Table</li>
        <li>&bull;&nbsp;Speaker List</li>
        <li>&bull;&nbsp;Speaker Grid</li>
    </ul>

    <p>
        Select your desired menu entries and click on <i>Add to Menu</i>.
    </p>

    <h2>Shortcodes</h2>
    
    <p>
        You can use the following shortcodes in blog posts and pages:
    </p>

    <ul>
        <li><tt>[talque-lecture-list]</tt> displays vertical list of talks</li>
        <li><tt>[talque-lecture-list date="yyyymmdd"]</tt> displays vertical list of talks
            on the given day (e.g. date="20180511" for May 11, 2018).</li>
        <li><tt>[talque-lecture-table]</tt> displays fixed-height time table of the talks.</li>
        <li><tt>[talque-lecture-grid]</tt> displays proportial height time table of the talks.</li>
        <li><tt>[talque-lecture-grid date="yyyymmdd"]</tt> displays time table on the given
            day.</li>
        <li><tt>[talque-speaker-list]</tt> displays a vertical list of all speakers</li>
        <li><tt>[talque-speaker-grid]</tt> displays all speakers in a 2-d grid</li>
        <li><tt>[talque-sponsor-grid]</tt> displays a grid of all sponsors</li>
        <li><tt>[talque-exhibitor-grid]</tt> displays a grid of all exhibitors</li>
    </p>

    <h2>Further documentation</h2>

    <p>
        Our complete documentation for the talque Wordpress plugin can be found at
        <a href="https://talque.gitbook.io">https://talque.gitbook.io</a>.
    </p>
</div>


