<?php

/**
 * Provide the admin area settings view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://talque.com
 * @since      1.0.0
 *
 * @package    Talque_View
 * @subpackage Talque_View/admin/partials
 */
?>


<div class="wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>

    <h2>Custom URLs</h2>

    <p>
        You can create additional custom URLs for speakers, talks,
        sponsors, and exhibitors. By default, the generated page where
        a single entity (speaker / lecture / sponsor / exhibitor) is
        shown uses a query parameter and internal id to identify the
        entity. Here you can alternatively define a custom url path
        where the page should be listed with a human-readable name
        derived from the speaker / sponsor / exhibitor name or lecture
        title.  Custom URL structures can improve the aesthetics,
        usability, and forward-compatibility of your links. Note:
        Custom URLs only work if the Wordpress rewrite engine is
        active, that is, Settings&rarr;Permalinks&rarr;Common Settings
        must be set to something else than <i>Plain</i>.
    </p>
 
    <form action="options.php" method="post">

        <?php
        // output security fields for the registered setting "talque-group-url"
        settings_fields('talque-group-url');
        ?>

        <div>
            <label for="talque-url-speaker">Speaker URL:</label>
            <span><?php echo get_home_url() ?>/</span>
            <input
                id="talque-url-speaker"
                type="text"
                name="talque-url-speaker"
                value="<?php echo esc_attr( get_option('talque-url-speaker') ); ?>" />
            <span>/first_last</span>
        </div>

        <div>
            <label for="talque-url-lecture">Talk URL:</label>
            <span><?php echo get_home_url() ?>/</span>
            <input
                id="talque-url-lecture"
                type="text"
                name="talque-url-lecture"
                value="<?php echo esc_attr( get_option('talque-url-lecture') ); ?>" />
            <span>/title_of_talk</span>
        </div>
        
        <div>
            <label for="talque-url-vendor">Partner URL:</label>
            <span><?php echo get_home_url() ?>/</span>
            <input
                id="talque-url-vendor"
                type="text"
                name="talque-url-vendor"
                value="<?php echo esc_attr( get_option('talque-url-vendor') ); ?>" />
            <span>/name_of_partner</span>
        </div>
        
        <?php
        // output save settings button
        submit_button('Save');
        ?>

    </form>

</div>


