<?php

/**
 * Fired during plugin activation
 *
 * @link       https://talque.com
 * @since      1.0.0
 *
 * @package    Talque_View
 * @subpackage Talque_View/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Talque_View
 * @subpackage Talque_View/includes
 * @author     Volker Braun <volker.braun@real-life-interaction.de>
 */
class Talque_View_Activator {

    /**
     * Activate the Talque View plugin.
     *
     * TODO.
     *
     * @since    1.0.0
     */
    public static function activate() {
        error_log( 'Activating the Talque View plugin' );
        Talque_View_Posts::get_instance()->activate_plugin_hook();
        flush_rewrite_rules();
    }

}
