<?php

/**
 * Fired during plugin deactivation
 *
 * @link       https://talque.com
 * @since      1.0.0
 *
 * @package    Talque_View
 * @subpackage Talque_View/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    Talque_View
 * @subpackage Talque_View/includes
 * @author     Volker Braun <volker.braun@real-life-interaction.de>
 */
class Talque_View_Deactivator {

    /**
     * Activate the Talque View plugin.
     *
     * TODO
     *
     * @since    1.0.0
     */
    public static function deactivate() {
        error_log( 'Deactivating the Talque View plugin' );
        Talque_View_Posts::get_instance()->deactivate_plugin_hook();
    }

}
