<?php

/**
 * Settings for customizing the filters
 *
 * @link       https://talque.com
 * @since      1.0.0
 *
 * @package    Talque_View
 * @subpackage Talque_View/public
 */


/**
 * Settings for customizing the appearence of the Talque backend
 *
 * @package    Talque_View
 * @subpackage Talque_View/public
 * @author     Volker Braun <volker.braun@real-life-interaction.de>
 */
class Talque_View_Filter {

    // Timezone override
    private $timezone;
    
    // Lecture filters
    private $tags;
    private $formats;
    private $topics;

    // Speaker filters
    private $badges;
    
    // Vendor filters

    private $sponsors;
    private $exhibitors;

    /**
     * Initialize the class and set its properties.
     */
    public function __construct($timezone, $tags, $formats, $topics, $badges, $sponsors, $exhibitors) {
        $this->timezone = $timezone;
        $this->tags = $tags;
        $this->formats = $formats;
        $this->topics = $topics;
        $this->badges = $badges;
        $this->sponsors = $sponsors;
        $this->exhibitors = $exhibitors;
    }

    public static function make_empty() {
        return new Talque_View_Filter( NULL, NULL, NULL, NULL, NULL, NULL, NULL );
    }
    
    public static function from_shortcode( $sanitized ) {
        return new Talque_View_Filter(
            isset($sanitized['timezone']) ? $sanitized['timezone'] : NULL,
            isset($sanitized['tags']) ? $sanitized['tags'] : NULL,
            isset($sanitized['formats']) ? $sanitized['formats'] : NULL,
            isset($sanitized['topics']) ? $sanitized['topics'] : NULL,
            isset($sanitized['badges']) ? $sanitized['badges'] : NULL,
            isset($sanitized['sponsors']) ? $sanitized['sponsors'] : NULL,
            isset($sanitized['exhibitors']) ? $sanitized['exhibitors'] : NULL
        );
    }

    public function html_snippet_attributes() {
        $template = 
            '  timezone="%s"'.
            '  require-tags="%s"'.
            '  require-formats="%s"'.
            '  require-topics="%s"'.
            '  require-badges="%s"'.
            '  require-sponsors="%s"'.
            '  require-exhibitors="%s"';
        return sprintf(
            $template,
            $this->timezone,
            $this->tags,
            $this->formats,
            $this->topics,
            $this->badges,
            $this->sponsors,
            $this->exhibitors
        );
    }
}
