<?php

/**
 * The public functionality of the plugin.
 *
 * @link       https://talque.com
 * @since      1.0.0
 *
 * @package    Talque_View
 * @subpackage Talque_View/public
 */

/**
 * The public functionality of the plugin.
 *
 * Defines the plugin name, version, and the custom post types
 *
 * @package    Talque_View
 * @subpackage Talque_View/public
 * @author     Volker Braun <volker.braun@real-life-interaction.de>
 */
class Talque_View_Public {

    /**
     * The ID of this plugin.
     *
     * @var      string    $plugin_name    The ID of this plugin.
     */
    private $plugin_name;

    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $version    The current version of this plugin.
     */
    private $version;

    /**
     * Initialize the class and set its properties.
     *
     * @param      string    $plugin_name       The name of this plugin.
     * @param      string    $version    The version of this plugin.
     */
    public function __construct( $plugin_name, $version ) {
        $this->plugin_name = $plugin_name;
        $this->version = $version;
        $this->load_dependencies();
    }

    /**
     * Dependency injection
     */
    private function load_dependencies() {
    }

}
