<?php

/**
 * Custom shortcodes for the talque plugin.
 *
 * @link       https://talque.com
 * @since      1.0.0
 *
 * @package    Talque_View
 * @subpackage Talque_View/admin
 */

/**
 * Custom shortcodes for the talque plugin.
 *
 * Defines the plugin name, version, and the shortcodes
 *
 * @package    Talque_View
 * @subpackage Talque_View/public
 * @author     Volker Braun <volker.braun@real-life-interaction.de>
 */
class Talque_View_Shortcodes {

    /**
     * The ID of this plugin.
     *
     * @var      string    $plugin_name    The ID of this plugin.
     */
    private $plugin_name;

    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $version    The current version of this plugin.
     */
    private $version;

    /**
     * Backend API access
     *
     * @var      Talque_View_API    $instance    The backend API.
     */
    private static $api;

    /**
     * Initialize the class and set its properties.
     *
     * @param      string    $plugin_name       The name of this plugin.
     * @param      string    $version    The version of this plugin.
     */
    public function __construct( $plugin_name, $version, $api ) {
        // Initialization
        $this->plugin_name = $plugin_name;
        $this->version = $version;
        self::$api = $api;
        $this->load_dependencies();
        $this->register_shortcodes();
    }

    /**
     * Dependency injection
     */
    private function load_dependencies() {
    }

    /**
     * Initialize the plugin
     */
    public function init_hook() {
    }

    /**
     * Register the shortcodes with Wordpress
     */
    private function register_shortcodes() {
        add_shortcode( 'talque-lecture-list', array( $this, 'lecture_list_shortcode' ) );
        add_shortcode( 'talque-lecture-table', array( $this, 'lecture_table_shortcode' ) );
        add_shortcode( 'talque-lecture-grid', array( $this, 'lecture_grid_shortcode' ) );
        add_shortcode( 'talque-speaker-list', array( $this, 'speaker_list_shortcode' ) );
        add_shortcode( 'talque-speaker-grid', array( $this, 'speaker_grid_shortcode' ) );
        add_shortcode( 'talque-sponsor-grid', array( $this, 'sponsor_grid_shortcode' ) );
        add_shortcode( 'talque-exhibitor-grid', array( $this, 'exhibitor_grid_shortcode' ) );
    }

    public function lecture_list_shortcode( $attrs, $content, $shortcode_tag ) {
        $settings = Talque_View_Settings::from_lecture_shortcode( $attrs, $shortcode_tag );
        try {
            return self::$api->lecture_list( $settings );
        } catch ( Talque_View_API_Error $error ) {
            return $this->show_error( $error );
        }
    }

    public function lecture_table_shortcode( $attrs, $content, $shortcode_tag ) {
        $settings = Talque_View_Settings::from_lecture_shortcode( $attrs, $shortcode_tag );
        try {
            return self::$api->lecture_table( $settings );
        } catch ( Talque_View_API_Error $error ) {
            return $this->show_error( $error );
        }
    }

    public function lecture_grid_shortcode( $attrs, $content, $shortcode_tag ) {
        $settings = Talque_View_Settings::from_lecture_shortcode( $attrs, $shortcode_tag );
        try {
            return self::$api->lecture_grid( $settings );
        } catch ( Talque_View_API_Error $error ) {
            return $this->show_error( $error );
        }
    }

    public function speaker_list_shortcode( $attrs, $content, $shortcode_tag ) {
        $settings = Talque_View_Settings::from_speaker_shortcode( $attrs, $shortcode_tag );
        try {
            return self::$api->speaker_list( $settings );
        } catch ( Talque_View_API_Error $error ) {
            return $this->show_error( $error );
        }
    }
    
    public function speaker_grid_shortcode( $attrs, $content, $shortcode_tag ) {
        $settings = Talque_View_Settings::from_speaker_shortcode( $attrs, $shortcode_tag );
        try {
            return self::$api->speaker_grid( $settings );
        } catch ( Talque_View_API_Error $error ) {
            return $this->show_error( $error );
        }
    }
    
    public function sponsor_grid_shortcode( $attrs, $content, $shortcode_tag ) {
        $settings = Talque_View_Settings::from_sponsor_shortcode( $attrs, $shortcode_tag );
        try {
            return self::$api->sponsor_grid( $settings );
        } catch ( Talque_View_API_Error $error ) {
            return $this->show_error( $error );
        }
    }

    public function exhibitor_grid_shortcode( $attrs, $content, $shortcode_tag ) {
        $settings = Talque_View_Settings::from_exhibitor_shortcode( $attrs, $shortcode_tag );
        try {
            return self::$api->exhibitor_grid( $settings );
        } catch ( Talque_View_API_Error $error ) {
            return $this->show_error( $error );
        }
    }

    /**
     * Render error message
     */
    private function show_error( $error ) {
        error_log( 'Error: ' . $error );
        return $error->getMessage();
    }
}

