<?php
/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 * 
 * @wordpress-plugin
 * Plugin Name:       Talque View
 * Plugin URI:        https://talque.com
 * Description:       Show your event data from talque.com in your wordpress page
 * Version:           2.1.2
 * Author:            Real Life Interaction GmbH
 * Author URI:        https://talque.com
 * License:           
 * License URI:       
 * Text Domain:       talque-view
 * Domain Path:       /languages
 */


define( 'TALQUE_VIEW_VERSION', '2.1.2' );


///////////////////////////////////////////////
// If this file is called directly, abort.

if ( ! defined( 'WPINC' ) ) {
    die;
}


///////////////////////////////////////////////
// Activate / Deactivate plugin

function activate_talque_view() {
    require_once plugin_dir_path( __FILE__ ) . 'includes/class-talque-view-activator.php';
    Talque_View_Activator::activate();
}

function deactivate_talque_view() {
    require_once plugin_dir_path( __FILE__ ) . 'includes/class-talque-view-deactivator.php';
    Talque_View_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_talque_view' );
register_deactivation_hook( __FILE__, 'deactivate_talque_view' );


///////////////////////////////////////////////
// Run the actual plugin

require plugin_dir_path( __FILE__ ) . 'includes/class-talque-view.php';

function run_talque_view() {
    $plugin = new Talque_View();
    $plugin->run();
}

run_talque_view();
