<?php
/**
 * Runs on uninstall of the Talque View plugin
 *
 * @package   Talque View
 * @author    Volker Braun
 * @link      https://talque.com
 */

// If uninstall not called from WordPress, then exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

error_log( 'Uninstalling the talque view plugin' );


require_once plugin_dir_path( __FILE__ ) . 'admin/class-talque-view-admin-main.php';
require_once plugin_dir_path( __FILE__ ) . 'admin/class-talque-view-admin-settings.php';

$options = array_merge(
    Talque_View_Admin_Main::$options_list,
    Talque_View_Admin_Settings::$options_list
);


foreach ( $options as $option ) {
    delete_option($option_name);
    delete_site_option($option_name);
}

