(function() {
  var cli, config, deep_get, deep_merge, deep_set, defaults, inplace_merge, isArray, load_files, map, options, ruthless_load_files, _ref,
    __slice = Array.prototype.slice;

  cli = require('cli');

  _ref = require('./util'), deep_merge = _ref.deep_merge, deep_set = _ref.deep_set, deep_get = _ref.deep_get, inplace_merge = _ref.inplace_merge, load_files = _ref.load_files, ruthless_load_files = _ref.ruthless_load_files;

  isArray = Array.isArray;

  defaults = {};

  map = {
    env: {},
    opts: {},
    args: []
  };

  options = {
    'cli': false,
    'cli parse': false,
    'ignore unknown': false
  };

  module.exports = config = {
    merge: function(more) {
      var files;
      files = void 0;
      if (typeof more === 'string') {
        files = [more];
      } else if (isArray(more)) {
        files = more;
      }
      if (files != null) {
        if (options['ignore unknown']) {
          more = ruthless_load_files.apply(null, files);
        } else {
          more = load_files.apply(null, files);
        }
      }
      inplace_merge(config, more);
      return this;
    },
    defaults: function() {
      var files;
      files = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      if (options['ignore unknown']) {
        defaults = deep_merge(defaults, ruthless_load_files.apply(null, files));
      } else {
        defaults = deep_merge(defaults, load_files.apply(null, files));
      }
      return this;
    },
    set: function(key, value) {
      if (map[key] != null) {
        map[key] = value;
      } else {
        options[key] = value;
      }
      return this;
    },
    cli: function(opts) {
      if (typeof opts === 'function') {
        options['cli'] = opts;
      } else {
        if (options['cli'] === false) options['cli'] = true;
        if (isArray(opts)) {
          if (options['cli parse'] === false) options['cli parse'] = [];
          options['cli parse'] = options['cli parse'].concat(opts);
        } else {
          if (options['cli parse'] === false) options['cli parse'] = {};
          inplace_merge(options['cli parse'], opts);
        }
      }
      return this;
    },
    load: function() {
      var callback, conf, files, finish, key, load_configs, target, value, _i, _ref2, _ref3,
        _this = this;
      files = 2 <= arguments.length ? __slice.call(arguments, 0, _i = arguments.length - 1) : (_i = 0, []), callback = arguments[_i++];
      if (typeof callback !== 'function') {
        files.push(callback);
        callback = void 0;
      }
      if (options['cli'] && !(callback != null)) {
        throw new Error('if you want to use cli you have to provide a callback.');
      }
      _ref2 = map.env;
      for (key in _ref2) {
        target = _ref2[key];
        if (process.env[key] == null) continue;
        if (isArray(target)) {
          deep_set(defaults, target[0], target[1](process.env[key]));
        } else {
          deep_set(defaults, target, process.env[key]);
        }
      }
      conf = deep_merge({}, defaults);
      finish = function(args, opts) {
        var key, old_merge, optsdiff, target, _j, _len, _ref3, _ref4, _ref5;
        _ref3 = map.env;
        for (key in _ref3) {
          target = _ref3[key];
          if (process.env[key] == null) continue;
          if (isArray(target)) {
            deep_set(conf, target[0], target[1](process.env[key]));
          } else {
            deep_set(conf, target, process.env[key]);
          }
        }
        optsdiff = {};
        if (opts != null) {
          _ref4 = map.opts;
          for (key in _ref4) {
            target = _ref4[key];
            if (!opts[key]) continue;
            if (opts[key] === deep_get(defaults, target)) continue;
            deep_set(optsdiff, target, opts[key]);
            deep_set(conf, target, opts[key]);
          }
        }
        _ref5 = ['defaults', 'set', 'cli', 'load'];
        for (_j = 0, _len = _ref5.length; _j < _len; _j++) {
          key = _ref5[_j];
          delete config[key];
        }
        defaults = {};
        inplace_merge(config, conf);
        old_merge = _this.merge;
        _this.merge = function() {
          var result;
          result = old_merge.apply(null, arguments);
          inplace_merge(config, optsdiff);
          return result;
        };
        return callback != null ? callback.apply(_this, arguments) : void 0;
      };
      load_configs = function() {
        var args;
        args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
        if (options['ignore unknown']) {
          conf = deep_merge(conf, ruthless_load_files.apply(null, files));
        } else {
          conf = deep_merge(conf, load_files.apply(null, files));
        }
        return finish.apply(null, args);
      };
      if (!(options['cli'] === false || typeof options['cli'] === 'function')) {
        options['cli'] = function(callback) {
          return cli.main(callback);
        };
      }
      if (options['cli']) {
        if (options['ignore unknown']) {
          cli.fatal = function(msg, type) {
            if (type === 'fatal') type = 'error';
            return cli.status(msg, type);
          };
        }
        if (options['cli parse'] != null) {
          _ref3 = options['cli parse'];
          for (key in _ref3) {
            value = _ref3[key];
            if (isArray(value) && isArray(value[1])) {
              map.opts[key] = value[0];
              options['cli parse'][key] = value = value[1];
            }
            if ((map.opts[key] != null) && value.length === 3) {
              value.push(deep_get(conf, map.opts[key]));
            }
          }
          cli.parse(options['cli parse']);
        }
        options['cli'](load_configs);
      } else {
        return load_configs();
      }
    }
  };

}).call(this);
