(function() {
  var deep_get, deep_merge, deep_set, inplace_merge, isArray, load_files, ruthless_load_files, _load_files,
    __slice = Array.prototype.slice;

  isArray = Array.isArray;

  deep_merge = function() {
    var k, obj, objs, res, v, _i, _len;
    objs = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    if (isArray(objs[0])) objs = objs[0];
    res = {};
    for (_i = 0, _len = objs.length; _i < _len; _i++) {
      obj = objs[_i];
      for (k in obj) {
        v = obj[k];
        if (typeof v === 'object' && !isArray(v)) {
          res[k] = deep_merge(res[k] || {}, v);
        } else {
          res[k] = v;
        }
      }
    }
    return res;
  };

  deep_set = function(obj, target, value) {
    var key, part, pointer, _i, _len;
    pointer = obj;
    target = target.split('.');
    key = target.pop();
    for (_i = 0, _len = target.length; _i < _len; _i++) {
      part = target[_i];
      if (pointer[part] == null) pointer[part] = {};
      pointer = pointer[part];
    }
    pointer[key] = value;
    return obj;
  };

  deep_get = function(obj, target) {
    var key, part, _i, _len;
    target = target.split('.');
    key = target.pop();
    for (_i = 0, _len = target.length; _i < _len; _i++) {
      part = target[_i];
      obj = obj[part];
      if (obj == null) return;
    }
    return obj[key];
  };

  inplace_merge = function(target, obj) {
    var k, v;
    for (k in obj) {
      v = obj[k];
      target[k] = v;
    }
    return target;
  };

  _load_files = function(files, callback) {
    var conf, file, _i, _len;
    conf = {};
    for (_i = 0, _len = files.length; _i < _len; _i++) {
      file = files[_i];
      if (!(file != null ? file.length : void 0)) continue;
      conf = deep_merge(conf, callback(file) || {});
    }
    return conf;
  };

  load_files = function() {
    var files;
    files = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    return _load_files(files, function(file) {
      return require(file);
    });
  };

  ruthless_load_files = function() {
    var files;
    files = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    return _load_files(files, function(file) {
      try {
        return require(file);
      } catch (err) {
        return console.error("Cannot find config '" + file + "'.");
      }
    });
  };

  module.exports = {
    deep_merge: deep_merge,
    deep_set: deep_set,
    deep_get: deep_get,
    inplace_merge: inplace_merge,
    load_files: load_files,
    ruthless_load_files: ruthless_load_files
  };

}).call(this);
