/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

@BugPattern(name="MissingSuperCall", summary="Overriding method is missing a call to overridden super method", severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.NO_FIX)
public class MissingSuperCall
extends BugChecker
implements BugChecker.AnnotationTreeMatcher,
BugChecker.MethodTreeMatcher {
    private static final Matcher<AnnotationTree> ANNOTATION_MATCHER = Matchers.anyOf((Iterable)((Iterable)Stream.of(AnnotationType.values()).map(anno -> Matchers.isType((String)anno.fullyQualifiedName())).collect(ImmutableList.toImmutableList())));

    public Description matchAnnotation(AnnotationTree tree, VisitorState state) {
        if (!ANNOTATION_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        MethodTree methodTree = (MethodTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), MethodTree.class);
        if (methodTree == null) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol methodSym = ASTHelpers.getSymbol((MethodTree)methodTree);
        if (methodSym == null) {
            return Description.NO_MATCH;
        }
        if (!methodSym.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return Description.NO_MATCH;
        }
        Symbol annotationSym = ASTHelpers.getSymbol((Tree)tree);
        if (annotationSym == null) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(String.format("@%s cannot be applied to an abstract method", annotationSym.getSimpleName())).build();
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol methodSym = ASTHelpers.getSymbol((MethodTree)tree);
        if (methodSym == null) {
            return Description.NO_MATCH;
        }
        if (methodSym.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return Description.NO_MATCH;
        }
        String annotatedSuperMethod = null;
        String matchedAnnotationSimpleName = null;
        block0: for (Symbol.MethodSymbol method : ASTHelpers.findSuperMethods((Symbol.MethodSymbol)methodSym, (Types)state.getTypes())) {
            for (AnnotationType annotationType : AnnotationType.values()) {
                if (!ASTHelpers.hasAnnotation((Symbol)method, (String)annotationType.fullyQualifiedName(), (VisitorState)state)) continue;
                annotatedSuperMethod = MissingSuperCall.getMethodName(method);
                matchedAnnotationSimpleName = annotationType.simpleName();
                continue block0;
            }
        }
        if (annotatedSuperMethod == null || matchedAnnotationSimpleName == null) {
            return Description.NO_MATCH;
        }
        FindSuperTreeScanner findSuper = new FindSuperTreeScanner(tree.getName().toString());
        if (((Boolean)findSuper.scan(tree, null)).booleanValue()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(String.format("This method overrides %s, which is annotated with @%s, but does not call the super method", annotatedSuperMethod, matchedAnnotationSimpleName)).build();
    }

    private static String getMethodName(Symbol.MethodSymbol methodSym) {
        return String.format("%s#%s", methodSym.owner.toString(), methodSym.getSimpleName());
    }

    private static boolean isSuper(ExpressionTree tree) {
        return tree.getKind() == Tree.Kind.IDENTIFIER && ((IdentifierTree)tree).getName().contentEquals("super");
    }

    private static class FindSuperTreeScanner
    extends TreeScanner<Boolean, Void> {
        private String overridingMethodName;

        private FindSuperTreeScanner(String overridingMethodName) {
            this.overridingMethodName = overridingMethodName;
        }

        @Override
        public Boolean visitMethodInvocation(MethodInvocationTree tree, Void unused) {
            ExpressionTree methodSelect;
            boolean result = false;
            Symbol.MethodSymbol methodSym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
            if (methodSym != null && (methodSelect = tree.getMethodSelect()).getKind() == Tree.Kind.MEMBER_SELECT) {
                MemberSelectTree memberSelect = (MemberSelectTree)methodSelect;
                result = MissingSuperCall.isSuper(memberSelect.getExpression()) && memberSelect.getIdentifier().contentEquals(this.overridingMethodName);
            }
            return result || (Boolean)super.visitMethodInvocation(tree, unused) != false;
        }

        @Override
        public Boolean reduce(Boolean b1, Boolean b2) {
            return (Boolean)MoreObjects.firstNonNull((Object)b1, (Object)false) != false || (Boolean)MoreObjects.firstNonNull((Object)b2, (Object)false) != false;
        }
    }

    private static enum AnnotationType {
        ANDROID("android.support.annotation.CallSuper"),
        ERROR_PRONE("com.google.errorprone.annotations.OverridingMethodsMustInvokeSuper"),
        JSR305("javax.annotation.OverridingMethodsMustInvokeSuper"),
        FINDBUGS("edu.umd.cs.findbugs.annotations.OverrideMustInvoke");

        private final String fullyQualifiedName;

        private AnnotationType(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        public String fullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public String simpleName() {
            int index = this.fullyQualifiedName().lastIndexOf(46);
            if (index >= 0) {
                return this.fullyQualifiedName().substring(index + 1);
            }
            return this.fullyQualifiedName();
        }
    }
}

