/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.topic.TopicOverloadPolicy;
import com.hazelcast.util.Preconditions;
import java.util.concurrent.Executor;

public class ClientReliableTopicConfig {
    public static final int DEFAULT_READ_BATCH_SIZE = 10;
    public static final TopicOverloadPolicy DEFAULT_TOPIC_OVERLOAD_POLICY = TopicOverloadPolicy.BLOCK;
    private Executor executor;
    private int readBatchSize = 10;
    private String name;
    private TopicOverloadPolicy topicOverloadPolicy = DEFAULT_TOPIC_OVERLOAD_POLICY;

    public ClientReliableTopicConfig(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (String)"name");
    }

    public String getName() {
        return this.name;
    }

    public TopicOverloadPolicy getTopicOverloadPolicy() {
        return this.topicOverloadPolicy;
    }

    public ClientReliableTopicConfig setTopicOverloadPolicy(TopicOverloadPolicy topicOverloadPolicy) {
        this.topicOverloadPolicy = (TopicOverloadPolicy)Preconditions.checkNotNull((Object)topicOverloadPolicy, (String)"topicOverloadPolicy can't be null");
        return this;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public ClientReliableTopicConfig setExecutor(Executor executor) {
        this.executor = executor;
        return this;
    }

    public int getReadBatchSize() {
        return this.readBatchSize;
    }

    public ClientReliableTopicConfig setReadBatchSize(int readBatchSize) {
        this.readBatchSize = Preconditions.checkPositive((int)readBatchSize, (String)"readBatchSize should be positive");
        return this;
    }

    public String toString() {
        return "ClientReliableTopicConfig{name='" + this.name + '\'' + ", topicOverloadPolicy=" + this.topicOverloadPolicy + ", executor=" + this.executor + ", readBatchSize=" + this.readBatchSize + '}';
    }
}

