/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.client;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.replicatedmap.impl.client.ReplicatedMapPortableHook;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ReplicatedMapEntries
implements Portable {
    private final List<Map.Entry<Data, Data>> entries;

    public ReplicatedMapEntries() {
        this.entries = new ArrayList<Map.Entry<Data, Data>>();
    }

    public ReplicatedMapEntries(List<Map.Entry<Data, Data>> entries) {
        this.entries = entries;
    }

    public List<Map.Entry<Data, Data>> getEntries() {
        return this.entries;
    }

    public void add(Map.Entry<Data, Data> entry) {
        this.entries.add(entry);
    }

    public void add(Data key, Data value) {
        this.entries.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(key, value));
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeInt("size", this.entries.size());
        ObjectDataOutput out = writer.getRawDataOutput();
        for (Map.Entry<Data, Data> entry : this.entries) {
            out.writeData(entry.getKey());
            out.writeData(entry.getValue());
        }
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        int size = reader.readInt("size");
        ObjectDataInput in = reader.getRawDataInput();
        for (int i = 0; i < size; ++i) {
            Data key = in.readData();
            Data value = in.readData();
            this.entries.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(key, value));
        }
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 12;
    }
}

