/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ringbuffer.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IFunction;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.ringbuffer.ReadResultSet;
import com.hazelcast.ringbuffer.impl.RingbufferDataSerializerHook;
import com.hazelcast.util.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.AbstractList;

public class ReadResultSetImpl<E>
extends AbstractList<E>
implements IdentifiedDataSerializable,
HazelcastInstanceAware,
ReadResultSet<E> {
    private transient int minSize;
    private transient int maxSize;
    private transient IFunction<Object, Boolean> filter;
    private transient HazelcastInstance hz;
    private Data[] items;
    private int size;
    private int readCount;

    public ReadResultSetImpl() {
    }

    public ReadResultSetImpl(int minSize, int maxSize, HazelcastInstance hz, IFunction<Object, Boolean> filter) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.items = new Data[maxSize];
        this.hz = hz;
        this.filter = filter;
    }

    public boolean isMaxSizeReached() {
        return this.size == this.maxSize;
    }

    public boolean isMinSizeReached() {
        return this.size >= this.minSize;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Data[] getDataItems() {
        return this.items;
    }

    @Override
    public int readCount() {
        return this.readCount;
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hz) {
        this.hz = hz;
    }

    @Override
    public E get(int index) {
        Preconditions.checkNotNegative(index, "index should not be negative");
        Preconditions.checkTrue(index < this.size, "index should not be equal or larger than size");
        SerializationService serializationService = this.getSerializationService();
        Data item = this.items[index];
        return (E)serializationService.toObject(item);
    }

    private SerializationService getSerializationService() {
        HazelcastInstanceImpl impl = (HazelcastInstanceImpl)this.hz;
        return impl.getSerializationService();
    }

    public void addItem(Object item) {
        assert (this.size < this.maxSize);
        ++this.readCount;
        if (!this.acceptable(item)) {
            return;
        }
        this.items[this.size] = this.getSerializationService().toData(item);
        ++this.size;
    }

    private boolean acceptable(Object item) {
        if (this.filter == null) {
            return true;
        }
        Object object = this.getSerializationService().toObject(item);
        return this.filter.apply(object);
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int getFactoryId() {
        return RingbufferDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 9;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.readCount);
        out.writeInt(this.size);
        for (int k = 0; k < this.size; ++k) {
            out.writeData(this.items[k]);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.readCount = in.readInt();
        this.size = in.readInt();
        this.items = new Data[this.size];
        for (int k = 0; k < this.size; ++k) {
            this.items[k] = in.readData();
        }
    }
}

