/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.executionservice.impl;

import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.instance.HazelcastThreadGroup;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.executionservice.InternalExecutionService;
import com.hazelcast.spi.impl.executionservice.impl.CompletableFutureEntry;
import com.hazelcast.spi.impl.executionservice.impl.CompletableFutureTask;
import com.hazelcast.spi.impl.executionservice.impl.ScheduledExecutorServiceDelegate;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.executor.CachedExecutorServiceDelegate;
import com.hazelcast.util.executor.ExecutorType;
import com.hazelcast.util.executor.ManagedExecutorService;
import com.hazelcast.util.executor.NamedThreadPoolExecutor;
import com.hazelcast.util.executor.PoolExecutorThreadFactory;
import com.hazelcast.util.executor.SingleExecutorThreadFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ExecutionServiceImpl
implements InternalExecutionService {
    private static final int CORE_POOL_SIZE = 3;
    private static final long KEEP_ALIVE_TIME = 60L;
    private static final long INITIAL_DELAY = 1000L;
    private static final long PERIOD = 100L;
    private static final int BEGIN_INDEX = 3;
    private static final long AWAIT_TIME = 3L;
    private static final int POOL_MULTIPLIER = 2;
    private static final int QUEUE_MULTIPLIER = 100000;
    private final NodeEngineImpl nodeEngine;
    private final ExecutorService cachedExecutorService;
    private final ScheduledExecutorService scheduledExecutorService;
    private final ScheduledExecutorService defaultScheduledExecutorServiceDelegate;
    private final ILogger logger;
    private final CompletableFutureTask completableFutureTask;
    private final ConcurrentMap<String, ManagedExecutorService> executors = new ConcurrentHashMap<String, ManagedExecutorService>();
    private final ConstructorFunction<String, ManagedExecutorService> constructor = new ConstructorFunction<String, ManagedExecutorService>(){

        @Override
        public ManagedExecutorService createNew(String name) {
            ExecutorConfig cfg = ExecutionServiceImpl.this.nodeEngine.getConfig().findExecutorConfig(name);
            int queueCapacity = cfg.getQueueCapacity() <= 0 ? Integer.MAX_VALUE : cfg.getQueueCapacity();
            return ExecutionServiceImpl.this.createExecutor(name, cfg.getPoolSize(), queueCapacity, ExecutorType.CACHED);
        }
    };
    private final MetricsRegistry metricsRegistry;

    public ExecutionServiceImpl(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.metricsRegistry = nodeEngine.getMetricsRegistry();
        Node node = nodeEngine.getNode();
        this.logger = node.getLogger(ExecutionService.class.getName());
        HazelcastThreadGroup threadGroup = node.getHazelcastThreadGroup();
        PoolExecutorThreadFactory threadFactory = new PoolExecutorThreadFactory(threadGroup, "cached");
        this.cachedExecutorService = new ThreadPoolExecutor(3, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory, new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                if (ExecutionServiceImpl.this.logger.isFinestEnabled()) {
                    ExecutionServiceImpl.this.logger.finest("Node is shutting down; discarding the task: " + r);
                }
            }
        });
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(1, new SingleExecutorThreadFactory(threadGroup, "scheduled"));
        this.enableRemoveOnCancelIfAvailable();
        int coreSize = Runtime.getRuntime().availableProcessors();
        this.register("hz:system", coreSize, Integer.MAX_VALUE, ExecutorType.CACHED);
        this.register("hz:scheduled", coreSize * 2, coreSize * 100000, ExecutorType.CACHED);
        this.defaultScheduledExecutorServiceDelegate = this.getScheduledExecutor("hz:scheduled");
        this.completableFutureTask = new CompletableFutureTask();
        this.scheduleWithFixedDelay(this.completableFutureTask, 1000L, 100L, TimeUnit.MILLISECONDS);
    }

    private void enableRemoveOnCancelIfAvailable() {
        try {
            Method m = this.scheduledExecutorService.getClass().getMethod("setRemoveOnCancelPolicy", Boolean.TYPE);
            m.invoke((Object)this.scheduledExecutorService, true);
        }
        catch (NoSuchMethodException ignored) {
            EmptyStatement.ignore(ignored);
        }
        catch (InvocationTargetException ignored) {
            EmptyStatement.ignore(ignored);
        }
        catch (IllegalAccessException ignored) {
            EmptyStatement.ignore(ignored);
        }
    }

    @Override
    public ManagedExecutorService register(String name, int defaultPoolSize, int defaultQueueCapacity, ExecutorType type) {
        ManagedExecutorService executor;
        ExecutorConfig cfg = this.nodeEngine.getConfig().getExecutorConfigs().get(name);
        int poolSize = defaultPoolSize;
        int queueCapacity = defaultQueueCapacity;
        if (cfg != null) {
            poolSize = cfg.getPoolSize();
            queueCapacity = cfg.getQueueCapacity() <= 0 ? Integer.MAX_VALUE : cfg.getQueueCapacity();
        }
        if (this.executors.putIfAbsent(name, executor = this.createExecutor(name, poolSize, queueCapacity, type)) != null) {
            throw new IllegalArgumentException("ExecutorService['" + name + "'] already exists!");
        }
        this.metricsRegistry.scanAndRegister(executor, "executor." + name);
        return executor;
    }

    private ManagedExecutorService createExecutor(String name, int poolSize, int queueCapacity, ExecutorType type) {
        ManagedExecutorService executor;
        if (type == ExecutorType.CACHED) {
            executor = new CachedExecutorServiceDelegate(this.nodeEngine, name, this.cachedExecutorService, poolSize, queueCapacity);
        } else if (type == ExecutorType.CONCRETE) {
            Node node = this.nodeEngine.getNode();
            String internalName = name.startsWith("hz:") ? name.substring(3) : name;
            HazelcastThreadGroup hazelcastThreadGroup = node.getHazelcastThreadGroup();
            PoolExecutorThreadFactory threadFactory = new PoolExecutorThreadFactory(hazelcastThreadGroup, hazelcastThreadGroup.getThreadPoolNamePrefix(internalName));
            NamedThreadPoolExecutor pool = new NamedThreadPoolExecutor(name, poolSize, poolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueCapacity), threadFactory);
            pool.allowCoreThreadTimeOut(true);
            executor = pool;
        } else {
            throw new IllegalArgumentException("Unknown executor type: " + (Object)((Object)type));
        }
        return executor;
    }

    @Override
    public ManagedExecutorService getExecutor(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.executors, name, this.constructor);
    }

    @Override
    public <V> ICompletableFuture<V> asCompletableFuture(Future<V> future) {
        if (future == null) {
            throw new IllegalArgumentException("future must not be null");
        }
        if (future instanceof ICompletableFuture) {
            return (ICompletableFuture)future;
        }
        return this.registerCompletableFuture(future);
    }

    @Override
    public void execute(String name, Runnable command) {
        this.getExecutor(name).execute(command);
    }

    @Override
    public Future<?> submit(String name, Runnable task) {
        return this.getExecutor(name).submit(task);
    }

    @Override
    public <T> Future<T> submit(String name, Callable<T> task) {
        return this.getExecutor(name).submit(task);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.defaultScheduledExecutorServiceDelegate.schedule(command, delay, unit);
    }

    @Override
    public ScheduledFuture<?> schedule(String name, Runnable command, long delay, TimeUnit unit) {
        return this.getScheduledExecutor(name).schedule(command, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.defaultScheduledExecutorServiceDelegate.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(String name, Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.getScheduledExecutor(name).scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.defaultScheduledExecutorServiceDelegate.scheduleWithFixedDelay(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(String name, Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.getScheduledExecutor(name).scheduleWithFixedDelay(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledExecutorService getDefaultScheduledExecutor() {
        return this.defaultScheduledExecutorServiceDelegate;
    }

    @Override
    public ScheduledExecutorService getScheduledExecutor(String name) {
        return new ScheduledExecutorServiceDelegate(this.scheduledExecutorService, this.getExecutor(name));
    }

    public void shutdown() {
        this.logger.finest("Stopping executors...");
        for (ExecutorService executorService : this.executors.values()) {
            executorService.shutdown();
        }
        this.scheduledExecutorService.shutdownNow();
        this.cachedExecutorService.shutdown();
        try {
            this.scheduledExecutorService.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.finest(e);
        }
        try {
            this.cachedExecutorService.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.finest(e);
        }
        this.executors.clear();
    }

    @Override
    public void shutdownExecutor(String name) {
        ExecutorService ex = (ExecutorService)this.executors.remove(name);
        if (ex != null) {
            ex.shutdown();
        }
    }

    private <V> ICompletableFuture<V> registerCompletableFuture(Future<V> future) {
        CompletableFutureEntry<V> entry = new CompletableFutureEntry<V>(future, this.nodeEngine);
        this.completableFutureTask.registerCompletableFutureEntry(entry);
        return entry.completableFuture;
    }
}

