/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.devtools.build.lib.skyframe.serialization.CodecScanner;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodecRegistry;
import java.io.IOException;
import java.util.Comparator;

public class AutoRegistry {
    private static final Supplier<ObjectCodecRegistry> SUPPLIER = Suppliers.memoize(AutoRegistry::create);
    private static final String PACKAGE_PREFIX = "com.google.devtools";
    private static final ImmutableList<String> CLASS_NAME_PREFIX_BLACKLIST = ImmutableList.of((Object)"com.google.devtools.build.lib.vfs", (Object)"com.google.devtools.build.lib.actions.ArtifactFactory");
    private static final ImmutableList<String> EXTERNAL_CLASS_NAMES_TO_REGISTER = ImmutableList.of((Object)"java.io.FileNotFoundException", (Object)"java.io.IOException", (Object)"java.lang.invoke.SerializedLambda", (Object)"com.google.common.base.Predicates$InPredicate", (Object)"com.google.common.collect.ImmutableList$Builder");
    private static final ImmutableList<Object> REFERENCE_CONSTANTS_TO_REGISTER = ImmutableList.of((Object)Predicates.alwaysTrue(), (Object)Predicates.alwaysFalse(), (Object)Predicates.isNull(), (Object)Predicates.notNull(), (Object)ImmutableList.of(), (Object)ImmutableSet.of(), Comparator.naturalOrder(), (Object)Ordering.natural());

    public static ObjectCodecRegistry get() {
        return (ObjectCodecRegistry)SUPPLIER.get();
    }

    private static ObjectCodecRegistry create() {
        try {
            ObjectCodecRegistry.Builder registry = CodecScanner.initializeCodecRegistry(PACKAGE_PREFIX);
            for (String className : EXTERNAL_CLASS_NAMES_TO_REGISTER) {
                registry.addClassName(className);
            }
            for (Object constant : REFERENCE_CONSTANTS_TO_REGISTER) {
                registry.addReferenceConstant(constant);
            }
            for (String classNamePrefix : CLASS_NAME_PREFIX_BLACKLIST) {
                registry.blacklistClassNamePrefix(classNamePrefix);
            }
            return registry.build();
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }
}

