/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.turbine.binder.Resolve;
import com.google.turbine.binder.bound.HeaderBoundClass;
import com.google.turbine.binder.bound.PackageSourceBoundClass;
import com.google.turbine.binder.bound.SourceHeaderBoundClass;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.LazyEnv;
import com.google.turbine.binder.lookup.LookupKey;
import com.google.turbine.binder.lookup.LookupResult;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.model.TurbineTyKind;
import com.google.turbine.tree.Tree;
import java.util.ArrayDeque;

public class HierarchyBinder {
    private final ClassSymbol origin;
    private final PackageSourceBoundClass base;
    private final Env<ClassSymbol, ? extends HeaderBoundClass> env;

    public static SourceHeaderBoundClass bind(ClassSymbol origin, PackageSourceBoundClass base, Env<ClassSymbol, ? extends HeaderBoundClass> env) {
        return new HierarchyBinder(origin, base, env).bind();
    }

    private HierarchyBinder(ClassSymbol origin, PackageSourceBoundClass base, Env<ClassSymbol, ? extends HeaderBoundClass> env) {
        this.origin = origin;
        this.base = base;
        this.env = env;
    }

    private SourceHeaderBoundClass bind() {
        ClassSymbol superclass;
        Tree.TyDecl decl = this.base.decl();
        if (decl.xtnds().isPresent()) {
            superclass = this.resolveClass((Tree.ClassTy)decl.xtnds().get());
        } else {
            switch (decl.tykind()) {
                case ENUM: {
                    superclass = ClassSymbol.ENUM;
                    break;
                }
                case INTERFACE: 
                case ANNOTATION: 
                case CLASS: {
                    superclass = !this.origin.equals(ClassSymbol.OBJECT) ? ClassSymbol.OBJECT : null;
                    break;
                }
                default: {
                    throw new AssertionError((Object)decl.tykind());
                }
            }
        }
        ImmutableList.Builder interfaces = ImmutableList.builder();
        if (!decl.impls().isEmpty()) {
            for (Tree.ClassTy i : decl.impls()) {
                ClassSymbol result = this.resolveClass(i);
                if (result == null) {
                    throw new AssertionError(i);
                }
                interfaces.add((Object)result);
            }
        } else if (decl.tykind() == TurbineTyKind.ANNOTATION) {
            interfaces.add((Object)ClassSymbol.ANNOTATION);
        }
        ImmutableMap.Builder typeParameters = ImmutableMap.builder();
        for (Tree.TyParam p : decl.typarams()) {
            typeParameters.put((Object)p.name(), (Object)new TyVarSymbol(this.origin, p.name()));
        }
        return new SourceHeaderBoundClass(this.base, superclass, (ImmutableList<ClassSymbol>)interfaces.build(), (ImmutableMap<String, TyVarSymbol>)typeParameters.build());
    }

    private ClassSymbol resolveClass(Tree.ClassTy ty) {
        ArrayDeque<String> flat = new ArrayDeque<String>();
        Tree.ClassTy curr = ty;
        while (curr != null) {
            flat.addFirst(curr.name());
            curr = (Tree.ClassTy)curr.base().orNull();
        }
        LookupResult result = this.lookup(ty, new LookupKey(flat));
        if (result == null) {
            throw TurbineError.format(this.base.source(), ty.position(), TurbineError.ErrorKind.CANNOT_RESOLVE, ty);
        }
        ClassSymbol sym = (ClassSymbol)result.sym();
        for (String bit : result.remaining()) {
            sym = this.resolveNext(ty, sym, bit);
        }
        return sym;
    }

    private ClassSymbol resolveNext(Tree.ClassTy ty, ClassSymbol sym, String bit) {
        ClassSymbol next;
        try {
            next = Resolve.resolve(this.env, this.origin, sym, bit);
        }
        catch (LazyEnv.LazyBindingError e) {
            throw this.error(ty.position(), TurbineError.ErrorKind.CYCLIC_HIERARCHY, e.getMessage());
        }
        if (next == null) {
            throw this.error(ty.position(), TurbineError.ErrorKind.SYMBOL_NOT_FOUND, new ClassSymbol(sym.binaryName() + '$' + bit));
        }
        return next;
    }

    private LookupResult lookup(Tree tree, LookupKey lookup) {
        ClassSymbol curr = this.base.owner();
        while (curr != null) {
            ClassSymbol result;
            try {
                result = Resolve.resolve(this.env, this.origin, curr, lookup.first());
            }
            catch (LazyEnv.LazyBindingError e) {
                throw this.error(tree.position(), TurbineError.ErrorKind.CYCLIC_HIERARCHY, e.getMessage());
            }
            if (result != null) {
                return new LookupResult(result, lookup);
            }
            curr = this.env.get(curr).owner();
        }
        return this.base.scope().lookup(lookup, Resolve.resolveFunction(this.env, this.origin));
    }

    private TurbineError error(int position, TurbineError.ErrorKind kind, Object ... args) {
        return TurbineError.format(this.base.source(), position, kind, args);
    }
}

