/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.ReferenceType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.dataflow.cfg.UnderlyingAST;
import org.checkerframework.dataflow.cfg.block.Block;
import org.checkerframework.dataflow.cfg.block.BlockImpl;
import org.checkerframework.dataflow.cfg.block.ConditionalBlockImpl;
import org.checkerframework.dataflow.cfg.block.ExceptionBlockImpl;
import org.checkerframework.dataflow.cfg.block.RegularBlockImpl;
import org.checkerframework.dataflow.cfg.block.SingleSuccessorBlockImpl;
import org.checkerframework.dataflow.cfg.block.SpecialBlock;
import org.checkerframework.dataflow.cfg.block.SpecialBlockImpl;
import org.checkerframework.dataflow.cfg.node.ArrayAccessNode;
import org.checkerframework.dataflow.cfg.node.ArrayCreationNode;
import org.checkerframework.dataflow.cfg.node.ArrayTypeNode;
import org.checkerframework.dataflow.cfg.node.AssertionErrorNode;
import org.checkerframework.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.dataflow.cfg.node.BinaryOperationNode;
import org.checkerframework.dataflow.cfg.node.BitwiseAndNode;
import org.checkerframework.dataflow.cfg.node.BitwiseComplementNode;
import org.checkerframework.dataflow.cfg.node.BitwiseOrNode;
import org.checkerframework.dataflow.cfg.node.BitwiseXorNode;
import org.checkerframework.dataflow.cfg.node.BooleanLiteralNode;
import org.checkerframework.dataflow.cfg.node.CaseNode;
import org.checkerframework.dataflow.cfg.node.CharacterLiteralNode;
import org.checkerframework.dataflow.cfg.node.ClassNameNode;
import org.checkerframework.dataflow.cfg.node.ConditionalAndNode;
import org.checkerframework.dataflow.cfg.node.ConditionalNotNode;
import org.checkerframework.dataflow.cfg.node.ConditionalOrNode;
import org.checkerframework.dataflow.cfg.node.DoubleLiteralNode;
import org.checkerframework.dataflow.cfg.node.EqualToNode;
import org.checkerframework.dataflow.cfg.node.ExplicitThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.FloatLiteralNode;
import org.checkerframework.dataflow.cfg.node.FloatingDivisionNode;
import org.checkerframework.dataflow.cfg.node.FloatingRemainderNode;
import org.checkerframework.dataflow.cfg.node.FunctionalInterfaceNode;
import org.checkerframework.dataflow.cfg.node.GreaterThanNode;
import org.checkerframework.dataflow.cfg.node.GreaterThanOrEqualNode;
import org.checkerframework.dataflow.cfg.node.ImplicitThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.InstanceOfNode;
import org.checkerframework.dataflow.cfg.node.IntegerDivisionNode;
import org.checkerframework.dataflow.cfg.node.IntegerLiteralNode;
import org.checkerframework.dataflow.cfg.node.IntegerRemainderNode;
import org.checkerframework.dataflow.cfg.node.LambdaResultExpressionNode;
import org.checkerframework.dataflow.cfg.node.LeftShiftNode;
import org.checkerframework.dataflow.cfg.node.LessThanNode;
import org.checkerframework.dataflow.cfg.node.LessThanOrEqualNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.LongLiteralNode;
import org.checkerframework.dataflow.cfg.node.MarkerNode;
import org.checkerframework.dataflow.cfg.node.MethodAccessNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.NarrowingConversionNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NotEqualNode;
import org.checkerframework.dataflow.cfg.node.NullChkNode;
import org.checkerframework.dataflow.cfg.node.NullLiteralNode;
import org.checkerframework.dataflow.cfg.node.NumericalAdditionNode;
import org.checkerframework.dataflow.cfg.node.NumericalMinusNode;
import org.checkerframework.dataflow.cfg.node.NumericalMultiplicationNode;
import org.checkerframework.dataflow.cfg.node.NumericalPlusNode;
import org.checkerframework.dataflow.cfg.node.NumericalSubtractionNode;
import org.checkerframework.dataflow.cfg.node.ObjectCreationNode;
import org.checkerframework.dataflow.cfg.node.PackageNameNode;
import org.checkerframework.dataflow.cfg.node.ParameterizedTypeNode;
import org.checkerframework.dataflow.cfg.node.PrimitiveTypeNode;
import org.checkerframework.dataflow.cfg.node.ReturnNode;
import org.checkerframework.dataflow.cfg.node.SignedRightShiftNode;
import org.checkerframework.dataflow.cfg.node.StringConcatenateAssignmentNode;
import org.checkerframework.dataflow.cfg.node.StringConcatenateNode;
import org.checkerframework.dataflow.cfg.node.StringConversionNode;
import org.checkerframework.dataflow.cfg.node.StringLiteralNode;
import org.checkerframework.dataflow.cfg.node.SuperNode;
import org.checkerframework.dataflow.cfg.node.SynchronizedNode;
import org.checkerframework.dataflow.cfg.node.TernaryExpressionNode;
import org.checkerframework.dataflow.cfg.node.ThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.ThrowNode;
import org.checkerframework.dataflow.cfg.node.TypeCastNode;
import org.checkerframework.dataflow.cfg.node.UnsignedRightShiftNode;
import org.checkerframework.dataflow.cfg.node.ValueLiteralNode;
import org.checkerframework.dataflow.cfg.node.VariableDeclarationNode;
import org.checkerframework.dataflow.cfg.node.WideningConversionNode;
import org.checkerframework.dataflow.qual.TerminatesExecution;
import org.checkerframework.dataflow.util.IdentityMostlySingleton;
import org.checkerframework.dataflow.util.MostlySingleton;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.BasicAnnotationProvider;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;
import org.checkerframework.javacutil.trees.TreeBuilder;

public class CFGBuilder {
    protected final boolean assumeAssertionsDisabled;
    protected final boolean assumeAssertionsEnabled;
    protected final List<ClassTree> declaredClasses = new ArrayList<ClassTree>();
    protected final List<LambdaExpressionTree> declaredLambdas = new ArrayList<LambdaExpressionTree>();
    protected final Label exceptionalExitLabel = new Label();
    protected final Label regularExitLabel = new Label();

    public CFGBuilder(boolean assumeAssertionsEnabled, boolean assumeAssertionsDisabled) {
        assert (!assumeAssertionsDisabled || !assumeAssertionsEnabled);
        this.assumeAssertionsEnabled = assumeAssertionsEnabled;
        this.assumeAssertionsDisabled = assumeAssertionsDisabled;
    }

    public List<ClassTree> getDeclaredClasses() {
        return this.declaredClasses;
    }

    public List<LambdaExpressionTree> getDeclaredLambdas() {
        return this.declaredLambdas;
    }

    public static ControlFlowGraph build(CompilationUnitTree root, ProcessingEnvironment env, UnderlyingAST underlyingAST, boolean assumeAssertionsEnabled, boolean assumeAssertionsDisabled) {
        return new CFGBuilder(assumeAssertionsEnabled, assumeAssertionsDisabled).run(root, env, underlyingAST);
    }

    public static ControlFlowGraph build(TreePath bodyPath, ProcessingEnvironment env, UnderlyingAST underlyingAST, boolean assumeAssertionsEnabled, boolean assumeAssertionsDisabled) {
        return new CFGBuilder(assumeAssertionsEnabled, assumeAssertionsDisabled).run(bodyPath, env, underlyingAST);
    }

    public static ControlFlowGraph build(CompilationUnitTree root, ProcessingEnvironment env, MethodTree tree, ClassTree classTree, boolean assumeAssertionsEnabled, boolean assumeAssertionsDisabled) {
        return new CFGBuilder(assumeAssertionsEnabled, assumeAssertionsDisabled).run(root, env, tree, classTree);
    }

    public static ControlFlowGraph build(CompilationUnitTree root, ProcessingEnvironment env, UnderlyingAST underlyingAST) {
        return new CFGBuilder(false, false).run(root, env, underlyingAST);
    }

    public static ControlFlowGraph build(CompilationUnitTree root, ProcessingEnvironment env, MethodTree tree, ClassTree classTree) {
        return new CFGBuilder(false, false).run(root, env, tree, classTree);
    }

    public ControlFlowGraph run(CompilationUnitTree root, ProcessingEnvironment env, UnderlyingAST underlyingAST) {
        this.declaredClasses.clear();
        this.declaredLambdas.clear();
        TreeBuilder builder = new TreeBuilder(env);
        BasicAnnotationProvider annotationProvider = new BasicAnnotationProvider();
        PhaseOneResult phase1result = new CFGTranslationPhaseOne().process(root, env, underlyingAST, this.exceptionalExitLabel, builder, (AnnotationProvider)annotationProvider);
        ControlFlowGraph phase2result = new CFGTranslationPhaseTwo().process(phase1result);
        ControlFlowGraph phase3result = CFGTranslationPhaseThree.process(phase2result);
        return phase3result;
    }

    public ControlFlowGraph run(TreePath bodyPath, ProcessingEnvironment env, UnderlyingAST underlyingAST) {
        this.declaredClasses.clear();
        TreeBuilder builder = new TreeBuilder(env);
        BasicAnnotationProvider annotationProvider = new BasicAnnotationProvider();
        PhaseOneResult phase1result = new CFGTranslationPhaseOne().process(bodyPath, env, underlyingAST, this.exceptionalExitLabel, builder, (AnnotationProvider)annotationProvider);
        ControlFlowGraph phase2result = new CFGTranslationPhaseTwo().process(phase1result);
        ControlFlowGraph phase3result = CFGTranslationPhaseThree.process(phase2result);
        return phase3result;
    }

    public ControlFlowGraph run(CompilationUnitTree root, ProcessingEnvironment env, MethodTree tree, ClassTree classTree) {
        UnderlyingAST.CFGMethod underlyingAST = new UnderlyingAST.CFGMethod(tree, classTree);
        return this.run(root, env, (UnderlyingAST)underlyingAST);
    }

    private static <A> A firstNonNull(A first, A second) {
        if (first != null) {
            return first;
        }
        if (second != null) {
            return second;
        }
        throw new NullPointerException();
    }

    protected static void printBlocks(Set<Block> blocks) {
        for (Block b : blocks) {
            System.out.print(b.hashCode() + ": " + b);
            switch (b.getType()) {
                case SPECIAL_BLOCK: 
                case REGULAR_BLOCK: {
                    Block succ = ((SingleSuccessorBlockImpl)b).getSuccessor();
                    System.out.println(" -> " + (succ != null ? Integer.valueOf(succ.hashCode()) : "||"));
                    break;
                }
                case EXCEPTION_BLOCK: {
                    Block succ = ((SingleSuccessorBlockImpl)b).getSuccessor();
                    System.out.print(" -> " + (succ != null ? Integer.valueOf(succ.hashCode()) : "||") + " {");
                    for (Map.Entry<TypeMirror, Set<Block>> entry : ((ExceptionBlockImpl)b).getExceptionalSuccessors().entrySet()) {
                        System.out.print(entry.getKey() + " : " + entry.getValue() + ", ");
                    }
                    System.out.println("}");
                    break;
                }
                case CONDITIONAL_BLOCK: {
                    Block tSucc = ((ConditionalBlockImpl)b).getThenSuccessor();
                    Block eSucc = ((ConditionalBlockImpl)b).getElseSuccessor();
                    System.out.println(" -> T " + (tSucc != null ? Integer.valueOf(tSucc.hashCode()) : "||") + " F " + (eSucc != null ? Integer.valueOf(eSucc.hashCode()) : "||"));
                    break;
                }
            }
        }
    }

    private static interface TreeInfo {
        public boolean isBoxed();

        public boolean isNumeric();

        public boolean isBoolean();

        public TypeMirror unboxedType();
    }

    public class CFGTranslationPhaseOne
    extends TreePathScanner<Node, Void> {
        protected ProcessingEnvironment env;
        protected Elements elements;
        protected Types types;
        protected Trees trees;
        protected TreeBuilder treeBuilder;
        protected AnnotationProvider annotationProvider;
        protected @Nullable TryFinallyScopeCell returnTargetL;
        protected @Nullable TryFinallyScopeCell breakTargetL;
        protected Map<Name, Label> breakLabels;
        protected @Nullable TryFinallyScopeCell continueTargetL;
        protected Map<Name, Label> continueLabels;
        protected IdentityHashMap<Tree, Set<Node>> treeLookupMap;
        protected IdentityHashMap<Tree, Set<Node>> convertedTreeLookupMap;
        protected IdentityHashMap<UnaryTree, AssignmentNode> unaryAssignNodeLookupMap;
        protected ArrayList<ExtendedNode> nodeList;
        protected Map<Label, Integer> bindings;
        protected Set<Integer> leaders;
        private List<ReturnNode> returnNodes;
        private TryStack tryStack;
        protected long uid = 0L;
        protected VariableTree ea = null;
        private final Map<Tree, ParenthesizedTree> parenMapping = new HashMap<Tree, ParenthesizedTree>();

        public PhaseOneResult process(TreePath bodyPath, ProcessingEnvironment env, UnderlyingAST underlyingAST, Label exceptionalExitLabel, TreeBuilder treeBuilder, AnnotationProvider annotationProvider) {
            LambdaExpressionTree lambdaTree;
            this.env = env;
            this.treeBuilder = treeBuilder;
            this.annotationProvider = annotationProvider;
            this.elements = env.getElementUtils();
            this.types = env.getTypeUtils();
            if (this.trees == null) {
                this.trees = Trees.instance(env);
            }
            this.treeLookupMap = new IdentityHashMap();
            this.convertedTreeLookupMap = new IdentityHashMap();
            this.unaryAssignNodeLookupMap = new IdentityHashMap();
            this.nodeList = new ArrayList();
            this.bindings = new HashMap<Label, Integer>();
            this.leaders = new HashSet<Integer>();
            this.tryStack = new TryStack(exceptionalExitLabel);
            this.returnTargetL = new TryFinallyScopeCell(CFGBuilder.this.regularExitLabel);
            this.breakLabels = new HashMap<Name, Label>();
            this.continueLabels = new HashMap<Name, Label>();
            this.returnNodes = new ArrayList<ReturnNode>();
            Node finalNode = (Node)this.scan(bodyPath, null);
            if (underlyingAST.getKind() == UnderlyingAST.Kind.LAMBDA && (lambdaTree = ((UnderlyingAST.CFGLambda)underlyingAST).getLambdaTree()).getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                LambdaResultExpressionNode resultNode = new LambdaResultExpressionNode((ExpressionTree)lambdaTree.getBody(), finalNode, env.getTypeUtils());
                this.extendWithNode(resultNode);
            }
            this.nodeList.add(new UnconditionalJump(CFGBuilder.this.regularExitLabel));
            return new PhaseOneResult(underlyingAST, this.treeLookupMap, this.convertedTreeLookupMap, this.unaryAssignNodeLookupMap, this.nodeList, this.bindings, this.leaders, this.returnNodes);
        }

        public PhaseOneResult process(CompilationUnitTree root, ProcessingEnvironment env, UnderlyingAST underlyingAST, Label exceptionalExitLabel, TreeBuilder treeBuilder, AnnotationProvider annotationProvider) {
            this.trees = Trees.instance(env);
            TreePath bodyPath = this.trees.getPath(root, underlyingAST.getCode());
            assert (bodyPath != null);
            return this.process(bodyPath, env, underlyingAST, exceptionalExitLabel, treeBuilder, annotationProvider);
        }

        public void handleArtificialTree(Tree tree) {
        }

        protected void addToLookupMap(Node node) {
            Tree tree = node.getTree();
            if (tree == null) {
                return;
            }
            Set<Node> existing = this.treeLookupMap.get(tree);
            if (existing == null) {
                this.treeLookupMap.put(tree, new IdentityMostlySingleton<Node>(node));
            } else if (!existing.contains(node)) {
                existing.add(node);
            }
            Tree enclosingParens = this.parenMapping.get(tree);
            while (enclosingParens != null) {
                Set<Node> exp = this.treeLookupMap.get(enclosingParens);
                if (exp == null) {
                    this.treeLookupMap.put(enclosingParens, new IdentityMostlySingleton<Node>(node));
                } else if (!exp.contains(node)) {
                    exp.add(node);
                }
                enclosingParens = this.parenMapping.get(enclosingParens);
            }
        }

        protected void addToConvertedLookupMap(Node node) {
            Tree tree = node.getTree();
            this.addToConvertedLookupMap(tree, node);
        }

        protected void addToConvertedLookupMap(Tree tree, Node node) {
            assert (tree != null);
            assert (this.treeLookupMap.containsKey(tree));
            Set<Node> existing = this.convertedTreeLookupMap.get(tree);
            if (existing == null) {
                this.convertedTreeLookupMap.put(tree, new IdentityMostlySingleton<Node>(node));
            } else if (!existing.contains(node)) {
                existing.add(node);
            }
        }

        protected void addToUnaryAssignLookupMap(UnaryTree tree, AssignmentNode unaryAssignNode) {
            this.unaryAssignNodeLookupMap.put(tree, unaryAssignNode);
        }

        protected <T extends Node> T extendWithNode(T node) {
            this.addToLookupMap(node);
            this.extendWithExtendedNode(new NodeHolder(node));
            return node;
        }

        protected NodeWithExceptionsHolder extendWithNodeWithException(Node node, TypeMirror cause) {
            this.addToLookupMap(node);
            return this.extendWithNodeWithExceptions(node, Collections.singleton(cause));
        }

        protected NodeWithExceptionsHolder extendWithNodeWithExceptions(Node node, Set<TypeMirror> causes) {
            this.addToLookupMap(node);
            HashMap<TypeMirror, Set<Label>> exceptions = new HashMap<TypeMirror, Set<Label>>();
            for (TypeMirror cause : causes) {
                exceptions.put(cause, this.tryStack.possibleLabels(cause));
            }
            NodeWithExceptionsHolder exNode = new NodeWithExceptionsHolder(node, exceptions);
            this.extendWithExtendedNode(exNode);
            return exNode;
        }

        protected <T extends Node> T insertNodeAfter(T node, Node pred) {
            this.addToLookupMap(node);
            this.insertExtendedNodeAfter(new NodeHolder(node), pred);
            return node;
        }

        protected NodeWithExceptionsHolder insertNodeWithExceptionsAfter(Node node, Set<TypeMirror> causes, Node pred) {
            this.addToLookupMap(node);
            HashMap<TypeMirror, Set<Label>> exceptions = new HashMap<TypeMirror, Set<Label>>();
            for (TypeMirror cause : causes) {
                exceptions.put(cause, this.tryStack.possibleLabels(cause));
            }
            NodeWithExceptionsHolder exNode = new NodeWithExceptionsHolder(node, exceptions);
            this.insertExtendedNodeAfter(exNode, pred);
            return exNode;
        }

        protected void extendWithExtendedNode(ExtendedNode n) {
            this.nodeList.add(n);
        }

        protected void insertExtendedNodeAfter(ExtendedNode n, Node pred) {
            int index = -1;
            for (int i = 0; i < this.nodeList.size(); ++i) {
                ExtendedNode inList = this.nodeList.get(i);
                if (!(inList instanceof NodeHolder) && !(inList instanceof NodeWithExceptionsHolder) || inList.getNode() != pred) continue;
                index = i;
                break;
            }
            if (index != -1) {
                this.nodeList.add(index + 1, n);
                for (Map.Entry<Label, Integer> e : this.bindings.entrySet()) {
                    if (e.getValue() < index + 1) continue;
                    this.bindings.put(e.getKey(), e.getValue() + 1);
                }
                HashSet<Integer> newLeaders = new HashSet<Integer>();
                for (Integer l : this.leaders) {
                    if (l >= index + 1) {
                        newLeaders.add(l + 1);
                        continue;
                    }
                    newLeaders.add(l);
                }
                this.leaders = newLeaders;
            } else {
                this.nodeList.add(n);
            }
        }

        protected void addLabelForNextNode(Label l) {
            assert (!this.bindings.containsKey(l));
            this.leaders.add(this.nodeList.size());
            this.bindings.put(l, this.nodeList.size());
        }

        protected String uniqueName(String prefix) {
            return prefix + "#num" + this.uid++;
        }

        protected Node box(Node node) {
            if (TypesUtils.isPrimitive((TypeMirror)node.getType())) {
                PrimitiveType primitive = this.types.getPrimitiveType(node.getType().getKind());
                DeclaredType boxedType = this.types.getDeclaredType(this.types.boxedClass(primitive), new TypeMirror[0]);
                TypeElement boxedElement = (TypeElement)boxedType.asElement();
                IdentifierTree classTree = this.treeBuilder.buildClassUse((Element)boxedElement);
                this.handleArtificialTree(classTree);
                ClassNameNode className = new ClassNameNode(classTree);
                className.setInSource(false);
                this.insertNodeAfter(className, node);
                MemberSelectTree valueOfSelect = this.treeBuilder.buildValueOfMethodAccess((Tree)classTree);
                this.handleArtificialTree(valueOfSelect);
                MethodAccessNode valueOfAccess = new MethodAccessNode(valueOfSelect, className);
                valueOfAccess.setInSource(false);
                this.insertNodeAfter(valueOfAccess, className);
                MethodInvocationTree valueOfCall = this.treeBuilder.buildMethodInvocation((ExpressionTree)valueOfSelect, (ExpressionTree)node.getTree());
                this.handleArtificialTree(valueOfCall);
                MethodInvocationNode boxed = new MethodInvocationNode(valueOfCall, valueOfAccess, Collections.singletonList(node), this.getCurrentPath());
                boxed.setInSource(false);
                TypeElement throwableElement = this.elements.getTypeElement("java.lang.Throwable");
                this.addToConvertedLookupMap(node.getTree(), boxed);
                this.insertNodeWithExceptionsAfter(boxed, Collections.singleton(throwableElement.asType()), valueOfAccess);
                return boxed;
            }
            return node;
        }

        protected Node unbox(Node node) {
            if (TypesUtils.isBoxedPrimitive((TypeMirror)node.getType())) {
                MemberSelectTree primValueSelect = this.treeBuilder.buildPrimValueMethodAccess(node.getTree());
                this.handleArtificialTree(primValueSelect);
                MethodAccessNode primValueAccess = new MethodAccessNode(primValueSelect, node);
                primValueAccess.setInSource(false);
                TypeElement npeElement = this.elements.getTypeElement("java.lang.NullPointerException");
                this.insertNodeWithExceptionsAfter(primValueAccess, Collections.singleton(npeElement.asType()), node);
                MethodInvocationTree primValueCall = this.treeBuilder.buildMethodInvocation((ExpressionTree)primValueSelect);
                this.handleArtificialTree(primValueCall);
                MethodInvocationNode unboxed = new MethodInvocationNode(primValueCall, primValueAccess, Collections.emptyList(), this.getCurrentPath());
                unboxed.setInSource(false);
                TypeElement throwableElement = this.elements.getTypeElement("java.lang.Throwable");
                this.addToConvertedLookupMap(node.getTree(), unboxed);
                this.insertNodeWithExceptionsAfter(unboxed, Collections.singleton(throwableElement.asType()), primValueAccess);
                return unboxed;
            }
            return node;
        }

        private TreeInfo getTreeInfo(Tree tree) {
            TypeMirror type = TreeUtils.typeOf((Tree)tree);
            final boolean boxed = TypesUtils.isBoxedPrimitive((TypeMirror)type);
            final TypeMirror unboxedType = boxed ? this.types.unboxedType(type) : type;
            final boolean bool = TypesUtils.isBooleanType((TypeMirror)type);
            final boolean numeric = TypesUtils.isNumeric((TypeMirror)unboxedType);
            return new TreeInfo(){

                @Override
                public boolean isNumeric() {
                    return numeric;
                }

                @Override
                public boolean isBoxed() {
                    return boxed;
                }

                @Override
                public boolean isBoolean() {
                    return bool;
                }

                @Override
                public TypeMirror unboxedType() {
                    return unboxedType;
                }
            };
        }

        private Node unboxAsNeeded(Node node, boolean boxed) {
            return boxed ? this.unbox(node) : node;
        }

        protected Node stringConversion(Node node) {
            TypeElement stringElement = this.elements.getTypeElement("java.lang.String");
            if (!TypesUtils.isString((TypeMirror)node.getType())) {
                StringConversionNode converted = new StringConversionNode(node.getTree(), node, stringElement.asType());
                this.addToConvertedLookupMap(converted);
                this.insertNodeAfter(converted, node);
                return converted;
            }
            return node;
        }

        protected Node unaryNumericPromotion(Node node) {
            node = this.unbox(node);
            switch (node.getType().getKind()) {
                case BYTE: 
                case CHAR: 
                case SHORT: {
                    PrimitiveType intType = this.types.getPrimitiveType(TypeKind.INT);
                    WideningConversionNode widened = new WideningConversionNode(node.getTree(), node, intType);
                    this.addToConvertedLookupMap(widened);
                    this.insertNodeAfter(widened, node);
                    return widened;
                }
            }
            return node;
        }

        protected boolean isNumericOrBoxed(TypeMirror type) {
            if (TypesUtils.isBoxedPrimitive((TypeMirror)type)) {
                type = this.types.unboxedType(type);
            }
            return TypesUtils.isNumeric((TypeMirror)type);
        }

        protected TypeMirror binaryPromotedType(TypeMirror left, TypeMirror right) {
            if (TypesUtils.isBoxedPrimitive((TypeMirror)left)) {
                left = this.types.unboxedType(left);
            }
            if (TypesUtils.isBoxedPrimitive((TypeMirror)right)) {
                right = this.types.unboxedType(right);
            }
            TypeKind promotedTypeKind = TypesUtils.widenedNumericType((TypeMirror)left, (TypeMirror)right);
            return this.types.getPrimitiveType(promotedTypeKind);
        }

        protected Node binaryNumericPromotion(Node node, TypeMirror exprType) {
            if (!this.types.isSameType((node = this.unbox(node)).getType(), exprType)) {
                WideningConversionNode widened = new WideningConversionNode(node.getTree(), node, exprType);
                this.addToConvertedLookupMap(widened);
                this.insertNodeAfter(widened, node);
                return widened;
            }
            return node;
        }

        protected Node widen(Node node, TypeMirror destType) {
            assert (TypesUtils.isPrimitive((TypeMirror)node.getType()) && TypesUtils.isPrimitive((TypeMirror)destType)) : "widening must be applied to primitive types";
            if (this.types.isSubtype(node.getType(), destType) && !this.types.isSameType(node.getType(), destType)) {
                WideningConversionNode widened = new WideningConversionNode(node.getTree(), node, destType);
                this.addToConvertedLookupMap(widened);
                this.insertNodeAfter(widened, node);
                return widened;
            }
            return node;
        }

        protected Node narrow(Node node, TypeMirror destType) {
            assert (TypesUtils.isPrimitive((TypeMirror)node.getType()) && TypesUtils.isPrimitive((TypeMirror)destType)) : "narrowing must be applied to primitive types";
            if (this.types.isSubtype(destType, node.getType()) && !this.types.isSameType(destType, node.getType())) {
                NarrowingConversionNode narrowed = new NarrowingConversionNode(node.getTree(), node, destType);
                this.addToConvertedLookupMap(narrowed);
                this.insertNodeAfter(narrowed, node);
                return narrowed;
            }
            return node;
        }

        protected Node narrowAndBox(Node node, TypeMirror destType) {
            if (TypesUtils.isBoxedPrimitive((TypeMirror)destType)) {
                return this.box(this.narrow(node, this.types.unboxedType(destType)));
            }
            return this.narrow(node, destType);
        }

        protected boolean conversionRequiresNarrowing(TypeMirror varType, Node node) {
            TypeMirror unboxedVarType = TypesUtils.isBoxedPrimitive((TypeMirror)varType) ? this.types.unboxedType(varType) : varType;
            TypeKind unboxedVarKind = unboxedVarType.getKind();
            boolean isLeftNarrowableTo = unboxedVarKind == TypeKind.BYTE || unboxedVarKind == TypeKind.SHORT || unboxedVarKind == TypeKind.CHAR;
            boolean isRightConstant = node instanceof ValueLiteralNode;
            return isLeftNarrowableTo && isRightConstant;
        }

        protected Node commonConvert(Node node, TypeMirror varType, boolean contextAllowsNarrowing) {
            TypeMirror nodeType = node.getType();
            boolean isSameType = this.types.isSameType(nodeType, varType);
            if (isSameType) {
                return node;
            }
            boolean isRightNumeric = TypesUtils.isNumeric((TypeMirror)nodeType);
            boolean isRightPrimitive = TypesUtils.isPrimitive((TypeMirror)nodeType);
            boolean isRightBoxed = TypesUtils.isBoxedPrimitive((TypeMirror)nodeType);
            boolean isRightReference = nodeType instanceof ReferenceType;
            boolean isLeftNumeric = TypesUtils.isNumeric((TypeMirror)varType);
            boolean isLeftPrimitive = TypesUtils.isPrimitive((TypeMirror)varType);
            boolean isLeftReference = varType instanceof ReferenceType;
            boolean isSubtype = this.types.isSubtype(nodeType, varType);
            if (isRightNumeric && isLeftNumeric && isSubtype) {
                node = this.widen(node, varType);
                nodeType = node.getType();
            } else if (!(isRightReference && isLeftReference && isSubtype)) {
                if (isRightPrimitive && isLeftReference) {
                    if (contextAllowsNarrowing && this.conversionRequiresNarrowing(varType, node)) {
                        node = this.narrowAndBox(node, varType);
                        nodeType = node.getType();
                    } else {
                        node = this.box(node);
                        nodeType = node.getType();
                    }
                } else if (isRightBoxed && isLeftPrimitive) {
                    nodeType = (node = this.unbox(node)).getType();
                    if (this.types.isSubtype(nodeType, varType) && !this.types.isSameType(nodeType, varType)) {
                        node = this.widen(node, varType);
                        nodeType = node.getType();
                    }
                } else if (isRightPrimitive && isLeftPrimitive && contextAllowsNarrowing && this.conversionRequiresNarrowing(varType, node)) {
                    node = this.narrow(node, varType);
                    nodeType = node.getType();
                }
            }
            return node;
        }

        protected Node assignConvert(Node node, TypeMirror varType) {
            return this.commonConvert(node, varType, true);
        }

        protected Node methodInvocationConvert(Node node, TypeMirror formalType) {
            return this.commonConvert(node, formalType, false);
        }

        protected List<Node> convertCallArguments(ExecutableElement method, List<? extends ExpressionTree> actualExprs) {
            List<? extends VariableElement> formals = method.getParameters();
            ArrayList<Node> convertedNodes = new ArrayList<Node>();
            int numFormals = formals.size();
            int numActuals = actualExprs.size();
            if (method.isVarArgs()) {
                int lastArgIndex = numFormals - 1;
                TypeMirror lastParamType = formals.get(lastArgIndex).asType();
                ArrayList<Node> dimensions = new ArrayList<Node>();
                ArrayList<Node> initializers = new ArrayList<Node>();
                if (numActuals == numFormals && this.types.isAssignable(TreeUtils.typeOf((Tree)actualExprs.get(numActuals - 1)), lastParamType)) {
                    for (int i = 0; i < numActuals; ++i) {
                        Node actualVal = (Node)this.scan(actualExprs.get(i), null);
                        convertedNodes.add(this.methodInvocationConvert(actualVal, formals.get(i).asType()));
                    }
                } else {
                    assert (lastParamType instanceof ArrayType) : "variable argument formal must be an array";
                    for (int i = 0; i < lastArgIndex; ++i) {
                        Node actualVal = (Node)this.scan(actualExprs.get(i), null);
                        convertedNodes.add(this.methodInvocationConvert(actualVal, formals.get(i).asType()));
                    }
                    ArrayList<ExpressionTree> inits = new ArrayList<ExpressionTree>();
                    TypeMirror elemType = ((ArrayType)lastParamType).getComponentType();
                    for (int i = lastArgIndex; i < numActuals; ++i) {
                        inits.add(actualExprs.get(i));
                        Node actualVal = (Node)this.scan(actualExprs.get(i), null);
                        initializers.add(this.assignConvert(actualVal, elemType));
                    }
                    NewArrayTree wrappedVarargs = this.treeBuilder.buildNewArray(elemType, inits);
                    this.handleArtificialTree(wrappedVarargs);
                    ArrayCreationNode lastArgument = new ArrayCreationNode(wrappedVarargs, lastParamType, dimensions, initializers);
                    this.extendWithNode(lastArgument);
                    convertedNodes.add(lastArgument);
                }
            } else {
                for (int i = 0; i < numActuals; ++i) {
                    Node actualVal = (Node)this.scan(actualExprs.get(i), null);
                    convertedNodes.add(this.methodInvocationConvert(actualVal, formals.get(i).asType()));
                }
            }
            return convertedNodes;
        }

        protected Node conditionalExprPromotion(Node node, TypeMirror destType) {
            TypeMirror unboxedDestType;
            TypeMirror nodeType = node.getType();
            if (this.types.isSameType(nodeType, destType)) {
                return node;
            }
            if (TypesUtils.isPrimitive((TypeMirror)nodeType) && TypesUtils.isBoxedPrimitive((TypeMirror)destType)) {
                return this.box(node);
            }
            boolean isBoxedPrimitive = TypesUtils.isBoxedPrimitive((TypeMirror)nodeType);
            TypeMirror unboxedNodeType = isBoxedPrimitive ? this.types.unboxedType(nodeType) : nodeType;
            TypeMirror typeMirror = unboxedDestType = TypesUtils.isBoxedPrimitive((TypeMirror)destType) ? this.types.unboxedType(destType) : destType;
            if (TypesUtils.isNumeric((TypeMirror)unboxedNodeType) && TypesUtils.isNumeric((TypeMirror)unboxedDestType)) {
                if (unboxedNodeType.getKind() == TypeKind.BYTE && destType.getKind() == TypeKind.SHORT) {
                    if (isBoxedPrimitive) {
                        node = this.unbox(node);
                    }
                    return this.widen(node, destType);
                }
                TypeKind destKind = destType.getKind();
                if (destKind == TypeKind.BYTE || destKind == TypeKind.CHAR || destKind == TypeKind.SHORT) {
                    if (isBoxedPrimitive) {
                        return this.unbox(node);
                    }
                    if (nodeType.getKind() == TypeKind.INT) {
                        return this.narrow(node, destType);
                    }
                }
                return this.binaryNumericPromotion(node, destType);
            }
            if (TypesUtils.isPrimitive((TypeMirror)nodeType) && (destType.getKind() == TypeKind.DECLARED || destType.getKind() == TypeKind.UNION || destType.getKind() == TypeKind.INTERSECTION)) {
                return this.box(node);
            }
            return node;
        }

        protected @Nullable Name getLabel(TreePath path) {
            Tree parent;
            if (path.getParentPath() != null && (parent = path.getParentPath().getLeaf()).getKind() == Tree.Kind.LABELED_STATEMENT) {
                return ((LabeledStatementTree)parent).getLabel();
            }
            return null;
        }

        @Override
        public Node visitAnnotatedType(AnnotatedTypeTree tree, Void p) {
            return (Node)this.scan(tree.getUnderlyingType(), p);
        }

        @Override
        public Node visitAnnotation(AnnotationTree tree, Void p) {
            assert (false) : "AnnotationTree is unexpected in AST to CFG translation";
            return null;
        }

        @Override
        public MethodInvocationNode visitMethodInvocation(MethodInvocationTree tree, Void p) {
            boolean terminatesExecution;
            ExecutableElement method = TreeUtils.elementFromUse((MethodInvocationTree)tree);
            if (method == null) {
                return null;
            }
            ExpressionTree methodSelect = tree.getMethodSelect();
            assert (TreeUtils.isMethodAccess((Tree)methodSelect)) : "Expected a method access, but got: " + methodSelect;
            List<? extends ExpressionTree> actualExprs = tree.getArguments();
            Node receiver = this.getReceiver(methodSelect, TreeUtils.enclosingClass((TreePath)this.getCurrentPath()));
            MethodAccessNode target = new MethodAccessNode(methodSelect, receiver);
            ExecutableElement element = TreeUtils.elementFromUse((MethodInvocationTree)tree);
            if (ElementUtils.isStatic((Element)element) || receiver instanceof ThisLiteralNode) {
                this.extendWithNode(target);
            } else {
                TypeElement npeElement = this.elements.getTypeElement("java.lang.NullPointerException");
                this.extendWithNodeWithException(target, npeElement.asType());
            }
            ArrayList<Node> arguments = new ArrayList();
            if (!TreeUtils.isEnumSuper((MethodInvocationTree)tree)) {
                arguments = this.convertCallArguments(method, actualExprs);
            }
            MethodInvocationNode node = new MethodInvocationNode(tree, target, arguments, this.getCurrentPath());
            HashSet<TypeMirror> thrownSet = new HashSet<TypeMirror>();
            List<? extends TypeMirror> thrownTypes = element.getThrownTypes();
            thrownSet.addAll(thrownTypes);
            TypeElement throwableElement = this.elements.getTypeElement("java.lang.Throwable");
            thrownSet.add(throwableElement.asType());
            NodeWithExceptionsHolder extendedNode = this.extendWithNodeWithExceptions(node, thrownSet);
            Element methodElement = TreeUtils.elementFromTree((Tree)tree);
            boolean bl = terminatesExecution = this.annotationProvider.getDeclAnnotation(methodElement, TerminatesExecution.class) != null;
            if (terminatesExecution) {
                extendedNode.setTerminatesExecution(true);
            }
            return node;
        }

        @Override
        public Node visitAssert(AssertTree tree, Void p) {
            if (CFGBuilder.this.assumeAssertionsEnabled || this.assumeAssertionsEnabledFor(tree)) {
                this.translateAssertWithAssertionsEnabled(tree);
                return null;
            }
            if (CFGBuilder.this.assumeAssertionsDisabled) {
                return null;
            }
            VariableTree ea = this.getAssertionsEnabledVariable();
            Label assertionEnabled = new Label();
            Label assertionDisabled = new Label();
            this.extendWithNode(new LocalVariableNode(ea));
            this.extendWithExtendedNode(new ConditionalJump(assertionEnabled, assertionDisabled));
            this.addLabelForNextNode(assertionEnabled);
            this.translateAssertWithAssertionsEnabled(tree);
            this.addLabelForNextNode(assertionDisabled);
            return null;
        }

        protected boolean assumeAssertionsEnabledFor(AssertTree tree) {
            return false;
        }

        protected VariableTree getAssertionsEnabledVariable() {
            if (this.ea == null) {
                String name = this.uniqueName("assertionsEnabled");
                Element owner = this.findOwner();
                ExpressionTree initializer = null;
                this.ea = this.treeBuilder.buildVariableDecl((TypeMirror)this.types.getPrimitiveType(TypeKind.BOOLEAN), name, owner, initializer);
            }
            return this.ea;
        }

        private Element findOwner() {
            MethodTree enclosingMethod = TreeUtils.enclosingMethod((TreePath)this.getCurrentPath());
            if (enclosingMethod != null) {
                return TreeUtils.elementFromDeclaration((MethodTree)enclosingMethod);
            }
            ClassTree enclosingClass = TreeUtils.enclosingClass((TreePath)this.getCurrentPath());
            return TreeUtils.elementFromDeclaration((ClassTree)enclosingClass);
        }

        protected void translateAssertWithAssertionsEnabled(AssertTree tree) {
            Label assertEnd = new Label();
            Label elseEntry = new Label();
            Node condition = this.unbox((Node)this.scan(tree.getCondition(), null));
            ConditionalJump cjump = new ConditionalJump(assertEnd, elseEntry);
            this.extendWithExtendedNode(cjump);
            Node detail = null;
            this.addLabelForNextNode(elseEntry);
            if (tree.getDetail() != null) {
                detail = (Node)this.scan(tree.getDetail(), null);
            }
            TypeElement assertException = this.elements.getTypeElement("java.lang.AssertionError");
            AssertionErrorNode assertNode = new AssertionErrorNode(tree, condition, detail, assertException.asType());
            this.extendWithNode(assertNode);
            NodeWithExceptionsHolder exNode = this.extendWithNodeWithException(new ThrowNode(null, assertNode, this.env.getTypeUtils()), assertException.asType());
            exNode.setTerminatesExecution(true);
            this.addLabelForNextNode(assertEnd);
        }

        @Override
        public Node visitAssignment(AssignmentTree tree, Void p) {
            AssignmentNode assignmentNode;
            ExpressionTree variable = tree.getVariable();
            TypeMirror varType = TreeUtils.typeOf((Tree)variable);
            if (TreeUtils.isFieldAccess((Tree)variable)) {
                Node receiver = this.getReceiver(variable, TreeUtils.enclosingClass((TreePath)this.getCurrentPath()));
                Node expression = (Node)this.scan(tree.getExpression(), p);
                expression = this.assignConvert(expression, varType);
                FieldAccessNode target = new FieldAccessNode(variable, receiver);
                target.setLValue();
                Element element = TreeUtils.elementFromUse((ExpressionTree)variable);
                if (ElementUtils.isStatic((Element)element) || receiver instanceof ThisLiteralNode) {
                    this.extendWithNode(target);
                } else {
                    TypeElement npeElement = this.elements.getTypeElement("java.lang.NullPointerException");
                    this.extendWithNodeWithException(target, npeElement.asType());
                }
                assignmentNode = new AssignmentNode(tree, target, expression);
                this.extendWithNode(assignmentNode);
            } else {
                Node target = (Node)this.scan(variable, p);
                target.setLValue();
                assignmentNode = this.translateAssignment((Tree)tree, target, tree.getExpression());
            }
            return assignmentNode;
        }

        protected AssignmentNode translateAssignment(Tree tree, Node target, ExpressionTree rhs) {
            Node expression = (Node)this.scan(rhs, null);
            return this.translateAssignment(tree, target, expression);
        }

        protected AssignmentNode translateAssignment(Tree tree, Node target, Node expression) {
            assert (tree instanceof AssignmentTree || tree instanceof VariableTree);
            target.setLValue();
            expression = this.assignConvert(expression, target.getType());
            AssignmentNode assignmentNode = new AssignmentNode(tree, target, expression);
            this.extendWithNode(assignmentNode);
            return assignmentNode;
        }

        private Node getReceiver(ExpressionTree tree, ClassTree classTree) {
            assert (TreeUtils.isFieldAccess((Tree)tree) || TreeUtils.isMethodAccess((Tree)tree));
            if (tree.getKind().equals((Object)Tree.Kind.MEMBER_SELECT)) {
                MemberSelectTree mtree = (MemberSelectTree)tree;
                return (Node)this.scan(mtree.getExpression(), null);
            }
            Element ele = TreeUtils.elementFromUse((ExpressionTree)tree);
            TypeElement declaringClass = ElementUtils.enclosingClass((Element)ele);
            TypeMirror type = ElementUtils.getType((Element)declaringClass);
            if (ElementUtils.isStatic((Element)ele)) {
                ClassNameNode node = new ClassNameNode(type, declaringClass);
                this.extendWithNode(node);
                return node;
            }
            ImplicitThisLiteralNode node = new ImplicitThisLiteralNode(type);
            this.extendWithNode(node);
            return node;
        }

        protected Tree.Kind withoutAssignment(Tree.Kind kind) {
            switch (kind) {
                case DIVIDE_ASSIGNMENT: {
                    return Tree.Kind.DIVIDE;
                }
                case MULTIPLY_ASSIGNMENT: {
                    return Tree.Kind.MULTIPLY;
                }
                case REMAINDER_ASSIGNMENT: {
                    return Tree.Kind.REMAINDER;
                }
                case MINUS_ASSIGNMENT: {
                    return Tree.Kind.MINUS;
                }
                case PLUS_ASSIGNMENT: {
                    return Tree.Kind.PLUS;
                }
                case LEFT_SHIFT_ASSIGNMENT: {
                    return Tree.Kind.LEFT_SHIFT;
                }
                case RIGHT_SHIFT_ASSIGNMENT: {
                    return Tree.Kind.RIGHT_SHIFT;
                }
                case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                    return Tree.Kind.UNSIGNED_RIGHT_SHIFT;
                }
                case AND_ASSIGNMENT: {
                    return Tree.Kind.AND;
                }
                case OR_ASSIGNMENT: {
                    return Tree.Kind.OR;
                }
                case XOR_ASSIGNMENT: {
                    return Tree.Kind.XOR;
                }
            }
            return Tree.Kind.ERRONEOUS;
        }

        @Override
        public Node visitCompoundAssignment(CompoundAssignmentTree tree, Void p) {
            Tree.Kind kind = tree.getKind();
            switch (kind) {
                case DIVIDE_ASSIGNMENT: 
                case MULTIPLY_ASSIGNMENT: 
                case REMAINDER_ASSIGNMENT: {
                    TypeElement throwableElement;
                    BinaryOperationNode operNode;
                    Node targetLHS = (Node)this.scan(tree.getVariable(), p);
                    Node value = (Node)this.scan(tree.getExpression(), p);
                    TypeMirror exprType = TreeUtils.typeOf((Tree)tree);
                    TypeMirror leftType = TreeUtils.typeOf((Tree)tree.getVariable());
                    TypeMirror rightType = TreeUtils.typeOf((Tree)tree.getExpression());
                    TypeMirror promotedType = this.binaryPromotedType(leftType, rightType);
                    Node targetRHS = this.binaryNumericPromotion(targetLHS, promotedType);
                    value = this.binaryNumericPromotion(value, promotedType);
                    BinaryTree operTree = this.treeBuilder.buildBinary(promotedType, this.withoutAssignment(kind), tree.getVariable(), tree.getExpression());
                    this.handleArtificialTree(operTree);
                    if (kind == Tree.Kind.MULTIPLY_ASSIGNMENT) {
                        operNode = new NumericalMultiplicationNode(operTree, targetRHS, value);
                    } else if (kind == Tree.Kind.DIVIDE_ASSIGNMENT) {
                        if (TypesUtils.isIntegral((TypeMirror)exprType)) {
                            operNode = new IntegerDivisionNode(operTree, targetRHS, value);
                            throwableElement = this.elements.getTypeElement("java.lang.ArithmeticException");
                            this.extendWithNodeWithException(operNode, throwableElement.asType());
                        } else {
                            operNode = new FloatingDivisionNode(operTree, targetRHS, value);
                        }
                    } else {
                        assert (kind == Tree.Kind.REMAINDER_ASSIGNMENT);
                        if (TypesUtils.isIntegral((TypeMirror)exprType)) {
                            operNode = new IntegerRemainderNode(operTree, targetRHS, value);
                            throwableElement = this.elements.getTypeElement("java.lang.ArithmeticException");
                            this.extendWithNodeWithException(operNode, throwableElement.asType());
                        } else {
                            operNode = new FloatingRemainderNode(operTree, targetRHS, value);
                        }
                    }
                    this.extendWithNode(operNode);
                    TypeCastTree castTree = this.treeBuilder.buildTypeCast(leftType, (ExpressionTree)operTree);
                    this.handleArtificialTree(castTree);
                    TypeCastNode castNode = new TypeCastNode(castTree, operNode, leftType);
                    castNode.setInSource(false);
                    this.extendWithNode(castNode);
                    AssignmentNode assignNode = new AssignmentNode(tree, targetLHS, castNode);
                    this.extendWithNode(assignNode);
                    return assignNode;
                }
                case MINUS_ASSIGNMENT: 
                case PLUS_ASSIGNMENT: {
                    BinaryOperationNode operNode;
                    Node targetLHS = (Node)this.scan(tree.getVariable(), p);
                    Node value = (Node)this.scan(tree.getExpression(), p);
                    TypeMirror leftType = TreeUtils.typeOf((Tree)tree.getVariable());
                    TypeMirror rightType = TreeUtils.typeOf((Tree)tree.getExpression());
                    if (TypesUtils.isString((TypeMirror)leftType) || TypesUtils.isString((TypeMirror)rightType)) {
                        assert (kind == Tree.Kind.PLUS_ASSIGNMENT);
                        Node targetRHS = this.stringConversion(targetLHS);
                        value = this.stringConversion(value);
                        StringConcatenateAssignmentNode r = new StringConcatenateAssignmentNode(tree, targetRHS, value);
                        this.extendWithNode(r);
                        return r;
                    }
                    TypeMirror promotedType = this.binaryPromotedType(leftType, rightType);
                    Node targetRHS = this.binaryNumericPromotion(targetLHS, promotedType);
                    value = this.binaryNumericPromotion(value, promotedType);
                    BinaryTree operTree = this.treeBuilder.buildBinary(promotedType, this.withoutAssignment(kind), tree.getVariable(), tree.getExpression());
                    this.handleArtificialTree(operTree);
                    if (kind == Tree.Kind.PLUS_ASSIGNMENT) {
                        operNode = new NumericalAdditionNode(operTree, targetRHS, value);
                    } else {
                        assert (kind == Tree.Kind.MINUS_ASSIGNMENT);
                        operNode = new NumericalSubtractionNode(operTree, targetRHS, value);
                    }
                    this.extendWithNode(operNode);
                    TypeCastTree castTree = this.treeBuilder.buildTypeCast(leftType, (ExpressionTree)operTree);
                    this.handleArtificialTree(castTree);
                    TypeCastNode castNode = new TypeCastNode(castTree, operNode, leftType);
                    castNode.setInSource(false);
                    this.extendWithNode(castNode);
                    AssignmentNode assignNode = new AssignmentNode(tree, targetLHS, castNode);
                    this.extendWithNode(assignNode);
                    return assignNode;
                }
                case LEFT_SHIFT_ASSIGNMENT: 
                case RIGHT_SHIFT_ASSIGNMENT: 
                case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                    BinaryOperationNode operNode;
                    Node targetLHS = (Node)this.scan(tree.getVariable(), p);
                    Node value = (Node)this.scan(tree.getExpression(), p);
                    TypeMirror leftType = TreeUtils.typeOf((Tree)tree.getVariable());
                    Node targetRHS = this.unaryNumericPromotion(targetLHS);
                    value = this.unaryNumericPromotion(value);
                    BinaryTree operTree = this.treeBuilder.buildBinary(leftType, this.withoutAssignment(kind), tree.getVariable(), tree.getExpression());
                    this.handleArtificialTree(operTree);
                    if (kind == Tree.Kind.LEFT_SHIFT_ASSIGNMENT) {
                        operNode = new LeftShiftNode(operTree, targetRHS, value);
                    } else if (kind == Tree.Kind.RIGHT_SHIFT_ASSIGNMENT) {
                        operNode = new SignedRightShiftNode(operTree, targetRHS, value);
                    } else {
                        assert (kind == Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT);
                        operNode = new UnsignedRightShiftNode(operTree, targetRHS, value);
                    }
                    this.extendWithNode(operNode);
                    TypeCastTree castTree = this.treeBuilder.buildTypeCast(leftType, (ExpressionTree)operTree);
                    this.handleArtificialTree(castTree);
                    TypeCastNode castNode = new TypeCastNode(castTree, operNode, leftType);
                    castNode.setInSource(false);
                    this.extendWithNode(castNode);
                    AssignmentNode assignNode = new AssignmentNode(tree, targetLHS, castNode);
                    this.extendWithNode(assignNode);
                    return assignNode;
                }
                case AND_ASSIGNMENT: 
                case OR_ASSIGNMENT: 
                case XOR_ASSIGNMENT: {
                    BinaryOperationNode operNode;
                    Node targetLHS = (Node)this.scan(tree.getVariable(), p);
                    Node value = (Node)this.scan(tree.getExpression(), p);
                    TypeMirror leftType = TreeUtils.typeOf((Tree)tree.getVariable());
                    TypeMirror rightType = TreeUtils.typeOf((Tree)tree.getExpression());
                    Node targetRHS = null;
                    if (this.isNumericOrBoxed(leftType) && this.isNumericOrBoxed(rightType)) {
                        TypeMirror promotedType = this.binaryPromotedType(leftType, rightType);
                        targetRHS = this.binaryNumericPromotion(targetLHS, promotedType);
                        value = this.binaryNumericPromotion(value, promotedType);
                    } else if (TypesUtils.isBooleanType((TypeMirror)leftType) && TypesUtils.isBooleanType((TypeMirror)rightType)) {
                        targetRHS = this.unbox(targetLHS);
                        value = this.unbox(value);
                    } else assert (false) : "Both argument to logical operation must be numeric or boolean";
                    BinaryTree operTree = this.treeBuilder.buildBinary(leftType, this.withoutAssignment(kind), tree.getVariable(), tree.getExpression());
                    this.handleArtificialTree(operTree);
                    if (kind == Tree.Kind.AND_ASSIGNMENT) {
                        operNode = new BitwiseAndNode(operTree, targetRHS, value);
                    } else if (kind == Tree.Kind.OR_ASSIGNMENT) {
                        operNode = new BitwiseOrNode(operTree, targetRHS, value);
                    } else {
                        assert (kind == Tree.Kind.XOR_ASSIGNMENT);
                        operNode = new BitwiseXorNode(operTree, targetRHS, value);
                    }
                    this.extendWithNode(operNode);
                    TypeCastTree castTree = this.treeBuilder.buildTypeCast(leftType, (ExpressionTree)operTree);
                    this.handleArtificialTree(castTree);
                    TypeCastNode castNode = new TypeCastNode(castTree, operNode, leftType);
                    castNode.setInSource(false);
                    this.extendWithNode(castNode);
                    AssignmentNode assignNode = new AssignmentNode(tree, targetLHS, castNode);
                    this.extendWithNode(assignNode);
                    return assignNode;
                }
            }
            assert (false) : "unexpected compound assignment type";
            assert (false) : "unexpected compound assignment type";
            return null;
        }

        @Override
        public Node visitBinary(BinaryTree tree, Void p) {
            BinaryOperationNode r = null;
            ExpressionTree leftTree = tree.getLeftOperand();
            ExpressionTree rightTree = tree.getRightOperand();
            Tree.Kind kind = tree.getKind();
            switch (kind) {
                case DIVIDE: 
                case MULTIPLY: 
                case REMAINDER: {
                    TypeMirror exprType = TreeUtils.typeOf((Tree)tree);
                    TypeMirror leftType = TreeUtils.typeOf((Tree)leftTree);
                    TypeMirror rightType = TreeUtils.typeOf((Tree)rightTree);
                    TypeMirror promotedType = this.binaryPromotedType(leftType, rightType);
                    Node left = this.binaryNumericPromotion((Node)this.scan(leftTree, p), promotedType);
                    Node right = this.binaryNumericPromotion((Node)this.scan(rightTree, p), promotedType);
                    if (kind == Tree.Kind.MULTIPLY) {
                        r = new NumericalMultiplicationNode(tree, left, right);
                        break;
                    }
                    if (kind == Tree.Kind.DIVIDE) {
                        if (TypesUtils.isIntegral((TypeMirror)exprType)) {
                            r = new IntegerDivisionNode(tree, left, right);
                            TypeElement throwableElement = this.elements.getTypeElement("java.lang.ArithmeticException");
                            this.extendWithNodeWithException(r, throwableElement.asType());
                            break;
                        }
                        r = new FloatingDivisionNode(tree, left, right);
                        break;
                    }
                    assert (kind == Tree.Kind.REMAINDER);
                    if (TypesUtils.isIntegral((TypeMirror)exprType)) {
                        r = new IntegerRemainderNode(tree, left, right);
                        TypeElement throwableElement = this.elements.getTypeElement("java.lang.ArithmeticException");
                        this.extendWithNodeWithException(r, throwableElement.asType());
                        break;
                    }
                    r = new FloatingRemainderNode(tree, left, right);
                    break;
                }
                case MINUS: 
                case PLUS: {
                    TypeMirror leftType = TreeUtils.typeOf((Tree)leftTree);
                    TypeMirror rightType = TreeUtils.typeOf((Tree)rightTree);
                    if (TypesUtils.isString((TypeMirror)leftType) || TypesUtils.isString((TypeMirror)rightType)) {
                        assert (kind == Tree.Kind.PLUS);
                        Node left = this.stringConversion((Node)this.scan(leftTree, p));
                        Node right = this.stringConversion((Node)this.scan(rightTree, p));
                        r = new StringConcatenateNode(tree, left, right);
                        break;
                    }
                    TypeMirror promotedType = this.binaryPromotedType(leftType, rightType);
                    Node left = this.binaryNumericPromotion((Node)this.scan(leftTree, p), promotedType);
                    Node right = this.binaryNumericPromotion((Node)this.scan(rightTree, p), promotedType);
                    if (kind == Tree.Kind.PLUS) {
                        r = new NumericalAdditionNode(tree, left, right);
                        break;
                    }
                    assert (kind == Tree.Kind.MINUS);
                    r = new NumericalSubtractionNode(tree, left, right);
                    break;
                }
                case LEFT_SHIFT: 
                case RIGHT_SHIFT: 
                case UNSIGNED_RIGHT_SHIFT: {
                    Node left = this.unaryNumericPromotion((Node)this.scan(leftTree, p));
                    Node right = this.unaryNumericPromotion((Node)this.scan(rightTree, p));
                    if (kind == Tree.Kind.LEFT_SHIFT) {
                        r = new LeftShiftNode(tree, left, right);
                        break;
                    }
                    if (kind == Tree.Kind.RIGHT_SHIFT) {
                        r = new SignedRightShiftNode(tree, left, right);
                        break;
                    }
                    assert (kind == Tree.Kind.UNSIGNED_RIGHT_SHIFT);
                    r = new UnsignedRightShiftNode(tree, left, right);
                    break;
                }
                case GREATER_THAN: 
                case GREATER_THAN_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_EQUAL: {
                    BinaryOperationNode node;
                    TypeMirror rightType;
                    TypeMirror leftType = TreeUtils.typeOf((Tree)leftTree);
                    if (TypesUtils.isBoxedPrimitive((TypeMirror)leftType)) {
                        leftType = this.types.unboxedType(leftType);
                    }
                    if (TypesUtils.isBoxedPrimitive((TypeMirror)(rightType = TreeUtils.typeOf((Tree)rightTree)))) {
                        rightType = this.types.unboxedType(rightType);
                    }
                    TypeMirror promotedType = this.binaryPromotedType(leftType, rightType);
                    Node left = this.binaryNumericPromotion((Node)this.scan(leftTree, p), promotedType);
                    Node right = this.binaryNumericPromotion((Node)this.scan(rightTree, p), promotedType);
                    if (kind == Tree.Kind.GREATER_THAN) {
                        node = new GreaterThanNode(tree, left, right);
                    } else if (kind == Tree.Kind.GREATER_THAN_EQUAL) {
                        node = new GreaterThanOrEqualNode(tree, left, right);
                    } else if (kind == Tree.Kind.LESS_THAN) {
                        node = new LessThanNode(tree, left, right);
                    } else {
                        assert (kind == Tree.Kind.LESS_THAN_EQUAL);
                        node = new LessThanOrEqualNode(tree, left, right);
                    }
                    this.extendWithNode(node);
                    return node;
                }
                case EQUAL_TO: 
                case NOT_EQUAL_TO: {
                    BinaryOperationNode node;
                    TreeInfo leftInfo = this.getTreeInfo(leftTree);
                    TreeInfo rightInfo = this.getTreeInfo(rightTree);
                    Node left = (Node)this.scan(leftTree, p);
                    Node right = (Node)this.scan(rightTree, p);
                    if (leftInfo.isNumeric() && rightInfo.isNumeric() && (!leftInfo.isBoxed() || !rightInfo.isBoxed())) {
                        TypeMirror promotedType = this.binaryPromotedType(leftInfo.unboxedType(), rightInfo.unboxedType());
                        left = this.binaryNumericPromotion(left, promotedType);
                        right = this.binaryNumericPromotion(right, promotedType);
                    } else if (leftInfo.isBoolean() && rightInfo.isBoolean() && (!leftInfo.isBoxed() || !rightInfo.isBoxed())) {
                        left = this.unboxAsNeeded(left, leftInfo.isBoxed());
                        right = this.unboxAsNeeded(right, rightInfo.isBoxed());
                    }
                    if (kind == Tree.Kind.EQUAL_TO) {
                        node = new EqualToNode(tree, left, right);
                    } else {
                        assert (kind == Tree.Kind.NOT_EQUAL_TO);
                        node = new NotEqualNode(tree, left, right);
                    }
                    this.extendWithNode(node);
                    return node;
                }
                case AND: 
                case OR: 
                case XOR: {
                    BinaryOperationNode node;
                    Node right;
                    Node left;
                    boolean isBooleanOp;
                    TypeMirror leftType = TreeUtils.typeOf((Tree)leftTree);
                    TypeMirror rightType = TreeUtils.typeOf((Tree)rightTree);
                    boolean bl = isBooleanOp = TypesUtils.isBooleanType((TypeMirror)leftType) && TypesUtils.isBooleanType((TypeMirror)rightType);
                    if (isBooleanOp) {
                        left = this.unbox((Node)this.scan(leftTree, p));
                        right = this.unbox((Node)this.scan(rightTree, p));
                    } else if (this.isNumericOrBoxed(leftType) && this.isNumericOrBoxed(rightType)) {
                        TypeMirror promotedType = this.binaryPromotedType(leftType, rightType);
                        left = this.binaryNumericPromotion((Node)this.scan(leftTree, p), promotedType);
                        right = this.binaryNumericPromotion((Node)this.scan(rightTree, p), promotedType);
                    } else {
                        left = this.unbox((Node)this.scan(leftTree, p));
                        right = this.unbox((Node)this.scan(rightTree, p));
                    }
                    if (kind == Tree.Kind.AND) {
                        node = new BitwiseAndNode(tree, left, right);
                    } else if (kind == Tree.Kind.OR) {
                        node = new BitwiseOrNode(tree, left, right);
                    } else {
                        assert (kind == Tree.Kind.XOR);
                        node = new BitwiseXorNode(tree, left, right);
                    }
                    this.extendWithNode(node);
                    return node;
                }
                case CONDITIONAL_AND: 
                case CONDITIONAL_OR: {
                    ConditionalJump cjump;
                    Label rightStartL = new Label();
                    Label shortCircuitL = new Label();
                    Node left = (Node)this.scan(leftTree, p);
                    if (kind == Tree.Kind.CONDITIONAL_AND) {
                        cjump = new ConditionalJump(rightStartL, shortCircuitL);
                        cjump.setFalseFlowRule(Store.FlowRule.ELSE_TO_ELSE);
                    } else {
                        cjump = new ConditionalJump(shortCircuitL, rightStartL);
                        cjump.setTrueFlowRule(Store.FlowRule.THEN_TO_THEN);
                    }
                    this.extendWithExtendedNode(cjump);
                    this.addLabelForNextNode(rightStartL);
                    Node right = (Node)this.scan(rightTree, p);
                    this.addLabelForNextNode(shortCircuitL);
                    BinaryOperationNode node = kind == Tree.Kind.CONDITIONAL_AND ? new ConditionalAndNode(tree, left, right) : new ConditionalOrNode(tree, left, right);
                    this.extendWithNode(node);
                    return node;
                }
                default: {
                    assert (false) : "unexpected binary tree: " + (Object)((Object)kind);
                    break;
                }
            }
            assert (r != null) : "unexpected binary tree";
            return this.extendWithNode(r);
        }

        @Override
        public Node visitBlock(BlockTree tree, Void p) {
            for (StatementTree statementTree : tree.getStatements()) {
                this.scan(statementTree, null);
            }
            return null;
        }

        @Override
        public Node visitBreak(BreakTree tree, Void p) {
            Name label = tree.getLabel();
            if (label == null) {
                assert (this.breakTargetL != null) : "no target for break statement";
                this.extendWithExtendedNode(new UnconditionalJump(this.breakTargetL.accessLabel()));
            } else {
                assert (this.breakLabels.containsKey(label));
                this.extendWithExtendedNode(new UnconditionalJump(this.breakLabels.get(label)));
            }
            return null;
        }

        @Override
        public Node visitSwitch(SwitchTree tree, Void p) {
            SwitchBuilder builder = new SwitchBuilder(tree, p);
            builder.build();
            return null;
        }

        @Override
        public Node visitCase(CaseTree tree, Void p) {
            throw new AssertionError((Object)"case visitor is implemented in SwitchBuilder");
        }

        @Override
        public Node visitCatch(CatchTree tree, Void p) {
            this.scan(tree.getParameter(), p);
            this.scan(tree.getBlock(), p);
            return null;
        }

        @Override
        public Node visitClass(ClassTree tree, Void p) {
            CFGBuilder.this.declaredClasses.add(tree);
            return null;
        }

        @Override
        public Node visitConditionalExpression(ConditionalExpressionTree tree, Void p) {
            TypeMirror exprType = TreeUtils.typeOf((Tree)tree);
            Label trueStart = new Label();
            Label falseStart = new Label();
            Label merge = new Label();
            Node condition = this.unbox((Node)this.scan(tree.getCondition(), p));
            ConditionalJump cjump = new ConditionalJump(trueStart, falseStart);
            this.extendWithExtendedNode(cjump);
            this.addLabelForNextNode(trueStart);
            Node trueExpr = (Node)this.scan(tree.getTrueExpression(), p);
            trueExpr = this.conditionalExprPromotion(trueExpr, exprType);
            this.extendWithExtendedNode(new UnconditionalJump(merge));
            this.addLabelForNextNode(falseStart);
            Node falseExpr = (Node)this.scan(tree.getFalseExpression(), p);
            falseExpr = this.conditionalExprPromotion(falseExpr, exprType);
            this.addLabelForNextNode(merge);
            TernaryExpressionNode node = new TernaryExpressionNode(tree, condition, trueExpr, falseExpr);
            this.extendWithNode(node);
            return node;
        }

        @Override
        public Node visitContinue(ContinueTree tree, Void p) {
            Name label = tree.getLabel();
            if (label == null) {
                assert (this.continueTargetL != null) : "no target for continue statement";
                this.extendWithExtendedNode(new UnconditionalJump(this.continueTargetL.accessLabel()));
            } else {
                assert (this.continueLabels.containsKey(label));
                this.extendWithExtendedNode(new UnconditionalJump(this.continueLabels.get(label)));
            }
            return null;
        }

        @Override
        public Node visitDoWhileLoop(DoWhileLoopTree tree, Void p) {
            Name parentLabel = this.getLabel(this.getCurrentPath());
            Label loopEntry = new Label();
            Label loopExit = new Label();
            Label conditionStart = parentLabel != null ? this.continueLabels.get(parentLabel) : new Label();
            TryFinallyScopeCell oldBreakTargetL = this.breakTargetL;
            this.breakTargetL = new TryFinallyScopeCell(loopExit);
            TryFinallyScopeCell oldContinueTargetL = this.continueTargetL;
            this.continueTargetL = new TryFinallyScopeCell(conditionStart);
            this.addLabelForNextNode(loopEntry);
            if (tree.getStatement() != null) {
                this.scan(tree.getStatement(), p);
            }
            this.addLabelForNextNode(conditionStart);
            if (tree.getCondition() != null) {
                this.unbox((Node)this.scan(tree.getCondition(), p));
                ConditionalJump cjump = new ConditionalJump(loopEntry, loopExit);
                this.extendWithExtendedNode(cjump);
            }
            this.addLabelForNextNode(loopExit);
            this.breakTargetL = oldBreakTargetL;
            this.continueTargetL = oldContinueTargetL;
            return null;
        }

        @Override
        public Node visitErroneous(ErroneousTree tree, Void p) {
            assert (false) : "ErroneousTree is unexpected in AST to CFG translation";
            return null;
        }

        @Override
        public Node visitExpressionStatement(ExpressionStatementTree tree, Void p) {
            return (Node)this.scan(tree.getExpression(), p);
        }

        @Override
        public Node visitEnhancedForLoop(EnhancedForLoopTree tree, Void p) {
            Name parentLabel = this.getLabel(this.getCurrentPath());
            Label conditionStart = new Label();
            Label loopEntry = new Label();
            Label loopExit = new Label();
            Label updateStart = parentLabel != null ? this.continueLabels.get(parentLabel) : new Label();
            TryFinallyScopeCell oldBreakTargetL = this.breakTargetL;
            this.breakTargetL = new TryFinallyScopeCell(loopExit);
            TryFinallyScopeCell oldContinueTargetL = this.continueTargetL;
            this.continueTargetL = new TryFinallyScopeCell(updateStart);
            TypeElement iterableElement = this.elements.getTypeElement("java.lang.Iterable");
            TypeMirror iterableType = this.types.erasure(iterableElement.asType());
            VariableTree variable = tree.getVariable();
            VariableElement variableElement = TreeUtils.elementFromDeclaration((VariableTree)variable);
            ExpressionTree expression = tree.getExpression();
            StatementTree statement = tree.getStatement();
            TypeMirror exprType = TreeUtils.typeOf((Tree)expression);
            if (this.types.isSubtype(exprType, iterableType)) {
                exprType = TypesUtils.upperBound((TypeMirror)exprType);
                assert (exprType instanceof DeclaredType) : "an Iterable must be a DeclaredType";
                DeclaredType declaredExprType = (DeclaredType)exprType;
                declaredExprType.getTypeArguments();
                MemberSelectTree iteratorSelect = this.treeBuilder.buildIteratorMethodAccess(expression);
                this.handleArtificialTree(iteratorSelect);
                MethodInvocationTree iteratorCall = this.treeBuilder.buildMethodInvocation((ExpressionTree)iteratorSelect);
                this.handleArtificialTree(iteratorCall);
                VariableTree iteratorVariable = this.createEnhancedForLoopIteratorVariable(iteratorCall, variableElement);
                this.handleArtificialTree(iteratorVariable);
                VariableDeclarationNode iteratorVariableDecl = new VariableDeclarationNode(iteratorVariable);
                iteratorVariableDecl.setInSource(false);
                this.extendWithNode(iteratorVariableDecl);
                Node expressionNode = (Node)this.scan(expression, p);
                MethodAccessNode iteratorAccessNode = new MethodAccessNode(iteratorSelect, expressionNode);
                iteratorAccessNode.setInSource(false);
                this.extendWithNode(iteratorAccessNode);
                MethodInvocationNode iteratorCallNode = new MethodInvocationNode(iteratorCall, iteratorAccessNode, Collections.emptyList(), this.getCurrentPath());
                iteratorCallNode.setInSource(false);
                this.extendWithNode(iteratorCallNode);
                this.translateAssignment((Tree)iteratorVariable, (Node)new LocalVariableNode(iteratorVariable), iteratorCallNode);
                this.addLabelForNextNode(conditionStart);
                IdentifierTree iteratorUse1 = this.treeBuilder.buildVariableUse(iteratorVariable);
                this.handleArtificialTree(iteratorUse1);
                LocalVariableNode iteratorReceiverNode = new LocalVariableNode(iteratorUse1);
                iteratorReceiverNode.setInSource(false);
                this.extendWithNode(iteratorReceiverNode);
                MemberSelectTree hasNextSelect = this.treeBuilder.buildHasNextMethodAccess((ExpressionTree)iteratorUse1);
                this.handleArtificialTree(hasNextSelect);
                MethodAccessNode hasNextAccessNode = new MethodAccessNode(hasNextSelect, iteratorReceiverNode);
                hasNextAccessNode.setInSource(false);
                this.extendWithNode(hasNextAccessNode);
                MethodInvocationTree hasNextCall = this.treeBuilder.buildMethodInvocation((ExpressionTree)hasNextSelect);
                this.handleArtificialTree(hasNextCall);
                MethodInvocationNode hasNextCallNode = new MethodInvocationNode(hasNextCall, hasNextAccessNode, Collections.emptyList(), this.getCurrentPath());
                hasNextCallNode.setInSource(false);
                this.extendWithNode(hasNextCallNode);
                this.extendWithExtendedNode(new ConditionalJump(loopEntry, loopExit));
                this.addLabelForNextNode(loopEntry);
                this.extendWithNode(new VariableDeclarationNode(variable));
                IdentifierTree iteratorUse2 = this.treeBuilder.buildVariableUse(iteratorVariable);
                this.handleArtificialTree(iteratorUse2);
                LocalVariableNode iteratorReceiverNode2 = new LocalVariableNode(iteratorUse2);
                iteratorReceiverNode2.setInSource(false);
                this.extendWithNode(iteratorReceiverNode2);
                MemberSelectTree nextSelect = this.treeBuilder.buildNextMethodAccess((ExpressionTree)iteratorUse2);
                this.handleArtificialTree(nextSelect);
                MethodAccessNode nextAccessNode = new MethodAccessNode(nextSelect, iteratorReceiverNode2);
                nextAccessNode.setInSource(false);
                this.extendWithNode(nextAccessNode);
                MethodInvocationTree nextCall = this.treeBuilder.buildMethodInvocation((ExpressionTree)nextSelect);
                this.handleArtificialTree(nextCall);
                MethodInvocationNode nextCallNode = new MethodInvocationNode(nextCall, nextAccessNode, Collections.emptyList(), this.getCurrentPath());
                nextCallNode.setInSource(false);
                this.extendWithNode(nextCallNode);
                this.translateAssignment((Tree)variable, (Node)new LocalVariableNode(variable), nextCall);
                if (statement != null) {
                    this.scan(statement, p);
                }
                this.addLabelForNextNode(updateStart);
                this.extendWithExtendedNode(new UnconditionalJump(conditionStart));
            } else {
                VariableTree arrayVariable = this.createEnhancedForLoopArrayVariable(expression, variableElement);
                this.handleArtificialTree(arrayVariable);
                VariableDeclarationNode arrayVariableNode = new VariableDeclarationNode(arrayVariable);
                arrayVariableNode.setInSource(false);
                this.extendWithNode(arrayVariableNode);
                Node expressionNode = (Node)this.scan(expression, p);
                this.translateAssignment((Tree)arrayVariable, (Node)new LocalVariableNode(arrayVariable), expressionNode);
                PrimitiveType intType = this.types.getPrimitiveType(TypeKind.INT);
                LiteralTree zero = this.treeBuilder.buildLiteral((Object)0);
                this.handleArtificialTree(zero);
                VariableTree indexVariable = this.treeBuilder.buildVariableDecl((TypeMirror)intType, this.uniqueName("index"), variableElement.getEnclosingElement(), (ExpressionTree)zero);
                this.handleArtificialTree(indexVariable);
                VariableDeclarationNode indexVariableNode = new VariableDeclarationNode(indexVariable);
                indexVariableNode.setInSource(false);
                this.extendWithNode(indexVariableNode);
                IntegerLiteralNode zeroNode = this.extendWithNode(new IntegerLiteralNode(zero));
                this.translateAssignment((Tree)indexVariable, (Node)new LocalVariableNode(indexVariable), zeroNode);
                this.addLabelForNextNode(conditionStart);
                IdentifierTree indexUse1 = this.treeBuilder.buildVariableUse(indexVariable);
                this.handleArtificialTree(indexUse1);
                LocalVariableNode indexNode1 = new LocalVariableNode(indexUse1);
                indexNode1.setInSource(false);
                this.extendWithNode(indexNode1);
                IdentifierTree arrayUse1 = this.treeBuilder.buildVariableUse(arrayVariable);
                this.handleArtificialTree(arrayUse1);
                LocalVariableNode arrayNode1 = this.extendWithNode(new LocalVariableNode(arrayUse1));
                MemberSelectTree lengthSelect = this.treeBuilder.buildArrayLengthAccess((ExpressionTree)arrayUse1);
                this.handleArtificialTree(lengthSelect);
                FieldAccessNode lengthAccessNode = new FieldAccessNode(lengthSelect, arrayNode1);
                lengthAccessNode.setInSource(false);
                this.extendWithNode(lengthAccessNode);
                BinaryTree lessThan = this.treeBuilder.buildLessThan((ExpressionTree)indexUse1, (ExpressionTree)lengthSelect);
                this.handleArtificialTree(lessThan);
                LessThanNode lessThanNode = new LessThanNode(lessThan, indexNode1, lengthAccessNode);
                lessThanNode.setInSource(false);
                this.extendWithNode(lessThanNode);
                this.extendWithExtendedNode(new ConditionalJump(loopEntry, loopExit));
                this.addLabelForNextNode(loopEntry);
                this.extendWithNode(new VariableDeclarationNode(variable));
                IdentifierTree arrayUse2 = this.treeBuilder.buildVariableUse(arrayVariable);
                this.handleArtificialTree(arrayUse2);
                LocalVariableNode arrayNode2 = new LocalVariableNode(arrayUse2);
                arrayNode2.setInSource(false);
                this.extendWithNode(arrayNode2);
                IdentifierTree indexUse2 = this.treeBuilder.buildVariableUse(indexVariable);
                this.handleArtificialTree(indexUse2);
                LocalVariableNode indexNode2 = new LocalVariableNode(indexUse2);
                indexNode2.setInSource(false);
                this.extendWithNode(indexNode2);
                ArrayAccessTree arrayAccess = this.treeBuilder.buildArrayAccess((ExpressionTree)arrayUse2, (ExpressionTree)indexUse2);
                this.handleArtificialTree(arrayAccess);
                ArrayAccessNode arrayAccessNode = new ArrayAccessNode(arrayAccess, arrayNode2, indexNode2);
                arrayAccessNode.setInSource(false);
                this.extendWithNode(arrayAccessNode);
                this.translateAssignment((Tree)variable, (Node)new LocalVariableNode(variable), arrayAccessNode);
                TypeElement npeElement = this.elements.getTypeElement("java.lang.NullPointerException");
                this.extendWithNodeWithException(arrayAccessNode, npeElement.asType());
                if (statement != null) {
                    this.scan(statement, p);
                }
                this.addLabelForNextNode(updateStart);
                IdentifierTree indexUse3 = this.treeBuilder.buildVariableUse(indexVariable);
                this.handleArtificialTree(indexUse3);
                LocalVariableNode indexNode3 = new LocalVariableNode(indexUse3);
                indexNode3.setInSource(false);
                this.extendWithNode(indexNode3);
                LiteralTree oneTree = this.treeBuilder.buildLiteral((Object)1);
                this.handleArtificialTree(oneTree);
                IntegerLiteralNode one = new IntegerLiteralNode(oneTree);
                one.setInSource(false);
                this.extendWithNode(one);
                BinaryTree addOneTree = this.treeBuilder.buildBinary((TypeMirror)intType, Tree.Kind.PLUS, (ExpressionTree)indexUse3, (ExpressionTree)oneTree);
                this.handleArtificialTree(addOneTree);
                NumericalAdditionNode addOneNode = new NumericalAdditionNode(addOneTree, indexNode3, one);
                addOneNode.setInSource(false);
                this.extendWithNode(addOneNode);
                AssignmentTree assignTree = this.treeBuilder.buildAssignment((ExpressionTree)indexUse3, (ExpressionTree)addOneTree);
                this.handleArtificialTree(assignTree);
                AssignmentNode assignNode = new AssignmentNode(assignTree, indexNode3, addOneNode);
                assignNode.setInSource(false);
                this.extendWithNode(assignNode);
                this.extendWithExtendedNode(new UnconditionalJump(conditionStart));
            }
            this.addLabelForNextNode(loopExit);
            this.breakTargetL = oldBreakTargetL;
            this.continueTargetL = oldContinueTargetL;
            return null;
        }

        protected VariableTree createEnhancedForLoopIteratorVariable(MethodInvocationTree iteratorCall, VariableElement variableElement) {
            TypeMirror iteratorType = TreeUtils.typeOf((Tree)iteratorCall);
            VariableTree iteratorVariable = this.treeBuilder.buildVariableDecl(iteratorType, this.uniqueName("iter"), variableElement.getEnclosingElement(), (ExpressionTree)iteratorCall);
            return iteratorVariable;
        }

        protected VariableTree createEnhancedForLoopArrayVariable(ExpressionTree expression, VariableElement variableElement) {
            TypeMirror arrayType = TreeUtils.typeOf((Tree)expression);
            VariableTree arrayVariable = this.treeBuilder.buildVariableDecl(arrayType, this.uniqueName("array"), variableElement.getEnclosingElement(), expression);
            return arrayVariable;
        }

        @Override
        public Node visitForLoop(ForLoopTree tree, Void p) {
            Name parentLabel = this.getLabel(this.getCurrentPath());
            Label conditionStart = new Label();
            Label loopEntry = new Label();
            Label loopExit = new Label();
            Label updateStart = parentLabel != null ? this.continueLabels.get(parentLabel) : new Label();
            TryFinallyScopeCell oldBreakTargetL = this.breakTargetL;
            this.breakTargetL = new TryFinallyScopeCell(loopExit);
            TryFinallyScopeCell oldContinueTargetL = this.continueTargetL;
            this.continueTargetL = new TryFinallyScopeCell(updateStart);
            for (StatementTree statementTree : tree.getInitializer()) {
                this.scan(statementTree, p);
            }
            this.addLabelForNextNode(conditionStart);
            if (tree.getCondition() != null) {
                this.unbox((Node)this.scan(tree.getCondition(), p));
                ConditionalJump cjump = new ConditionalJump(loopEntry, loopExit);
                this.extendWithExtendedNode(cjump);
            }
            this.addLabelForNextNode(loopEntry);
            if (tree.getStatement() != null) {
                this.scan(tree.getStatement(), p);
            }
            this.addLabelForNextNode(updateStart);
            for (ExpressionStatementTree expressionStatementTree : tree.getUpdate()) {
                this.scan(expressionStatementTree, p);
            }
            this.extendWithExtendedNode(new UnconditionalJump(conditionStart));
            this.addLabelForNextNode(loopExit);
            this.breakTargetL = oldBreakTargetL;
            this.continueTargetL = oldContinueTargetL;
            return null;
        }

        @Override
        public Node visitIdentifier(IdentifierTree tree, Void p) {
            Node node;
            if (TreeUtils.isFieldAccess((Tree)tree)) {
                Node receiver = this.getReceiver(tree, TreeUtils.enclosingClass((TreePath)this.getCurrentPath()));
                node = new FieldAccessNode(tree, receiver);
            } else {
                Element element = TreeUtils.elementFromUse((ExpressionTree)tree);
                switch (element.getKind()) {
                    case ANNOTATION_TYPE: 
                    case CLASS: 
                    case ENUM: 
                    case INTERFACE: 
                    case TYPE_PARAMETER: {
                        node = new ClassNameNode(tree);
                        break;
                    }
                    case FIELD: {
                        if (element.getSimpleName().contentEquals("this")) {
                            node = new ExplicitThisLiteralNode(tree);
                            break;
                        }
                        node = new SuperNode(tree);
                        break;
                    }
                    case EXCEPTION_PARAMETER: 
                    case LOCAL_VARIABLE: 
                    case RESOURCE_VARIABLE: 
                    case PARAMETER: {
                        node = new LocalVariableNode(tree);
                        break;
                    }
                    case PACKAGE: {
                        node = new PackageNameNode(tree);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unexpected element kind : " + (Object)((Object)element.getKind()));
                    }
                }
            }
            this.extendWithNode(node);
            return node;
        }

        @Override
        public Node visitIf(IfTree tree, Void p) {
            Label thenEntry = new Label();
            Label elseEntry = new Label();
            Label endIf = new Label();
            this.unbox((Node)this.scan(tree.getCondition(), p));
            ConditionalJump cjump = new ConditionalJump(thenEntry, elseEntry);
            this.extendWithExtendedNode(cjump);
            this.addLabelForNextNode(thenEntry);
            StatementTree thenStatement = tree.getThenStatement();
            this.scan(thenStatement, p);
            this.extendWithExtendedNode(new UnconditionalJump(endIf));
            this.addLabelForNextNode(elseEntry);
            StatementTree elseStatement = tree.getElseStatement();
            if (elseStatement != null) {
                this.scan(elseStatement, p);
            }
            this.addLabelForNextNode(endIf);
            return null;
        }

        @Override
        public Node visitImport(ImportTree tree, Void p) {
            assert (false) : "ImportTree is unexpected in AST to CFG translation";
            return null;
        }

        @Override
        public Node visitArrayAccess(ArrayAccessTree tree, Void p) {
            Node array = (Node)this.scan(tree.getExpression(), p);
            Node index = this.unaryNumericPromotion((Node)this.scan(tree.getIndex(), p));
            ArrayAccessNode arrayAccess = this.extendWithNode(new ArrayAccessNode(tree, array, index));
            TypeElement aioobeElement = this.elements.getTypeElement("java.lang.ArrayIndexOutOfBoundsException");
            this.extendWithNodeWithException(arrayAccess, aioobeElement.asType());
            TypeElement npeElement = this.elements.getTypeElement("java.lang.NullPointerException");
            this.extendWithNodeWithException(arrayAccess, npeElement.asType());
            return arrayAccess;
        }

        @Override
        public Node visitLabeledStatement(LabeledStatementTree tree, Void p) {
            Name labelName = tree.getLabel();
            Label breakL = new Label(labelName + "_break");
            Label continueL = new Label(labelName + "_continue");
            this.breakLabels.put(labelName, breakL);
            this.continueLabels.put(labelName, continueL);
            this.scan(tree.getStatement(), p);
            this.addLabelForNextNode(breakL);
            this.breakLabels.remove(labelName);
            this.continueLabels.remove(labelName);
            return null;
        }

        @Override
        public Node visitLiteral(LiteralTree tree, Void p) {
            ValueLiteralNode r = null;
            switch (tree.getKind()) {
                case BOOLEAN_LITERAL: {
                    r = new BooleanLiteralNode(tree);
                    break;
                }
                case CHAR_LITERAL: {
                    r = new CharacterLiteralNode(tree);
                    break;
                }
                case DOUBLE_LITERAL: {
                    r = new DoubleLiteralNode(tree);
                    break;
                }
                case FLOAT_LITERAL: {
                    r = new FloatLiteralNode(tree);
                    break;
                }
                case INT_LITERAL: {
                    r = new IntegerLiteralNode(tree);
                    break;
                }
                case LONG_LITERAL: {
                    r = new LongLiteralNode(tree);
                    break;
                }
                case NULL_LITERAL: {
                    r = new NullLiteralNode(tree);
                    break;
                }
                case STRING_LITERAL: {
                    r = new StringLiteralNode(tree);
                    break;
                }
                default: {
                    assert (false) : "unexpected literal tree";
                    break;
                }
            }
            assert (r != null) : "unexpected literal tree";
            BooleanLiteralNode result = this.extendWithNode(r);
            return result;
        }

        @Override
        public Node visitMethod(MethodTree tree, Void p) {
            assert (false) : "MethodTree is unexpected in AST to CFG translation";
            return null;
        }

        @Override
        public Node visitModifiers(ModifiersTree tree, Void p) {
            assert (false) : "ModifiersTree is unexpected in AST to CFG translation";
            return null;
        }

        @Override
        public Node visitNewArray(NewArrayTree tree, Void p) {
            ArrayType type = (ArrayType)TreeUtils.typeOf((Tree)tree);
            TypeMirror elemType = type.getComponentType();
            List<? extends ExpressionTree> dimensions = tree.getDimensions();
            List<? extends ExpressionTree> initializers = tree.getInitializers();
            ArrayList<Node> dimensionNodes = new ArrayList<Node>();
            if (dimensions != null) {
                for (ExpressionTree expressionTree : dimensions) {
                    dimensionNodes.add(this.unaryNumericPromotion((Node)this.scan(expressionTree, p)));
                }
            }
            ArrayList<Node> initializerNodes = new ArrayList<Node>();
            if (initializers != null) {
                for (ExpressionTree expressionTree : initializers) {
                    initializerNodes.add(this.assignConvert((Node)this.scan(expressionTree, p), elemType));
                }
            }
            ArrayCreationNode arrayCreationNode = new ArrayCreationNode(tree, type, dimensionNodes, initializerNodes);
            return this.extendWithNode(arrayCreationNode);
        }

        @Override
        public Node visitNewClass(NewClassTree tree, Void p) {
            ExpressionTree enclosingExpr = tree.getEnclosingExpression();
            if (enclosingExpr != null) {
                this.scan(enclosingExpr, p);
            }
            ExecutableElement constructor = TreeUtils.elementFromUse((NewClassTree)tree);
            List<? extends ExpressionTree> actualExprs = tree.getArguments();
            List<Node> arguments = this.convertCallArguments(constructor, actualExprs);
            Node constructorNode = (Node)this.scan(tree.getIdentifier(), p);
            ObjectCreationNode node = new ObjectCreationNode(tree, constructorNode, arguments);
            HashSet<TypeMirror> thrownSet = new HashSet<TypeMirror>();
            List<? extends TypeMirror> thrownTypes = constructor.getThrownTypes();
            thrownSet.addAll(thrownTypes);
            TypeElement throwableElement = this.elements.getTypeElement("java.lang.Throwable");
            thrownSet.add(throwableElement.asType());
            this.extendWithNodeWithExceptions(node, thrownSet);
            return node;
        }

        @Override
        public Node visitParenthesized(ParenthesizedTree tree, Void p) {
            this.parenMapping.put(tree.getExpression(), tree);
            return (Node)this.scan(tree.getExpression(), p);
        }

        @Override
        public Node visitReturn(ReturnTree tree, Void p) {
            ExpressionTree ret = tree.getExpression();
            ReturnNode result = null;
            if (ret != null) {
                Node node = (Node)this.scan(ret, p);
                Tree enclosing = TreeUtils.enclosingOfKind((TreePath)this.getCurrentPath(), new HashSet<Tree.Kind>(Arrays.asList(Tree.Kind.METHOD, Tree.Kind.LAMBDA_EXPRESSION)));
                if (enclosing.getKind() == Tree.Kind.LAMBDA_EXPRESSION) {
                    LambdaExpressionTree lambdaTree = (LambdaExpressionTree)enclosing;
                    TreePath lambdaTreePath = TreePath.getPath(this.getCurrentPath().getCompilationUnit(), (Tree)lambdaTree);
                    Context ctx = ((JavacProcessingEnvironment)this.env).getContext();
                    Symbol overriddenElement = com.sun.tools.javac.code.Types.instance(ctx).findDescriptorSymbol(((Type)this.trees.getTypeMirror((TreePath)lambdaTreePath)).tsym);
                    result = new ReturnNode(tree, node, this.env.getTypeUtils(), lambdaTree, (Symbol.MethodSymbol)overriddenElement);
                } else {
                    result = new ReturnNode(tree, node, this.env.getTypeUtils(), (MethodTree)enclosing);
                }
                this.returnNodes.add(result);
                this.extendWithNode(result);
            }
            this.extendWithExtendedNode(new UnconditionalJump(this.returnTargetL.accessLabel()));
            return result;
        }

        @Override
        public Node visitMemberSelect(MemberSelectTree tree, Void p) {
            Node expr = (Node)this.scan(tree.getExpression(), p);
            if (!TreeUtils.isFieldAccess((Tree)tree)) {
                Node result = null;
                Element element = TreeUtils.elementFromUse((ExpressionTree)tree);
                switch (element.getKind()) {
                    case ANNOTATION_TYPE: 
                    case CLASS: 
                    case ENUM: 
                    case INTERFACE: {
                        result = this.extendWithNode(new ClassNameNode(tree, expr));
                        break;
                    }
                    case PACKAGE: {
                        result = this.extendWithNode(new PackageNameNode(tree, (PackageNameNode)expr));
                        break;
                    }
                    default: {
                        assert (false) : "Unexpected element kind: " + (Object)((Object)element.getKind());
                        return null;
                    }
                }
                return result;
            }
            FieldAccessNode node = new FieldAccessNode(tree, expr);
            Element element = TreeUtils.elementFromUse((ExpressionTree)tree);
            if (ElementUtils.isStatic((Element)element) || expr instanceof ImplicitThisLiteralNode || expr instanceof ExplicitThisLiteralNode) {
                this.extendWithNode(node);
            } else {
                TypeElement npeElement = this.elements.getTypeElement("java.lang.NullPointerException");
                this.extendWithNodeWithException(node, npeElement.asType());
            }
            return node;
        }

        @Override
        public Node visitEmptyStatement(EmptyStatementTree tree, Void p) {
            return null;
        }

        @Override
        public Node visitSynchronized(SynchronizedTree tree, Void p) {
            Node synchronizedExpr = (Node)this.scan(tree.getExpression(), p);
            SynchronizedNode synchronizedStartNode = new SynchronizedNode(tree, synchronizedExpr, true, this.env.getTypeUtils());
            this.extendWithNode(synchronizedStartNode);
            this.scan(tree.getBlock(), p);
            SynchronizedNode synchronizedEndNode = new SynchronizedNode(tree, synchronizedExpr, false, this.env.getTypeUtils());
            this.extendWithNode(synchronizedEndNode);
            return null;
        }

        @Override
        public Node visitThrow(ThrowTree tree, Void p) {
            Node expression = (Node)this.scan(tree.getExpression(), p);
            TypeMirror exception = expression.getType();
            ThrowNode throwsNode = new ThrowNode(tree, expression, this.env.getTypeUtils());
            NodeWithExceptionsHolder exNode = this.extendWithNodeWithException(throwsNode, exception);
            exNode.setTerminatesExecution(true);
            return throwsNode;
        }

        @Override
        public Node visitCompilationUnit(CompilationUnitTree tree, Void p) {
            assert (false) : "CompilationUnitTree is unexpected in AST to CFG translation";
            return null;
        }

        @Override
        public Node visitTry(TryTree tree, Void p) {
            List<? extends CatchTree> catches = tree.getCatches();
            BlockTree finallyBlock = tree.getFinallyBlock();
            this.extendWithNode(new MarkerNode(tree, "start of try statement", this.env.getTypeUtils()));
            List<? extends Tree> resources = tree.getResources();
            for (Tree tree2 : resources) {
                this.scan(tree2, p);
            }
            ArrayList<Pair<TypeMirror, Label>> catchLabels = new ArrayList<Pair<TypeMirror, Label>>();
            for (CatchTree catchTree : catches) {
                TypeMirror type = TreeUtils.typeOf((Tree)catchTree.getParameter().getType());
                assert (type != null) : "exception parameters must have a type";
                catchLabels.add(Pair.of((Object)type, (Object)new Label()));
            }
            TryFinallyScopeCell tryFinallyScopeCell = this.returnTargetL;
            TryFinallyScopeCell tryFinallyScopeCell2 = this.breakTargetL;
            Map<Name, Label> oldBreakLabels = this.breakLabels;
            TryFinallyScopeCell oldContinueTargetL = this.continueTargetL;
            Map<Name, Label> oldContinueLabels = this.continueLabels;
            Label finallyLabel = null;
            Label exceptionalFinallyLabel = null;
            if (finallyBlock != null) {
                finallyLabel = new Label();
                exceptionalFinallyLabel = new Label();
                this.tryStack.pushFrame(new TryFinallyFrame(exceptionalFinallyLabel));
                this.returnTargetL = new TryFinallyScopeCell();
                this.breakTargetL = new TryFinallyScopeCell();
                this.breakLabels = new TryFinallyScopeMap();
                this.continueTargetL = new TryFinallyScopeCell();
                this.continueLabels = new TryFinallyScopeMap();
            }
            Label doneLabel = new Label();
            this.tryStack.pushFrame(new TryCatchFrame(this.types, catchLabels));
            this.extendWithNode(new MarkerNode(tree, "start of try block #" + tree.hashCode(), this.env.getTypeUtils()));
            this.scan(tree.getBlock(), p);
            this.extendWithNode(new MarkerNode(tree, "end of try block #" + tree.hashCode(), this.env.getTypeUtils()));
            this.extendWithExtendedNode(new UnconditionalJump((Label)CFGBuilder.firstNonNull(finallyLabel, doneLabel)));
            this.tryStack.popFrame();
            int catchIndex = 0;
            for (CatchTree catchTree : catches) {
                this.addLabelForNextNode((Label)((Pair)catchLabels.get((int)catchIndex)).second);
                this.extendWithNode(new MarkerNode(tree, "start of catch block for " + catchTree.getClass() + " #" + tree.hashCode(), this.env.getTypeUtils()));
                this.scan(catchTree, p);
                this.extendWithNode(new MarkerNode(tree, "end of catch block for " + catchTree.getClass() + " #" + tree.hashCode(), this.env.getTypeUtils()));
                ++catchIndex;
                this.extendWithExtendedNode(new UnconditionalJump((Label)CFGBuilder.firstNonNull(finallyLabel, doneLabel)));
            }
            if (finallyLabel != null) {
                this.tryStack.popFrame();
                this.addLabelForNextNode(finallyLabel);
                this.extendWithNode(new MarkerNode(tree, "start of finally block #" + tree.hashCode(), this.env.getTypeUtils()));
                this.scan(finallyBlock, p);
                this.extendWithNode(new MarkerNode(tree, "end of finally block #" + tree.hashCode(), this.env.getTypeUtils()));
                this.extendWithExtendedNode(new UnconditionalJump(doneLabel));
                if (this.hasExceptionalPath(exceptionalFinallyLabel)) {
                    this.addLabelForNextNode(exceptionalFinallyLabel);
                    this.extendWithNode(new MarkerNode(tree, "start of finally block for Throwable", this.env.getTypeUtils()));
                    this.scan(finallyBlock, p);
                    TypeMirror throwableType = this.elements.getTypeElement("java.lang.Throwable").asType();
                    NodeWithExceptionsHolder nodeWithExceptionsHolder = this.extendWithNodeWithException(new MarkerNode(tree, "end of finally block for Throwable", this.env.getTypeUtils()), throwableType);
                    nodeWithExceptionsHolder.setTerminatesExecution(true);
                }
                if (this.returnTargetL.wasAccessed()) {
                    this.addLabelForNextNode(this.returnTargetL.peekLabel());
                    this.returnTargetL = tryFinallyScopeCell;
                    this.extendWithNode(new MarkerNode(tree, "start of finally block for return #" + tree.hashCode(), this.env.getTypeUtils()));
                    this.scan(finallyBlock, p);
                    this.extendWithNode(new MarkerNode(tree, "end of finally block for return #" + tree.hashCode(), this.env.getTypeUtils()));
                    this.extendWithExtendedNode(new UnconditionalJump(this.returnTargetL.accessLabel()));
                } else {
                    this.returnTargetL = tryFinallyScopeCell;
                }
                if (this.breakTargetL.wasAccessed()) {
                    this.addLabelForNextNode(this.breakTargetL.peekLabel());
                    this.breakTargetL = tryFinallyScopeCell2;
                    this.extendWithNode(new MarkerNode(tree, "start of finally block for break #" + tree.hashCode(), this.env.getTypeUtils()));
                    this.scan(finallyBlock, p);
                    this.extendWithNode(new MarkerNode(tree, "end of finally block for break #" + tree.hashCode(), this.env.getTypeUtils()));
                    this.extendWithExtendedNode(new UnconditionalJump(this.breakTargetL.accessLabel()));
                } else {
                    this.breakTargetL = tryFinallyScopeCell2;
                }
                Map<Name, Label> accessedBreakLabels = ((TryFinallyScopeMap)this.breakLabels).getAccessedNames();
                if (!accessedBreakLabels.isEmpty()) {
                    this.breakLabels = oldBreakLabels;
                    for (Map.Entry<Name, Label> access : accessedBreakLabels.entrySet()) {
                        this.addLabelForNextNode(access.getValue());
                        this.extendWithNode(new MarkerNode(tree, "start of finally block for break label " + access.getKey() + " #" + tree.hashCode(), this.env.getTypeUtils()));
                        this.scan(finallyBlock, p);
                        this.extendWithNode(new MarkerNode(tree, "end of finally block for break label " + access.getKey() + " #" + tree.hashCode(), this.env.getTypeUtils()));
                        this.extendWithExtendedNode(new UnconditionalJump(this.breakLabels.get(access.getKey())));
                    }
                } else {
                    this.breakLabels = oldBreakLabels;
                }
                if (this.continueTargetL.wasAccessed()) {
                    this.addLabelForNextNode(this.continueTargetL.peekLabel());
                    this.continueTargetL = oldContinueTargetL;
                    this.extendWithNode(new MarkerNode(tree, "start of finally block for continue #" + tree.hashCode(), this.env.getTypeUtils()));
                    this.scan(finallyBlock, p);
                    this.extendWithNode(new MarkerNode(tree, "end of finally block for continue #" + tree.hashCode(), this.env.getTypeUtils()));
                    this.extendWithExtendedNode(new UnconditionalJump(this.continueTargetL.accessLabel()));
                } else {
                    this.continueTargetL = oldContinueTargetL;
                }
                Map<Name, Label> map = ((TryFinallyScopeMap)this.continueLabels).getAccessedNames();
                if (!map.isEmpty()) {
                    this.continueLabels = oldContinueLabels;
                    for (Map.Entry<Name, Label> access : map.entrySet()) {
                        this.addLabelForNextNode(access.getValue());
                        this.extendWithNode(new MarkerNode(tree, "start of finally block for continue label " + access.getKey() + " #" + tree.hashCode(), this.env.getTypeUtils()));
                        this.scan(finallyBlock, p);
                        this.extendWithNode(new MarkerNode(tree, "end of finally block for continue label " + access.getKey() + " #" + tree.hashCode(), this.env.getTypeUtils()));
                        this.extendWithExtendedNode(new UnconditionalJump(this.continueLabels.get(access.getKey())));
                    }
                } else {
                    this.continueLabels = oldContinueLabels;
                }
            }
            this.addLabelForNextNode(doneLabel);
            return null;
        }

        private boolean hasExceptionalPath(Label target) {
            for (ExtendedNode node : this.nodeList) {
                if (!(node instanceof NodeWithExceptionsHolder)) continue;
                NodeWithExceptionsHolder exceptionalNode = (NodeWithExceptionsHolder)node;
                for (Set<Label> labels : exceptionalNode.getExceptions().values()) {
                    if (!labels.contains(target)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Node visitParameterizedType(ParameterizedTypeTree tree, Void p) {
            return this.extendWithNode(new ParameterizedTypeNode(tree));
        }

        @Override
        public Node visitUnionType(UnionTypeTree tree, Void p) {
            assert (false) : "UnionTypeTree is unexpected in AST to CFG translation";
            return null;
        }

        @Override
        public Node visitArrayType(ArrayTypeTree tree, Void p) {
            return this.extendWithNode(new ArrayTypeNode(tree));
        }

        @Override
        public Node visitTypeCast(TypeCastTree tree, Void p) {
            Node operand = (Node)this.scan(tree.getExpression(), p);
            TypeMirror type = TreeUtils.typeOf((Tree)tree.getType());
            TypeCastNode node = new TypeCastNode(tree, operand, type);
            TypeElement cceElement = this.elements.getTypeElement("java.lang.ClassCastException");
            this.extendWithNodeWithException(node, cceElement.asType());
            return node;
        }

        @Override
        public Node visitPrimitiveType(PrimitiveTypeTree tree, Void p) {
            return this.extendWithNode(new PrimitiveTypeNode(tree));
        }

        @Override
        public Node visitTypeParameter(TypeParameterTree tree, Void p) {
            assert (false) : "TypeParameterTree is unexpected in AST to CFG translation";
            return null;
        }

        @Override
        public Node visitInstanceOf(InstanceOfTree tree, Void p) {
            Node operand = (Node)this.scan(tree.getExpression(), p);
            TypeMirror refType = TreeUtils.typeOf((Tree)tree.getType());
            InstanceOfNode node = new InstanceOfNode(tree, operand, refType, this.types);
            this.extendWithNode(node);
            return node;
        }

        @Override
        public Node visitUnary(UnaryTree tree, Void p) {
            Node result = null;
            Tree.Kind kind = tree.getKind();
            block0 : switch (kind) {
                case BITWISE_COMPLEMENT: 
                case UNARY_MINUS: 
                case UNARY_PLUS: {
                    Node expr = (Node)this.scan(tree.getExpression(), p);
                    expr = this.unaryNumericPromotion(expr);
                    switch (kind) {
                        case BITWISE_COMPLEMENT: {
                            result = this.extendWithNode(new BitwiseComplementNode(tree, expr));
                            break block0;
                        }
                        case UNARY_MINUS: {
                            result = this.extendWithNode(new NumericalMinusNode(tree, expr));
                            break block0;
                        }
                        case UNARY_PLUS: {
                            result = this.extendWithNode(new NumericalPlusNode(tree, expr));
                            break block0;
                        }
                    }
                    assert (false);
                    break;
                }
                case LOGICAL_COMPLEMENT: {
                    Node expr = (Node)this.scan(tree.getExpression(), p);
                    result = this.extendWithNode(new ConditionalNotNode(tree, this.unbox(expr)));
                    break;
                }
                case POSTFIX_DECREMENT: 
                case POSTFIX_INCREMENT: 
                case PREFIX_DECREMENT: 
                case PREFIX_INCREMENT: {
                    ExpressionTree exprTree = tree.getExpression();
                    Node expr = (Node)this.scan(exprTree, p);
                    boolean isIncrement = kind == Tree.Kind.POSTFIX_INCREMENT || kind == Tree.Kind.PREFIX_INCREMENT;
                    boolean isPostfix = kind == Tree.Kind.POSTFIX_INCREMENT || kind == Tree.Kind.POSTFIX_DECREMENT;
                    AssignmentNode unaryAssign = this.createIncrementOrDecrementAssign(isPostfix ? null : tree, expr, isIncrement);
                    this.addToUnaryAssignLookupMap(tree, unaryAssign);
                    if (isPostfix) {
                        TypeMirror exprType = TreeUtils.typeOf((Tree)exprTree);
                        VariableTree tempVarDecl = this.treeBuilder.buildVariableDecl(exprType, this.uniqueName("tempPostfix"), this.findOwner(), tree.getExpression());
                        this.handleArtificialTree(tempVarDecl);
                        VariableDeclarationNode tempVarDeclNode = new VariableDeclarationNode(tempVarDecl);
                        tempVarDeclNode.setInSource(false);
                        this.extendWithNode(tempVarDeclNode);
                        IdentifierTree tempVar = this.treeBuilder.buildVariableUse(tempVarDecl);
                        this.handleArtificialTree(tempVar);
                        LocalVariableNode tempVarNode = new LocalVariableNode(tempVar);
                        tempVarNode.setInSource(false);
                        this.extendWithNode(tempVarNode);
                        AssignmentNode tempAssignNode = new AssignmentNode(tree, tempVarNode, expr);
                        tempAssignNode.setInSource(false);
                        this.extendWithNode(tempAssignNode);
                        IdentifierTree resultExpr = this.treeBuilder.buildVariableUse(tempVarDecl);
                        this.handleArtificialTree(resultExpr);
                        result = new LocalVariableNode(resultExpr);
                        result.setInSource(false);
                        this.extendWithNode(result);
                        break;
                    }
                    result = unaryAssign;
                    break;
                }
                default: {
                    if (tree.toString().startsWith("<*nullchk*>")) {
                        Node expr = (Node)this.scan(tree.getExpression(), p);
                        result = this.extendWithNode(new NullChkNode(tree, expr));
                        break;
                    }
                    assert (false) : "Unknown kind (" + (Object)((Object)kind) + ") of unary expression: " + tree;
                    break;
                }
            }
            return result;
        }

        private AssignmentNode createIncrementOrDecrementAssign(Tree target, Node expr, boolean isIncrement) {
            ExpressionTree exprTree = (ExpressionTree)expr.getTree();
            TypeMirror exprType = expr.getType();
            PrimitiveType oneType = this.types.getPrimitiveType(TypeKind.INT);
            TypeMirror promotedType = this.binaryPromotedType(exprType, oneType);
            LiteralTree oneTree = this.treeBuilder.buildLiteral((Object)1);
            this.handleArtificialTree(oneTree);
            Node exprRHS = this.binaryNumericPromotion(expr, promotedType);
            Node one = new IntegerLiteralNode(oneTree);
            one.setInSource(false);
            this.extendWithNode(one);
            one = this.binaryNumericPromotion(one, promotedType);
            BinaryTree operTree = this.treeBuilder.buildBinary(promotedType, isIncrement ? Tree.Kind.PLUS : Tree.Kind.MINUS, exprTree, (ExpressionTree)oneTree);
            this.handleArtificialTree(operTree);
            BinaryOperationNode operNode = isIncrement ? new NumericalAdditionNode(operTree, exprRHS, one) : new NumericalSubtractionNode(operTree, exprRHS, one);
            operNode.setInSource(false);
            this.extendWithNode(operNode);
            Node narrowed = this.narrowAndBox(operNode, exprType);
            if (target == null) {
                target = this.treeBuilder.buildAssignment(exprTree, (ExpressionTree)narrowed.getTree());
                this.handleArtificialTree(target);
            }
            AssignmentNode assignNode = new AssignmentNode(target, expr, narrowed);
            assignNode.setInSource(false);
            return this.extendWithNode(assignNode);
        }

        @Override
        public Node visitVariable(VariableTree tree, Void p) {
            boolean isField = this.getCurrentPath().getParentPath() != null && this.getCurrentPath().getParentPath().getLeaf().getKind() == Tree.Kind.CLASS;
            AssignmentNode node = null;
            ClassTree enclosingClass = TreeUtils.enclosingClass((TreePath)this.getCurrentPath());
            TypeElement classElem = TreeUtils.elementFromDeclaration((ClassTree)enclosingClass);
            ImplicitThisLiteralNode receiver = new ImplicitThisLiteralNode(classElem.asType());
            if (isField) {
                ExpressionTree initializer = tree.getInitializer();
                assert (initializer != null);
                node = this.translateAssignment((Tree)tree, (Node)new FieldAccessNode(tree, TreeUtils.elementFromDeclaration((VariableTree)tree), receiver), initializer);
            } else {
                VariableDeclarationNode decl = new VariableDeclarationNode(tree);
                this.extendWithNode(decl);
                ExpressionTree initializer = tree.getInitializer();
                if (initializer != null) {
                    node = this.translateAssignment((Tree)tree, (Node)new LocalVariableNode(tree, receiver), initializer);
                }
            }
            return node;
        }

        @Override
        public Node visitWhileLoop(WhileLoopTree tree, Void p) {
            Name parentLabel = this.getLabel(this.getCurrentPath());
            Label loopEntry = new Label();
            Label loopExit = new Label();
            Label conditionStart = parentLabel != null ? this.continueLabels.get(parentLabel) : new Label();
            TryFinallyScopeCell oldBreakTargetL = this.breakTargetL;
            this.breakTargetL = new TryFinallyScopeCell(loopExit);
            TryFinallyScopeCell oldContinueTargetL = this.continueTargetL;
            this.continueTargetL = new TryFinallyScopeCell(conditionStart);
            this.addLabelForNextNode(conditionStart);
            if (tree.getCondition() != null) {
                this.unbox((Node)this.scan(tree.getCondition(), p));
                ConditionalJump cjump = new ConditionalJump(loopEntry, loopExit);
                this.extendWithExtendedNode(cjump);
            }
            this.addLabelForNextNode(loopEntry);
            if (tree.getStatement() != null) {
                this.scan(tree.getStatement(), p);
            }
            this.extendWithExtendedNode(new UnconditionalJump(conditionStart));
            this.addLabelForNextNode(loopExit);
            this.breakTargetL = oldBreakTargetL;
            this.continueTargetL = oldContinueTargetL;
            return null;
        }

        @Override
        public Node visitLambdaExpression(LambdaExpressionTree tree, Void p) {
            CFGBuilder.this.declaredLambdas.add(tree);
            FunctionalInterfaceNode node = new FunctionalInterfaceNode(tree);
            this.extendWithNode(node);
            return node;
        }

        @Override
        public Node visitMemberReference(MemberReferenceTree tree, Void p) {
            ExpressionTree enclosingExpr = tree.getQualifierExpression();
            if (enclosingExpr != null) {
                this.scan(enclosingExpr, p);
            }
            FunctionalInterfaceNode node = new FunctionalInterfaceNode(tree);
            this.extendWithNode(node);
            return node;
        }

        @Override
        public Node visitWildcard(WildcardTree tree, Void p) {
            assert (false) : "WildcardTree is unexpected in AST to CFG translation";
            return null;
        }

        @Override
        public Node visitOther(Tree tree, Void p) {
            assert (false) : "Unknown AST element encountered in AST to CFG translation.";
            return null;
        }

        private class SwitchBuilder {
            private final SwitchTree switchTree;
            private final Label[] caseBodyLabels;
            private final Void p;
            private Node switchExpr;

            private SwitchBuilder(SwitchTree tree, Void p) {
                this.switchTree = tree;
                this.caseBodyLabels = new Label[this.switchTree.getCases().size() + 1];
                this.p = p;
            }

            public void build() {
                TryFinallyScopeCell oldBreakTargetL = CFGTranslationPhaseOne.this.breakTargetL;
                CFGTranslationPhaseOne.this.breakTargetL = new TryFinallyScopeCell(new Label());
                int cases = this.caseBodyLabels.length - 1;
                for (int i = 0; i < cases; ++i) {
                    this.caseBodyLabels[i] = new Label();
                }
                this.caseBodyLabels[cases] = CFGTranslationPhaseOne.this.breakTargetL.peekLabel();
                TypeMirror switchExprType = TreeUtils.typeOf((Tree)this.switchTree.getExpression());
                VariableTree variable = CFGTranslationPhaseOne.this.treeBuilder.buildVariableDecl(switchExprType, CFGTranslationPhaseOne.this.uniqueName("switch"), CFGTranslationPhaseOne.this.findOwner(), null);
                CFGTranslationPhaseOne.this.handleArtificialTree(variable);
                VariableDeclarationNode variableNode = new VariableDeclarationNode(variable);
                variableNode.setInSource(false);
                CFGTranslationPhaseOne.this.extendWithNode(variableNode);
                IdentifierTree variableUse = CFGTranslationPhaseOne.this.treeBuilder.buildVariableUse(variable);
                CFGTranslationPhaseOne.this.handleArtificialTree(variable);
                LocalVariableNode variableUseNode = new LocalVariableNode(variableUse);
                variableUseNode.setInSource(false);
                CFGTranslationPhaseOne.this.extendWithNode(variableUseNode);
                Node switchExprNode = CFGTranslationPhaseOne.this.unbox((Node)CFGTranslationPhaseOne.this.scan(this.switchTree.getExpression(), this.p));
                AssignmentTree assign = CFGTranslationPhaseOne.this.treeBuilder.buildAssignment((ExpressionTree)variableUse, this.switchTree.getExpression());
                CFGTranslationPhaseOne.this.handleArtificialTree(assign);
                this.switchExpr = new AssignmentNode(assign, variableUseNode, switchExprNode);
                this.switchExpr.setInSource(false);
                CFGTranslationPhaseOne.this.extendWithNode(this.switchExpr);
                CFGTranslationPhaseOne.this.extendWithNode(new MarkerNode(this.switchTree, "start of switch statement", CFGTranslationPhaseOne.this.env.getTypeUtils()));
                Integer defaultIndex = null;
                for (int i = 0; i < cases; ++i) {
                    CaseTree caseTree = this.switchTree.getCases().get(i);
                    if (caseTree.getExpression() == null) {
                        defaultIndex = i;
                        continue;
                    }
                    this.buildCase(caseTree, i);
                }
                if (defaultIndex != null) {
                    this.buildCase(this.switchTree.getCases().get(defaultIndex), defaultIndex);
                }
                CFGTranslationPhaseOne.this.addLabelForNextNode(CFGTranslationPhaseOne.this.breakTargetL.peekLabel());
                CFGTranslationPhaseOne.this.breakTargetL = oldBreakTargetL;
            }

            private void buildCase(CaseTree tree, int index) {
                Label thisBodyL = this.caseBodyLabels[index];
                Label nextBodyL = this.caseBodyLabels[index + 1];
                Label nextCaseL = new Label();
                ExpressionTree exprTree = tree.getExpression();
                if (exprTree != null) {
                    Node expr = (Node)CFGTranslationPhaseOne.this.scan(exprTree, this.p);
                    CaseNode caseNode = new CaseNode(tree, this.switchExpr, expr, CFGTranslationPhaseOne.this.env.getTypeUtils());
                    CFGTranslationPhaseOne.this.extendWithNode(caseNode);
                    CFGTranslationPhaseOne.this.extendWithExtendedNode(new ConditionalJump(thisBodyL, nextCaseL));
                }
                CFGTranslationPhaseOne.this.addLabelForNextNode(thisBodyL);
                for (StatementTree statementTree : tree.getStatements()) {
                    CFGTranslationPhaseOne.this.scan(statementTree, this.p);
                }
                CFGTranslationPhaseOne.this.extendWithExtendedNode(new UnconditionalJump(nextBodyL));
                CFGTranslationPhaseOne.this.addLabelForNextNode(nextCaseL);
            }
        }
    }

    protected static class PhaseOneResult {
        private final IdentityHashMap<Tree, Set<Node>> treeLookupMap;
        private final IdentityHashMap<Tree, Set<Node>> convertedTreeLookupMap;
        private final IdentityHashMap<UnaryTree, AssignmentNode> unaryAssignNodeLookupMap;
        private final UnderlyingAST underlyingAST;
        private final Map<Label, Integer> bindings;
        private final ArrayList<ExtendedNode> nodeList;
        private final Set<Integer> leaders;
        private final List<ReturnNode> returnNodes;

        public PhaseOneResult(UnderlyingAST underlyingAST, IdentityHashMap<Tree, Set<Node>> treeLookupMap, IdentityHashMap<Tree, Set<Node>> convertedTreeLookupMap, IdentityHashMap<UnaryTree, AssignmentNode> unaryAssignNodeLookupMap, ArrayList<ExtendedNode> nodeList, Map<Label, Integer> bindings, Set<Integer> leaders, List<ReturnNode> returnNodes) {
            this.underlyingAST = underlyingAST;
            this.treeLookupMap = treeLookupMap;
            this.convertedTreeLookupMap = convertedTreeLookupMap;
            this.unaryAssignNodeLookupMap = unaryAssignNodeLookupMap;
            this.nodeList = nodeList;
            this.bindings = bindings;
            this.leaders = leaders;
            this.returnNodes = returnNodes;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (ExtendedNode n : this.nodeList) {
                sb.append(this.nodeToString(n));
                sb.append("\n");
            }
            return sb.toString();
        }

        protected String nodeToString(ExtendedNode n) {
            if (n.getType() == ExtendedNode.ExtendedNodeType.CONDITIONAL_JUMP) {
                ConditionalJump t = (ConditionalJump)n;
                return "TwoTargetConditionalJump(" + this.resolveLabel(t.getThenLabel()) + "," + this.resolveLabel(t.getElseLabel()) + ")";
            }
            if (n.getType() == ExtendedNode.ExtendedNodeType.UNCONDITIONAL_JUMP) {
                return "UnconditionalJump(" + this.resolveLabel(n.getLabel()) + ")";
            }
            return n.toString();
        }

        private String resolveLabel(Label label) {
            Integer index = this.bindings.get(label);
            if (index == null) {
                return "null";
            }
            return this.nodeToString(this.nodeList.get(index));
        }
    }

    public class CFGTranslationPhaseTwo {
        public ControlFlowGraph process(PhaseOneResult in) {
            Map bindings = in.bindings;
            ArrayList nodeList = in.nodeList;
            Set leaders = in.leaders;
            assert (in.nodeList.size() > 0);
            SpecialBlockImpl regularExitBlock = new SpecialBlockImpl(SpecialBlock.SpecialBlockType.EXIT);
            SpecialBlockImpl exceptionalExitBlock = new SpecialBlockImpl(SpecialBlock.SpecialBlockType.EXCEPTIONAL_EXIT);
            MostlySingleton missingEdges = new MostlySingleton();
            HashSet<Tuple<ExceptionBlockImpl, Integer, TypeMirror>> missingExceptionalEdges = new HashSet<Tuple<ExceptionBlockImpl, Integer, TypeMirror>>();
            SpecialBlockImpl startBlock = new SpecialBlockImpl(SpecialBlock.SpecialBlockType.ENTRY);
            missingEdges.add(new Tuple(startBlock, 0));
            RegularBlockImpl block = new RegularBlockImpl();
            int i = 0;
            for (ExtendedNode extendedNode : nodeList) {
                switch (extendedNode.getType()) {
                    case NODE: {
                        if (leaders.contains(i)) {
                            RegularBlockImpl b = new RegularBlockImpl();
                            block.setSuccessor(b);
                            block = b;
                        }
                        block.addNode(extendedNode.getNode());
                        extendedNode.setBlock(block);
                        boolean terminatesExecution = extendedNode.getTerminatesExecution();
                        if (!terminatesExecution) break;
                        block.setSuccessor(exceptionalExitBlock);
                        block = new RegularBlockImpl();
                        break;
                    }
                    case CONDITIONAL_JUMP: {
                        ConditionalJump cj = (ConditionalJump)extendedNode;
                        extendedNode.setBlock(block);
                        assert (block != null);
                        final ConditionalBlockImpl cb = new ConditionalBlockImpl();
                        if (cj.getTrueFlowRule() != null) {
                            cb.setThenFlowRule(cj.getTrueFlowRule());
                        }
                        if (cj.getFalseFlowRule() != null) {
                            cb.setElseFlowRule(cj.getFalseFlowRule());
                        }
                        block.setSuccessor(cb);
                        block = new RegularBlockImpl();
                        Label thenLabel = cj.getThenLabel();
                        Label elseLabel = cj.getElseLabel();
                        Integer n = (Integer)bindings.get(thenLabel);
                        assert (n != null);
                        missingEdges.add(new Tuple(new SingleSuccessorBlockImpl(Block.BlockType.REGULAR_BLOCK){

                            @Override
                            public void setSuccessor(BlockImpl successor) {
                                cb.setThenSuccessor(successor);
                            }
                        }, n));
                        Integer n2 = (Integer)bindings.get(elseLabel);
                        assert (n2 != null);
                        missingEdges.add(new Tuple(new SingleSuccessorBlockImpl(Block.BlockType.REGULAR_BLOCK){

                            @Override
                            public void setSuccessor(BlockImpl successor) {
                                cb.setElseSuccessor(successor);
                            }
                        }, n2));
                        break;
                    }
                    case UNCONDITIONAL_JUMP: {
                        if (leaders.contains(i)) {
                            RegularBlockImpl b = new RegularBlockImpl();
                            block.setSuccessor(b);
                            block = b;
                        }
                        extendedNode.setBlock(block);
                        if (extendedNode.getLabel() == CFGBuilder.this.regularExitLabel) {
                            block.setSuccessor(regularExitBlock);
                        } else if (extendedNode.getLabel() == CFGBuilder.this.exceptionalExitLabel) {
                            block.setSuccessor(exceptionalExitBlock);
                        } else {
                            Integer target = (Integer)bindings.get(extendedNode.getLabel());
                            assert (target != null);
                            missingEdges.add(new Tuple(block, target));
                        }
                        block = new RegularBlockImpl();
                        break;
                    }
                    case EXCEPTION_NODE: {
                        NodeWithExceptionsHolder en = (NodeWithExceptionsHolder)extendedNode;
                        ExceptionBlockImpl e = new ExceptionBlockImpl();
                        Node nn = en.getNode();
                        e.setNode(nn);
                        extendedNode.setBlock(e);
                        block.setSuccessor(e);
                        block = new RegularBlockImpl();
                        if (!extendedNode.getTerminatesExecution()) {
                            missingEdges.add(new Tuple(e, i + 1));
                        }
                        for (Map.Entry entry : en.getExceptions().entrySet()) {
                            TypeMirror cause = (TypeMirror)entry.getKey();
                            for (Label label : (Set)entry.getValue()) {
                                Integer target = (Integer)bindings.get(label);
                                missingExceptionalEdges.add(new Tuple<ExceptionBlockImpl, Integer, TypeMirror>(e, target, cause));
                            }
                        }
                        break;
                    }
                }
                ++i;
            }
            for (Tuple tuple : missingEdges) {
                Integer index = (Integer)tuple.b;
                assert (index != null) : "CFGBuilder: problem in CFG construction " + tuple.a;
                ExtendedNode extendedNode = (ExtendedNode)nodeList.get(index);
                BlockImpl target = extendedNode.getBlock();
                SingleSuccessorBlockImpl source = (SingleSuccessorBlockImpl)tuple.a;
                source.setSuccessor(target);
            }
            for (Tuple tuple : missingExceptionalEdges) {
                Integer index = (Integer)tuple.b;
                TypeMirror cause = (TypeMirror)tuple.c;
                ExceptionBlockImpl source = (ExceptionBlockImpl)tuple.a;
                if (index == null) {
                    source.addExceptionalSuccessor(exceptionalExitBlock, cause);
                    continue;
                }
                ExtendedNode extendedNode = (ExtendedNode)nodeList.get(index);
                BlockImpl target = extendedNode.getBlock();
                source.addExceptionalSuccessor(target, cause);
            }
            return new ControlFlowGraph(startBlock, regularExitBlock, exceptionalExitBlock, in.underlyingAST, in.treeLookupMap, in.convertedTreeLookupMap, in.unaryAssignNodeLookupMap, in.returnNodes);
        }
    }

    protected static class Tuple<A, B, C> {
        public final A a;
        public final B b;
        public final C c;

        public Tuple(A a, B b) {
            this(a, b, null);
        }

        public Tuple(A a, B b, C c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public String toString() {
            return "Tuple<" + this.a + ", " + this.b + ", " + this.c + ">";
        }
    }

    public static class CFGTranslationPhaseThree {
        public static ControlFlowGraph process(ControlFlowGraph cfg) {
            RegularBlockImpl b;
            BlockImpl cur;
            Set<Block> worklist = cfg.getAllBlocks();
            HashSet<BlockImpl> dontVisit = new HashSet<BlockImpl>();
            for (Block c : worklist) {
                cur = (BlockImpl)c;
                for (BlockImpl pred : new HashSet<BlockImpl>(cur.getPredecessors())) {
                    if (worklist.contains(pred)) continue;
                    cur.removePredecessor(pred);
                }
            }
            for (Block cur2 : worklist) {
                if (dontVisit.contains(cur2) || cur2.getType() != Block.BlockType.REGULAR_BLOCK || !(b = (RegularBlockImpl)cur2).isEmpty()) continue;
                HashSet<RegularBlockImpl> empty = new HashSet<RegularBlockImpl>();
                HashSet<PredecessorHolder> predecessors = new HashSet<PredecessorHolder>();
                BlockImpl succ = CFGTranslationPhaseThree.computeNeighborhoodOfEmptyBlock(b, empty, predecessors);
                for (RegularBlockImpl e : empty) {
                    succ.removePredecessor(e);
                    dontVisit.add(e);
                }
                for (PredecessorHolder p : predecessors) {
                    BlockImpl block = p.getBlock();
                    dontVisit.add(block);
                    succ.removePredecessor(block);
                    p.setSuccessor(succ);
                }
            }
            worklist = cfg.getAllBlocks();
            for (Block c : worklist) {
                BlockImpl pred;
                cur = (BlockImpl)c;
                if (cur.getType() != Block.BlockType.CONDITIONAL_BLOCK) continue;
                ConditionalBlockImpl cb = (ConditionalBlockImpl)cur;
                assert (cb.getPredecessors().size() == 1);
                if (cb.getThenSuccessor() != cb.getElseSuccessor()) continue;
                pred = cb.getPredecessors().iterator().next();
                PredecessorHolder predecessorHolder = CFGTranslationPhaseThree.getPredecessorHolder(pred, cb);
                BlockImpl succ = (BlockImpl)cb.getThenSuccessor();
                succ.removePredecessor(cb);
                predecessorHolder.setSuccessor(succ);
            }
            worklist = cfg.getAllBlocks();
            for (Block cur2 : worklist) {
                RegularBlockImpl rs;
                BlockImpl succ;
                if (cur2.getType() != Block.BlockType.REGULAR_BLOCK || (succ = (b = (RegularBlockImpl)cur2).getRegularSuccessor()).getType() != Block.BlockType.REGULAR_BLOCK || (rs = (RegularBlockImpl)succ).getPredecessors().size() != 1) continue;
                b.setSuccessor(rs.getRegularSuccessor());
                b.addNodes(rs.getContents());
                rs.getRegularSuccessor().removePredecessor(rs);
            }
            return cfg;
        }

        protected static BlockImpl computeNeighborhoodOfEmptyBlock(RegularBlockImpl start, Set<RegularBlockImpl> empty, Set<PredecessorHolder> predecessors) {
            RegularBlockImpl cur;
            CFGTranslationPhaseThree.computeNeighborhoodOfEmptyBlockBackwards(start, empty, predecessors);
            BlockImpl succ = (BlockImpl)start.getSuccessor();
            while (succ.getType() == Block.BlockType.REGULAR_BLOCK && (cur = (RegularBlockImpl)succ).isEmpty()) {
                CFGTranslationPhaseThree.computeNeighborhoodOfEmptyBlockBackwards(cur, empty, predecessors);
                assert (empty.contains(cur)) : "cur ought to be in empty";
                succ = (BlockImpl)cur.getSuccessor();
                if (succ != cur) continue;
                break;
            }
            return succ;
        }

        protected static void computeNeighborhoodOfEmptyBlockBackwards(RegularBlockImpl start, Set<RegularBlockImpl> empty, Set<PredecessorHolder> predecessors) {
            RegularBlockImpl cur = start;
            empty.add(cur);
            for (BlockImpl pred : cur.getPredecessors()) {
                switch (pred.getType()) {
                    case SPECIAL_BLOCK: {
                        predecessors.add(CFGTranslationPhaseThree.getPredecessorHolder(pred, cur));
                        break;
                    }
                    case CONDITIONAL_BLOCK: {
                        predecessors.add(CFGTranslationPhaseThree.getPredecessorHolder(pred, cur));
                        break;
                    }
                    case EXCEPTION_BLOCK: {
                        predecessors.add(CFGTranslationPhaseThree.getPredecessorHolder(pred, cur));
                        break;
                    }
                    case REGULAR_BLOCK: {
                        RegularBlockImpl r = (RegularBlockImpl)pred;
                        if (r.isEmpty()) {
                            if (empty.contains(r)) break;
                            CFGTranslationPhaseThree.computeNeighborhoodOfEmptyBlockBackwards(r, empty, predecessors);
                            break;
                        }
                        predecessors.add(CFGTranslationPhaseThree.getPredecessorHolder(pred, cur));
                    }
                }
            }
        }

        protected static PredecessorHolder getPredecessorHolder(final BlockImpl pred, final BlockImpl cur) {
            switch (pred.getType()) {
                case SPECIAL_BLOCK: {
                    SingleSuccessorBlockImpl s = (SingleSuccessorBlockImpl)pred;
                    return CFGTranslationPhaseThree.singleSuccessorHolder(s, cur);
                }
                case CONDITIONAL_BLOCK: {
                    final ConditionalBlockImpl c = (ConditionalBlockImpl)pred;
                    if (c.getThenSuccessor() == cur) {
                        return new PredecessorHolder(){

                            @Override
                            public void setSuccessor(BlockImpl b) {
                                c.setThenSuccessor(b);
                                cur.removePredecessor(pred);
                            }

                            @Override
                            public BlockImpl getBlock() {
                                return c;
                            }
                        };
                    }
                    assert (c.getElseSuccessor() == cur);
                    return new PredecessorHolder(){

                        @Override
                        public void setSuccessor(BlockImpl b) {
                            c.setElseSuccessor(b);
                            cur.removePredecessor(pred);
                        }

                        @Override
                        public BlockImpl getBlock() {
                            return c;
                        }
                    };
                }
                case EXCEPTION_BLOCK: {
                    final ExceptionBlockImpl e = (ExceptionBlockImpl)pred;
                    if (e.getSuccessor() == cur) {
                        return CFGTranslationPhaseThree.singleSuccessorHolder(e, cur);
                    }
                    Set<Map.Entry<TypeMirror, Set<Block>>> entrySet = e.getExceptionalSuccessors().entrySet();
                    for (final Map.Entry<TypeMirror, Set<Block>> entry : entrySet) {
                        if (!entry.getValue().contains(cur)) continue;
                        return new PredecessorHolder(){

                            @Override
                            public void setSuccessor(BlockImpl b) {
                                e.addExceptionalSuccessor(b, (TypeMirror)entry.getKey());
                                cur.removePredecessor(pred);
                            }

                            @Override
                            public BlockImpl getBlock() {
                                return e;
                            }
                        };
                    }
                    assert (false);
                    break;
                }
                case REGULAR_BLOCK: {
                    RegularBlockImpl r = (RegularBlockImpl)pred;
                    return CFGTranslationPhaseThree.singleSuccessorHolder(r, cur);
                }
            }
            return null;
        }

        protected static PredecessorHolder singleSuccessorHolder(final SingleSuccessorBlockImpl s, final BlockImpl old) {
            return new PredecessorHolder(){

                @Override
                public void setSuccessor(BlockImpl b) {
                    s.setSuccessor(b);
                    old.removePredecessor(s);
                }

                @Override
                public BlockImpl getBlock() {
                    return s;
                }
            };
        }

        protected static interface PredecessorHolder {
            public void setSuccessor(BlockImpl var1);

            public BlockImpl getBlock();
        }
    }

    protected static class TryFinallyScopeCell {
        private Label label;
        private boolean accessed;

        protected TryFinallyScopeCell() {
            this.label = null;
            this.accessed = false;
        }

        protected TryFinallyScopeCell(Label label) {
            assert (label != null);
            this.label = label;
            this.accessed = false;
        }

        public Label accessLabel() {
            if (this.label == null) {
                this.label = new Label();
            }
            this.accessed = true;
            return this.label;
        }

        public Label peekLabel() {
            assert (this.label != null);
            return this.label;
        }

        public boolean wasAccessed() {
            return this.accessed;
        }
    }

    protected static class TryFinallyScopeMap
    extends HashMap<Name, Label> {
        private final Map<Name, Label> accessedNames = new HashMap<Name, Label>();

        protected TryFinallyScopeMap() {
        }

        @Override
        public Label get(Object key) {
            if (super.containsKey(key)) {
                return (Label)super.get(key);
            }
            if (this.accessedNames.containsKey(key)) {
                return this.accessedNames.get(key);
            }
            Label l = new Label();
            this.accessedNames.put((Name)key, l);
            return l;
        }

        @Override
        public boolean containsKey(Object key) {
            return true;
        }

        public Map<Name, Label> getAccessedNames() {
            return this.accessedNames;
        }
    }

    protected static class TryStack {
        protected Label exitLabel;
        protected ArrayDeque<TryFrame> frames;

        public TryStack(Label exitLabel) {
            this.exitLabel = exitLabel;
            this.frames = new ArrayDeque();
        }

        public void pushFrame(TryFrame frame) {
            this.frames.addFirst(frame);
        }

        public void popFrame() {
            this.frames.removeFirst();
        }

        public Set<Label> possibleLabels(TypeMirror thrown) {
            MostlySingleton<Label> labels = new MostlySingleton<Label>();
            for (TryFrame frame : this.frames) {
                if (!frame.possibleLabels(thrown, labels)) continue;
                return labels;
            }
            labels.add(this.exitLabel);
            return labels;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("TryStack: exitLabel: " + this.exitLabel + '\n');
            if (this.frames.isEmpty()) {
                sb.append("No TryFrames.\n");
            }
            for (TryFrame tf : this.frames) {
                sb.append(tf.toString());
            }
            return sb.toString();
        }
    }

    protected static class TryFinallyFrame
    implements TryFrame {
        protected Label finallyLabel;

        public TryFinallyFrame(Label finallyLabel) {
            this.finallyLabel = finallyLabel;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("TryFinallyFrame: finallyLabel: " + this.finallyLabel + '\n');
            return sb.toString();
        }

        @Override
        public boolean possibleLabels(TypeMirror thrown, Set<Label> labels) {
            labels.add(this.finallyLabel);
            return true;
        }
    }

    protected static class TryCatchFrame
    implements TryFrame {
        protected Types types;
        protected List<Pair<TypeMirror, Label>> catchLabels;

        public TryCatchFrame(Types types, List<Pair<TypeMirror, Label>> catchLabels) {
            this.types = types;
            this.catchLabels = catchLabels;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.catchLabels.isEmpty()) {
                sb.append("TryCatchFrame: no catch labels.\n");
            } else {
                sb.append("TryCatchFrame: ");
            }
            for (Pair<TypeMirror, Label> ptml : this.catchLabels) {
                sb.append(((TypeMirror)ptml.first).toString());
                sb.append(" -> ");
                sb.append(((Label)ptml.second).toString());
                sb.append('\n');
            }
            return sb.toString();
        }

        @Override
        public boolean possibleLabels(TypeMirror thrown, Set<Label> labels) {
            while (!(thrown instanceof DeclaredType)) {
                assert (thrown instanceof TypeVariable) : "thrown type must be a variable or a declared type";
                thrown = ((TypeVariable)thrown).getUpperBound();
            }
            DeclaredType declaredThrown = (DeclaredType)thrown;
            assert (thrown != null) : "thrown type must be bounded by a declared type";
            for (Pair<TypeMirror, Label> pair : this.catchLabels) {
                TypeMirror caught = (TypeMirror)pair.first;
                boolean canApply = false;
                if (caught instanceof DeclaredType) {
                    DeclaredType declaredCaught = (DeclaredType)caught;
                    if (this.types.isSubtype(declaredThrown, declaredCaught)) {
                        labels.add((Label)pair.second);
                        return true;
                    }
                    if (this.types.isSubtype(declaredCaught, declaredThrown)) {
                        canApply = true;
                    }
                } else {
                    assert (caught instanceof UnionType) : "caught type must be a union or a declared type";
                    UnionType caughtUnion = (UnionType)caught;
                    for (TypeMirror typeMirror : caughtUnion.getAlternatives()) {
                        assert (typeMirror instanceof DeclaredType) : "alternatives of an caught union type must be declared types";
                        DeclaredType declaredAlt = (DeclaredType)typeMirror;
                        if (this.types.isSubtype(declaredThrown, declaredAlt)) {
                            labels.add((Label)pair.second);
                            return true;
                        }
                        if (!this.types.isSubtype(declaredAlt, declaredThrown)) continue;
                        canApply = true;
                    }
                }
                if (!canApply) continue;
                labels.add((Label)pair.second);
            }
            return false;
        }
    }

    protected static interface TryFrame {
        public boolean possibleLabels(TypeMirror var1, Set<Label> var2);
    }

    protected static class Label {
        private static int uid = 0;
        protected final String name;

        public Label(String name) {
            this.name = name;
        }

        public Label() {
            this.name = Label.uniqueName();
        }

        public String toString() {
            return this.name;
        }

        private static String uniqueName() {
            return "%L" + uid++;
        }
    }

    protected static class UnconditionalJump
    extends ExtendedNode {
        protected Label jumpTarget;

        public UnconditionalJump(Label jumpTarget) {
            super(ExtendedNode.ExtendedNodeType.UNCONDITIONAL_JUMP);
            assert (jumpTarget != null);
            this.jumpTarget = jumpTarget;
        }

        @Override
        public Label getLabel() {
            return this.jumpTarget;
        }

        @Override
        public String toString() {
            return "JumpMarker(" + this.getLabel() + ")";
        }
    }

    protected static class ConditionalJump
    extends ExtendedNode {
        protected Label trueSucc;
        protected Label falseSucc;
        protected Store.FlowRule trueFlowRule;
        protected Store.FlowRule falseFlowRule;

        public ConditionalJump(Label trueSucc, Label falseSucc) {
            super(ExtendedNode.ExtendedNodeType.CONDITIONAL_JUMP);
            assert (trueSucc != null);
            this.trueSucc = trueSucc;
            assert (falseSucc != null);
            this.falseSucc = falseSucc;
        }

        public Label getThenLabel() {
            return this.trueSucc;
        }

        public Label getElseLabel() {
            return this.falseSucc;
        }

        public Store.FlowRule getTrueFlowRule() {
            return this.trueFlowRule;
        }

        public Store.FlowRule getFalseFlowRule() {
            return this.falseFlowRule;
        }

        public void setTrueFlowRule(Store.FlowRule rule) {
            this.trueFlowRule = rule;
        }

        public void setFalseFlowRule(Store.FlowRule rule) {
            this.falseFlowRule = rule;
        }

        @Override
        public String toString() {
            return "TwoTargetConditionalJump(" + this.getThenLabel() + "," + this.getElseLabel() + ")";
        }
    }

    protected static class NodeWithExceptionsHolder
    extends ExtendedNode {
        protected Node node;
        protected Map<TypeMirror, Set<Label>> exceptions;

        public NodeWithExceptionsHolder(Node node, Map<TypeMirror, Set<Label>> exceptions) {
            super(ExtendedNode.ExtendedNodeType.EXCEPTION_NODE);
            this.node = node;
            this.exceptions = exceptions;
        }

        public Map<TypeMirror, Set<Label>> getExceptions() {
            return this.exceptions;
        }

        @Override
        public Node getNode() {
            return this.node;
        }

        @Override
        public String toString() {
            return "NodeWithExceptionsHolder(" + this.node + ")";
        }
    }

    protected static class NodeHolder
    extends ExtendedNode {
        protected Node node;

        public NodeHolder(Node node) {
            super(ExtendedNode.ExtendedNodeType.NODE);
            this.node = node;
        }

        @Override
        public Node getNode() {
            return this.node;
        }

        @Override
        public String toString() {
            return "NodeHolder(" + this.node + ")";
        }
    }

    protected static abstract class ExtendedNode {
        protected BlockImpl block;
        protected ExtendedNodeType type;
        protected boolean terminatesExecution = false;

        public ExtendedNode(ExtendedNodeType type) {
            this.type = type;
        }

        public ExtendedNodeType getType() {
            return this.type;
        }

        public boolean getTerminatesExecution() {
            return this.terminatesExecution;
        }

        public void setTerminatesExecution(boolean terminatesExecution) {
            this.terminatesExecution = terminatesExecution;
        }

        public Node getNode() {
            assert (false);
            return null;
        }

        public Label getLabel() {
            assert (false);
            return null;
        }

        public BlockImpl getBlock() {
            return this.block;
        }

        public void setBlock(BlockImpl b) {
            this.block = b;
        }

        public String toString() {
            return "ExtendedNode(" + (Object)((Object)this.type) + ")";
        }

        public static enum ExtendedNodeType {
            NODE,
            EXCEPTION_NODE,
            UNCONDITIONAL_JUMP,
            CONDITIONAL_JUMP;

        }
    }
}

