/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.FailureStrategy;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import java.util.OptionalInt;
import javax.annotation.Nullable;

public final class OptionalIntSubject
extends Subject<OptionalIntSubject, OptionalInt> {
    private static final SubjectFactory<OptionalIntSubject, OptionalInt> FACTORY = new SubjectFactory<OptionalIntSubject, OptionalInt>(){

        public OptionalIntSubject getSubject(FailureStrategy fs, OptionalInt target) {
            return new OptionalIntSubject(fs, target);
        }
    };

    OptionalIntSubject(FailureStrategy failureStrategy, @Nullable OptionalInt subject) {
        super(failureStrategy, (Object)subject);
    }

    public void isPresent() {
        if (this.actual() == null || !((OptionalInt)this.actual()).isPresent()) {
            this.failWithoutActual("is present");
        }
    }

    public void isEmpty() {
        if (this.actual() == null || ((OptionalInt)this.actual()).isPresent()) {
            this.fail("is empty");
        }
    }

    public void hasValue(int expected) {
        if (this.actual() == null || !((OptionalInt)this.actual()).isPresent()) {
            this.fail("has value", expected);
        } else {
            int actual = ((OptionalInt)this.actual()).getAsInt();
            if (actual != expected) {
                this.fail("has value", expected);
            }
        }
    }

    public IntegerSubject hasValueThat() {
        if (this.actual() == null || !((OptionalInt)this.actual()).isPresent()) {
            this.failWithoutActual("is present");
            return this.ignoreCheck().that(Integer.valueOf(0));
        }
        return this.check().that(Integer.valueOf(((OptionalInt)this.actual()).getAsInt()));
    }

    public static SubjectFactory<OptionalIntSubject, OptionalInt> optionalInts() {
        return FACTORY;
    }
}

