/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.description.modifier.EnumerationState;
import net.bytebuddy.description.modifier.SyntheticState;
import net.bytebuddy.description.modifier.TypeManifestation;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.generic.GenericTypeDescription;
import net.bytebuddy.utility.RandomString;

public interface NamingStrategy {
    public String name(UnnamedType var1);

    public static class Fixed
    implements NamingStrategy {
        private final String name;

        public Fixed(String name) {
            this.name = name;
        }

        @Override
        public String name(UnnamedType unnamedType) {
            return this.name;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.name.equals(((Fixed)other).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return "NamingStrategy.Fixed{name='" + this.name + '\'' + '}';
        }
    }

    public static class PrefixingRandom
    implements NamingStrategy {
        private final String prefix;
        private final RandomString randomString;

        public PrefixingRandom(String prefix) {
            this.prefix = prefix;
            this.randomString = new RandomString();
        }

        @Override
        public String name(UnnamedType unnamedType) {
            return String.format("%s.%s$%s", this.prefix, unnamedType.getSuperClass().asErasure().getName(), this.randomString.nextString());
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.prefix.equals(((PrefixingRandom)other).prefix);
        }

        public int hashCode() {
            return this.prefix.hashCode();
        }

        public String toString() {
            return "NamingStrategy.PrefixingRandom{prefix='" + this.prefix + '\'' + ", randomString=" + this.randomString + '}';
        }
    }

    public static class SuffixingRandom
    implements NamingStrategy {
        public static final String BYTE_BUDDY_RENAME_PACKAGE = "net.bytebuddy.renamed";
        private static final String JAVA_PACKAGE = "java.";
        private final String suffix;
        private final String javaLangPackagePrefix;
        private final RandomString randomString;
        private final BaseNameResolver baseNameResolver;

        public SuffixingRandom(String suffix) {
            this(suffix, BaseNameResolver.ForUnnamedType.INSTANCE, BYTE_BUDDY_RENAME_PACKAGE);
        }

        public SuffixingRandom(String suffix, BaseNameResolver baseNameResolver) {
            this(suffix, baseNameResolver, BYTE_BUDDY_RENAME_PACKAGE);
        }

        public SuffixingRandom(String suffix, BaseNameResolver baseNameResolver, String javaLangPackagePrefix) {
            this.suffix = suffix;
            this.baseNameResolver = baseNameResolver;
            this.javaLangPackagePrefix = javaLangPackagePrefix;
            this.randomString = new RandomString();
        }

        @Override
        public String name(UnnamedType unnamedType) {
            String baseName = this.baseNameResolver.resolve(unnamedType);
            if (baseName.startsWith(JAVA_PACKAGE)) {
                baseName = this.javaLangPackagePrefix + "." + baseName;
            }
            return String.format("%s$%s$%s", baseName, this.suffix, this.randomString.nextString());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            SuffixingRandom that = (SuffixingRandom)other;
            return this.javaLangPackagePrefix.equals(that.javaLangPackagePrefix) && this.suffix.equals(that.suffix) && this.baseNameResolver.equals(that.baseNameResolver);
        }

        public int hashCode() {
            int result = this.suffix.hashCode();
            result = 31 * result + this.javaLangPackagePrefix.hashCode();
            result = 31 * result + this.baseNameResolver.hashCode();
            return result;
        }

        public String toString() {
            return "NamingStrategy.SuffixingRandom{suffix='" + this.suffix + '\'' + ", javaLangPackagePrefix='" + this.javaLangPackagePrefix + '\'' + ", baseNameResolver=" + this.baseNameResolver + ", randomString=" + this.randomString + '}';
        }

        public static interface BaseNameResolver {
            public String resolve(UnnamedType var1);

            public static class ForFixedValue
            implements BaseNameResolver {
                private final String name;

                public ForFixedValue(String name) {
                    this.name = name;
                }

                @Override
                public String resolve(UnnamedType unnamedType) {
                    return this.name;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.name.equals(((ForFixedValue)other).name);
                }

                public int hashCode() {
                    return this.name.hashCode();
                }

                public String toString() {
                    return "NamingStrategy.SuffixingRandom.BaseNameResolver.ForFixedValue{name='" + this.name + '\'' + '}';
                }
            }

            public static class ForGivenType
            implements BaseNameResolver {
                private final TypeDescription typeDescription;

                public ForGivenType(TypeDescription typeDescription) {
                    this.typeDescription = typeDescription;
                }

                @Override
                public String resolve(UnnamedType unnamedType) {
                    return this.typeDescription.getName();
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.typeDescription.equals(((ForGivenType)other).typeDescription);
                }

                public int hashCode() {
                    return this.typeDescription.hashCode();
                }

                public String toString() {
                    return "NamingStrategy.SuffixingRandom.BaseNameResolver.ForGivenType{typeDescription=" + this.typeDescription + '}';
                }
            }

            public static enum ForUnnamedType implements BaseNameResolver
            {
                INSTANCE;


                @Override
                public String resolve(UnnamedType unnamedType) {
                    return unnamedType.getSuperClass().asErasure().getName();
                }

                public String toString() {
                    return "NamingStrategy.SuffixingRandom.BaseNameResolver.ForUnnamedType." + this.name();
                }
            }
        }
    }

    public static interface Unbound {
        public NamingStrategy subclass(TypeDescription var1);

        public NamingStrategy redefine(TypeDescription var1);

        public NamingStrategy rebase(TypeDescription var1);

        public NamingStrategy create();

        public static class Unified
        implements Unbound {
            private final NamingStrategy namingStrategy;

            public Unified(NamingStrategy namingStrategy) {
                this.namingStrategy = namingStrategy;
            }

            @Override
            public NamingStrategy subclass(TypeDescription typeDescription) {
                return this.namingStrategy;
            }

            @Override
            public NamingStrategy redefine(TypeDescription typeDescription) {
                return this.namingStrategy;
            }

            @Override
            public NamingStrategy rebase(TypeDescription typeDescription) {
                return this.namingStrategy;
            }

            @Override
            public NamingStrategy create() {
                return this.namingStrategy;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.namingStrategy.equals(((Unified)other).namingStrategy);
            }

            public int hashCode() {
                return this.namingStrategy.hashCode();
            }

            public String toString() {
                return "NamingStrategy.Unbound.Unified{namingStrategy=" + this.namingStrategy + '}';
            }
        }

        public static class Default
        implements Unbound {
            public static final String CREATION_NAME = "net.bytebuddy.generated.Type";
            private final String suffix;

            public Default(String suffix) {
                this.suffix = suffix;
            }

            @Override
            public NamingStrategy subclass(TypeDescription typeDescription) {
                return new SuffixingRandom(this.suffix, new SuffixingRandom.BaseNameResolver.ForGivenType(typeDescription));
            }

            @Override
            public NamingStrategy redefine(TypeDescription typeDescription) {
                return new Fixed(typeDescription.getName());
            }

            @Override
            public NamingStrategy rebase(TypeDescription typeDescription) {
                return new Fixed(typeDescription.getName());
            }

            @Override
            public NamingStrategy create() {
                return new SuffixingRandom(this.suffix, new SuffixingRandom.BaseNameResolver.ForFixedValue(CREATION_NAME));
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.suffix.equals(((Default)other).suffix);
            }

            public int hashCode() {
                return this.suffix.hashCode();
            }

            public String toString() {
                return "NamingStrategy.Unbound.Default{suffix='" + this.suffix + '\'' + '}';
            }
        }
    }

    public static interface UnnamedType {
        public GenericTypeDescription getSuperClass();

        public Collection<GenericTypeDescription> getDeclaredInterfaces();

        public Visibility getVisibility();

        public TypeManifestation getTypeManifestation();

        public SyntheticState getSyntheticState();

        public EnumerationState getEnumerationState();

        public ClassFileVersion getClassFileVersion();

        public static class Default
        implements UnnamedType {
            private final GenericTypeDescription superClass;
            private final List<? extends GenericTypeDescription> interfaces;
            private final int modifiers;
            private final ClassFileVersion classFileVersion;

            public Default(GenericTypeDescription superClass, List<? extends GenericTypeDescription> interfaces, int modifiers, ClassFileVersion classFileVersion) {
                this.superClass = superClass;
                this.interfaces = interfaces;
                this.modifiers = modifiers;
                this.classFileVersion = classFileVersion;
            }

            @Override
            public GenericTypeDescription getSuperClass() {
                return this.superClass;
            }

            public List<GenericTypeDescription> getDeclaredInterfaces() {
                return new ArrayList<GenericTypeDescription>(this.interfaces);
            }

            @Override
            public Visibility getVisibility() {
                switch (this.modifiers & 7) {
                    case 1: {
                        return Visibility.PUBLIC;
                    }
                    case 4: {
                        return Visibility.PROTECTED;
                    }
                    case 2: {
                        return Visibility.PRIVATE;
                    }
                    case 0: {
                        return Visibility.PACKAGE_PRIVATE;
                    }
                }
                throw new IllegalStateException("Ambiguous modifier: " + this.modifiers);
            }

            @Override
            public TypeManifestation getTypeManifestation() {
                if ((this.modifiers & 0x10) != 0) {
                    return TypeManifestation.FINAL;
                }
                if ((this.modifiers & 0x200) != 0) {
                    return TypeManifestation.INTERFACE;
                }
                if ((this.modifiers & 0x400) != 0) {
                    return TypeManifestation.ABSTRACT;
                }
                return TypeManifestation.PLAIN;
            }

            @Override
            public EnumerationState getEnumerationState() {
                return EnumerationState.is((this.modifiers & 0x4000) != 0);
            }

            @Override
            public SyntheticState getSyntheticState() {
                return SyntheticState.is((this.modifiers & 0x1000) != 0);
            }

            @Override
            public ClassFileVersion getClassFileVersion() {
                return this.classFileVersion;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Default aDefault = (Default)other;
                return this.modifiers == aDefault.modifiers && this.classFileVersion.equals(aDefault.classFileVersion) && this.interfaces.equals(aDefault.interfaces) && this.superClass.equals(aDefault.superClass);
            }

            public int hashCode() {
                int result = this.superClass.hashCode();
                result = 31 * result + this.interfaces.hashCode();
                result = 31 * result + this.modifiers;
                result = 31 * result + this.classFileVersion.hashCode();
                return result;
            }

            public String toString() {
                return "NamingStrategy.UnnamedType.Default{superClass=" + this.superClass + ", interfaces=" + this.interfaces + ", modifiers=" + this.modifiers + ", classFileVersion=" + this.classFileVersion + '}';
            }
        }
    }
}

