/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.analysis;

import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.analysis.Analysis;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.block.Block;
import org.checkerframework.dataflow.cfg.block.ExceptionBlock;
import org.checkerframework.dataflow.cfg.block.RegularBlock;
import org.checkerframework.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.dataflow.cfg.node.Node;

public class AnalysisResult<A extends AbstractValue<A>, S extends Store<S>> {
    protected final IdentityHashMap<Node, A> nodeValues;
    protected final IdentityHashMap<Tree, Set<Node>> treeLookup;
    protected final IdentityHashMap<UnaryTree, AssignmentNode> unaryAssignNodeLookup;
    protected final HashMap<Element, A> finalLocalValues;
    protected final IdentityHashMap<Block, TransferInput<A, S>> stores;
    protected final Map<TransferInput<A, S>, IdentityHashMap<Node, TransferResult<A, S>>> analysisCaches;

    public AnalysisResult(Map<Node, A> nodeValues, IdentityHashMap<Block, TransferInput<A, S>> stores, IdentityHashMap<Tree, Set<Node>> treeLookup, IdentityHashMap<UnaryTree, AssignmentNode> unaryAssignNodeLookup, HashMap<Element, A> finalLocalValues) {
        this.nodeValues = new IdentityHashMap<Node, A>(nodeValues);
        this.treeLookup = new IdentityHashMap<Tree, Set<Node>>(treeLookup);
        this.unaryAssignNodeLookup = new IdentityHashMap<UnaryTree, AssignmentNode>(unaryAssignNodeLookup);
        this.stores = stores;
        this.finalLocalValues = finalLocalValues;
        this.analysisCaches = new IdentityHashMap<TransferInput<A, S>, IdentityHashMap<Node, TransferResult<A, S>>>();
    }

    public AnalysisResult() {
        this.nodeValues = new IdentityHashMap();
        this.treeLookup = new IdentityHashMap();
        this.unaryAssignNodeLookup = new IdentityHashMap();
        this.stores = new IdentityHashMap();
        this.finalLocalValues = new HashMap();
        this.analysisCaches = new IdentityHashMap<TransferInput<A, S>, IdentityHashMap<Node, TransferResult<A, S>>>();
    }

    public AnalysisResult(Map<TransferInput<A, S>, IdentityHashMap<Node, TransferResult<A, S>>> analysisCaches) {
        this.nodeValues = new IdentityHashMap();
        this.treeLookup = new IdentityHashMap();
        this.unaryAssignNodeLookup = new IdentityHashMap();
        this.stores = new IdentityHashMap();
        this.finalLocalValues = new HashMap();
        this.analysisCaches = analysisCaches;
    }

    public void combine(AnalysisResult<A, S> other) {
        this.nodeValues.putAll(other.nodeValues);
        AnalysisResult.mergeTreeLookup(this.treeLookup, other.treeLookup);
        this.unaryAssignNodeLookup.putAll(other.unaryAssignNodeLookup);
        this.stores.putAll(other.stores);
        this.finalLocalValues.putAll(other.finalLocalValues);
    }

    private static void mergeTreeLookup(IdentityHashMap<Tree, Set<Node>> treeLookup, IdentityHashMap<Tree, Set<Node>> otherTreeLookup) {
        for (Map.Entry<Tree, Set<Node>> entry : otherTreeLookup.entrySet()) {
            Set<Node> hit = treeLookup.get(entry.getKey());
            if (hit == null) {
                treeLookup.put(entry.getKey(), entry.getValue());
                continue;
            }
            hit.addAll((Collection<Node>)entry.getValue());
        }
    }

    public HashMap<Element, A> getFinalLocalValues() {
        return this.finalLocalValues;
    }

    public @Nullable A getValue(Node n) {
        return (A)((AbstractValue)this.nodeValues.get(n));
    }

    public @Nullable A getValue(Tree t) {
        Set<Node> nodes = this.treeLookup.get(t);
        if (nodes == null) {
            return null;
        }
        if (nodes.size() == 1) {
            Node aNode = nodes.iterator().next();
            A val = this.getValue(aNode);
            return val;
        }
        AbstractValue<Object> merged = null;
        for (Node aNode : nodes) {
            A a = this.getValue(aNode);
            if (merged == null) {
                merged = (AbstractValue<Object>)a;
                continue;
            }
            if (a == null) continue;
            merged = merged.leastUpperBound(a);
        }
        return (A)merged;
    }

    public @Nullable Set<Node> getNodesForTree(Tree tree) {
        return this.treeLookup.get(tree);
    }

    public AssignmentNode getAssignForUnaryTree(UnaryTree tree) {
        assert (this.unaryAssignNodeLookup.containsKey(tree)) : tree + " is not in unaryAssignNodeLookup";
        return this.unaryAssignNodeLookup.get(tree);
    }

    public S getStoreBefore(Tree tree) {
        Set<Node> nodes = this.getNodesForTree(tree);
        if (nodes == null) {
            return null;
        }
        if (nodes.size() == 1) {
            return this.getStoreBefore(nodes.iterator().next());
        }
        Store merged = null;
        for (Node node : nodes) {
            S s = this.getStoreBefore(node);
            if (merged == null) {
                merged = (Store)s;
                continue;
            }
            if (s == null) continue;
            merged = merged.leastUpperBound(s);
        }
        return (S)merged;
    }

    public S getStoreBefore(Node node) {
        return this.runAnalysisFor(node, true);
    }

    public S getStoreAfter(Tree tree) {
        Set<Node> nodes = this.getNodesForTree(tree);
        if (nodes == null) {
            return null;
        }
        if (nodes.size() == 1) {
            return this.getStoreAfter(nodes.iterator().next());
        }
        Store merged = null;
        for (Node node : nodes) {
            S s = this.getStoreAfter(node);
            if (merged == null) {
                merged = (Store)s;
                continue;
            }
            if (s == null) continue;
            merged = merged.leastUpperBound(s);
        }
        return (S)merged;
    }

    public S getStoreAfter(Node node) {
        return this.runAnalysisFor(node, false);
    }

    protected S runAnalysisFor(Node node, boolean before) {
        Block block = node.getBlock();
        TransferInput<A, S> transferInput = this.stores.get(block);
        if (transferInput == null) {
            return null;
        }
        return AnalysisResult.runAnalysisFor(node, before, transferInput, this.analysisCaches);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A extends AbstractValue<A>, S extends Store<S>> S runAnalysisFor(Node node, boolean before, TransferInput<A, S> transferInput, Map<TransferInput<A, S>, IdentityHashMap<Node, TransferResult<A, S>>> analysisCaches) {
        IdentityHashMap<Node, TransferResult<A, S>> cache;
        assert (node != null);
        Block block = node.getBlock();
        assert (transferInput != null);
        Analysis<A, S, ?> analysis = transferInput.analysis;
        Node oldCurrentNode = analysis.currentNode;
        if (analysisCaches != null) {
            cache = analysisCaches.get(transferInput);
            if (cache == null) {
                cache = new IdentityHashMap();
                analysisCaches.put(transferInput, cache);
            }
        } else {
            cache = null;
        }
        if (analysis.isRunning) {
            return analysis.currentInput.getRegularStore();
        }
        analysis.isRunning = true;
        try {
            switch (block.getType()) {
                case REGULAR_BLOCK: {
                    RegularBlock rb = (RegularBlock)block;
                    TransferInput<A, Object> store = transferInput;
                    TransferResult transferResult = null;
                    Iterator<Node> iterator = rb.getContents().iterator();
                    while (iterator.hasNext()) {
                        Node n;
                        analysis.currentNode = n = iterator.next();
                        if (n == node && before) {
                            S s = store.getRegularStore();
                            return s;
                        }
                        if (cache != null && cache.containsKey(n)) {
                            transferResult = cache.get(n);
                        } else {
                            transferResult = analysis.callTransferFunction(n, store.copy());
                            if (cache != null) {
                                cache.put(n, transferResult);
                            }
                        }
                        if (n == node) {
                            Object s = transferResult.getRegularStore();
                            return s;
                        }
                        store = new TransferInput(n, analysis, transferResult);
                    }
                    assert (false);
                    iterator = null;
                    return (S)iterator;
                }
                case EXCEPTION_BLOCK: {
                    ExceptionBlock eb = (ExceptionBlock)block;
                    assert (eb.getNode() == node);
                    if (before) {
                        S store = transferInput.getRegularStore();
                        return store;
                    }
                    analysis.currentNode = node;
                    TransferResult transferResult = analysis.callTransferFunction(node, transferInput);
                    Object s = transferResult.getRegularStore();
                    return s;
                }
            }
            assert (false);
            S s = null;
            return s;
        }
        finally {
            analysis.currentNode = oldCurrentNode;
            analysis.isRunning = false;
        }
    }
}

