/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.pubapi;

import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.StringUtils;
import com.sun.tools.sjavac.pubapi.ArrayTypeDesc;
import com.sun.tools.sjavac.pubapi.PrimitiveTypeDesc;
import com.sun.tools.sjavac.pubapi.ReferenceTypeDesc;
import com.sun.tools.sjavac.pubapi.TypeVarTypeDesc;
import java.io.Serializable;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.SimpleTypeVisitor9;

public abstract class TypeDesc
implements Serializable {
    private static final long serialVersionUID = -8201634143915519172L;
    TypeKind typeKind;

    public TypeDesc(TypeKind typeKind) {
        this.typeKind = typeKind;
    }

    public static TypeDesc decodeString(String string) {
        if ((string = string.trim()).endsWith("[]")) {
            String string2 = string.substring(0, string.length() - 2);
            return new ArrayTypeDesc(TypeDesc.decodeString(string2));
        }
        if (string.startsWith("#")) {
            return new TypeVarTypeDesc(string.substring(1));
        }
        if (string.matches("boolean|byte|char|double|float|int|long|short|void")) {
            TypeKind typeKind = TypeKind.valueOf(StringUtils.toUpperCase(string));
            return new PrimitiveTypeDesc(typeKind);
        }
        return new ReferenceTypeDesc(string);
    }

    public static String encodeAsString(TypeDesc typeDesc) {
        if (typeDesc.typeKind.isPrimitive() || typeDesc.typeKind == TypeKind.VOID) {
            return StringUtils.toLowerCase(typeDesc.typeKind.toString());
        }
        if (typeDesc.typeKind == TypeKind.ARRAY) {
            return TypeDesc.encodeAsString(((ArrayTypeDesc)typeDesc).compTypeDesc) + "[]";
        }
        if (typeDesc.typeKind == TypeKind.TYPEVAR) {
            return "#" + ((TypeVarTypeDesc)typeDesc).identifier;
        }
        if (typeDesc.typeKind == TypeKind.DECLARED) {
            return ((ReferenceTypeDesc)typeDesc).javaType.toString();
        }
        throw new AssertionError((Object)("Unhandled type: " + (Object)((Object)typeDesc.typeKind)));
    }

    public static TypeDesc fromType(TypeMirror typeMirror) {
        SimpleTypeVisitor9<TypeDesc, Void> simpleTypeVisitor9 = new SimpleTypeVisitor9<TypeDesc, Void>(){

            @Override
            public TypeDesc visitArray(ArrayType arrayType, Void void_) {
                return new ArrayTypeDesc(arrayType.getComponentType().accept(this, void_));
            }

            @Override
            public TypeDesc visitDeclared(DeclaredType declaredType, Void void_) {
                return new ReferenceTypeDesc(((Type.ClassType)declaredType).tsym.flatName().toString());
            }

            @Override
            public TypeDesc visitNoType(NoType noType, Void void_) {
                return new PrimitiveTypeDesc(TypeKind.VOID);
            }

            @Override
            public TypeDesc visitTypeVariable(TypeVariable typeVariable, Void void_) {
                return new TypeVarTypeDesc(typeVariable.toString());
            }

            @Override
            public TypeDesc visitPrimitive(PrimitiveType primitiveType, Void void_) {
                return new PrimitiveTypeDesc(primitiveType.getKind());
            }

            @Override
            public TypeDesc visitError(ErrorType errorType, Void void_) {
                return new ReferenceTypeDesc("<error type>");
            }
        };
        TypeDesc typeDesc = (TypeDesc)simpleTypeVisitor9.visit(typeMirror);
        if (typeDesc == null) {
            throw new AssertionError((Object)("Unhandled type mirror: " + typeMirror + " (" + typeMirror.getClass() + ")"));
        }
        return typeDesc;
    }

    public boolean equals(Object object) {
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.typeKind.equals((Object)((TypeDesc)object).typeKind);
    }

    public int hashCode() {
        return this.typeKind.hashCode();
    }
}

