/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.lang.model.type.TypeMirror;

public abstract class AbstractExpectedExceptionChecker
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    static final Matcher<StatementTree> MATCHER = Matchers.expressionStatement((Matcher)MethodMatchers.instanceMethod().onExactClass("org.junit.rules.ExpectedException").withNameMatching(Pattern.compile("expect.*")));
    static final Matcher<ExpressionTree> IS_A = Matchers.staticMethod().onClassAny(new String[]{"org.hamcrest.Matchers", "org.hamcrest.CoreMatchers", "org.hamcrest.core.Is"}).withSignature("<T>isA(java.lang.Class<T>)");
    static final Matcher<StatementTree> FAIL_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.throwStatement((Matcher)Matchers.anything()), Matchers.expressionStatement((Matcher)Matchers.staticMethod().anyClass().named("fail"))});

    public Description matchMethod(final MethodTree tree, final VisitorState state) {
        if (tree.getBody() == null) {
            return Description.NO_MATCH;
        }
        tree.getBody().accept(new TreeScanner<Void, Void>(){

            @Override
            public Void visitBlock(BlockTree block, Void unused) {
                Description description = AbstractExpectedExceptionChecker.this.scanBlock(tree, block, state);
                if (description != Description.NO_MATCH) {
                    state.reportMatch(description);
                }
                return (Void)super.visitBlock(block, unused);
            }
        }, null);
        return Description.NO_MATCH;
    }

    Description scanBlock(MethodTree tree, BlockTree block, VisitorState state) {
        PeekingIterator it = Iterators.peekingIterator(block.getStatements().iterator());
        while (it.hasNext() && !MATCHER.matches((Tree)it.peek(), state)) {
            it.next();
        }
        ArrayList<Tree> expectations = new ArrayList<Tree>();
        while (it.hasNext() && MATCHER.matches((Tree)it.peek(), state)) {
            expectations.add((Tree)it.next());
        }
        if (expectations.isEmpty()) {
            return Description.NO_MATCH;
        }
        ArrayDeque suffix = new ArrayDeque();
        StatementTree failure = null;
        Iterators.addAll(suffix, (Iterator)it);
        if (!suffix.isEmpty() && FAIL_MATCHER.matches((Tree)suffix.peekLast(), state)) {
            failure = (StatementTree)suffix.removeLast();
        }
        return this.handleMatch(tree, state, expectations, (List<StatementTree>)ImmutableList.copyOf(suffix), failure);
    }

    protected abstract Description handleMatch(MethodTree var1, VisitorState var2, List<Tree> var3, List<StatementTree> var4, @Nullable StatementTree var5);

    protected BaseFix buildBaseFix(VisitorState state, List<Tree> expectations, @Nullable StatementTree failure) {
        String exceptionClass = "Throwable";
        ArrayList<String> newAsserts = new ArrayList<String>();
        SuggestedFix.Builder fix = SuggestedFix.builder();
        block10: for (Tree expectation : expectations) {
            MethodInvocationTree invocation = (MethodInvocationTree)((ExpressionStatementTree)expectation).getExpression();
            Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodInvocationTree)invocation);
            Symtab symtab = state.getSymtab();
            List<? extends ExpressionTree> args = invocation.getArguments();
            switch (((Name)symbol.getSimpleName()).toString()) {
                case "expect": {
                    Type matchType;
                    Type type = ASTHelpers.getType((Tree)((Tree)Iterables.getOnlyElement(invocation.getArguments())));
                    if (ASTHelpers.isSubtype((Type)type, (Type)symtab.classType, (VisitorState)state)) {
                        exceptionClass = state.getSourceForNode((Tree)ASTHelpers.getReceiver((ExpressionTree)((ExpressionTree)Iterables.getOnlyElement(args))));
                        continue block10;
                    }
                    if (!ASTHelpers.isSubtype((Type)type, (Type)state.getTypeFromString("org.hamcrest.Matcher"), (VisitorState)state)) continue block10;
                    Type matcherType = state.getTypes().asSuper(type, state.getSymbolFromString("org.hamcrest.Matcher"));
                    if (!matcherType.getTypeArguments().isEmpty() && ASTHelpers.isSubtype((Type)(matchType = (Type)Iterables.getOnlyElement(matcherType.getTypeArguments())), (Type)symtab.throwableType, (VisitorState)state)) {
                        exceptionClass = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (TypeMirror)matchType);
                    }
                    fix.addStaticImport("org.hamcrest.MatcherAssert.assertThat");
                    newAsserts.add(String.format("assertThat(thrown, %s);", state.getSourceForNode((Tree)Iterables.getOnlyElement(args))));
                    continue block10;
                }
                case "expectCause": {
                    ExpressionTree matcher = (ExpressionTree)Iterables.getOnlyElement(invocation.getArguments());
                    if (IS_A.matches((Tree)matcher, state)) {
                        fix.addStaticImport("com.google.common.truth.Truth.assertThat");
                        newAsserts.add(String.format("assertThat(thrown).hasCauseThat().isInstanceOf(%s);", state.getSourceForNode((Tree)Iterables.getOnlyElement(((MethodInvocationTree)matcher).getArguments()))));
                        continue block10;
                    }
                    fix.addStaticImport("org.hamcrest.MatcherAssert.assertThat");
                    newAsserts.add(String.format("assertThat(thrown.getCause(), %s);", state.getSourceForNode((Tree)Iterables.getOnlyElement(args))));
                    continue block10;
                }
                case "expectMessage": {
                    if (ASTHelpers.isSubtype((Type)((Symbol.VarSymbol)Iterables.getOnlyElement((Iterable)symbol.getParameters())).asType(), (Type)symtab.stringType, (VisitorState)state)) {
                        fix.addStaticImport("com.google.common.truth.Truth.assertThat");
                        newAsserts.add(String.format("assertThat(thrown).hasMessageThat().contains(%s);", state.getSourceForNode((Tree)Iterables.getOnlyElement(args))));
                        continue block10;
                    }
                    fix.addStaticImport("org.hamcrest.MatcherAssert.assertThat");
                    newAsserts.add(String.format("assertThat(thrown.getMessage(), %s);", state.getSourceForNode((Tree)Iterables.getOnlyElement(args))));
                    continue block10;
                }
            }
            throw new AssertionError((Object)("unknown expect method: " + symbol.getSimpleName()));
        }
        fix.replace(((JCTree)expectations.get(0)).getStartPosition(), state.getEndPosition((Tree)Iterables.getLast(expectations)), "");
        if (failure != null) {
            fix.delete((Tree)failure);
        }
        return new BaseFix(fix.build(), exceptionClass, newAsserts);
    }

    protected static class BaseFix {
        final SuggestedFix baseFix;
        final String exceptionClass;
        final List<String> newAsserts;

        BaseFix(SuggestedFix baseFix, String exceptionClass, List<String> newAsserts) {
            this.baseFix = baseFix;
            this.exceptionClass = exceptionClass;
            this.newAsserts = newAsserts;
        }

        public Fix build(List<? extends StatementTree> throwingStatements) {
            boolean useExpressionLambda;
            if (throwingStatements.isEmpty()) {
                return this.baseFix;
            }
            SuggestedFix.Builder fix = SuggestedFix.builder().merge(this.baseFix);
            fix.addStaticImport("org.junit.Assert.assertThrows");
            StringBuilder fixPrefix = new StringBuilder();
            if (!this.newAsserts.isEmpty()) {
                fixPrefix.append(String.format("%s thrown = ", this.exceptionClass));
            }
            fixPrefix.append("assertThrows");
            fixPrefix.append(String.format("(%s.class, () -> ", this.exceptionClass));
            boolean bl = useExpressionLambda = throwingStatements.size() == 1 && ((StatementTree)Iterables.getOnlyElement(throwingStatements)).getKind() == Tree.Kind.EXPRESSION_STATEMENT;
            if (!useExpressionLambda) {
                fixPrefix.append("{");
            }
            fix.prefixWith((Tree)throwingStatements.get(0), fixPrefix.toString());
            if (useExpressionLambda) {
                fix.postfixWith((Tree)((ExpressionStatementTree)throwingStatements.get(0)).getExpression(), ")");
                fix.postfixWith((Tree)Iterables.getLast(throwingStatements), Joiner.on((char)'\n').join(this.newAsserts));
            } else {
                fix.postfixWith((Tree)Iterables.getLast(throwingStatements), "});\n" + Joiner.on((char)'\n').join(this.newAsserts));
            }
            return fix.build();
        }
    }
}

