/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.argumentselectiondefects;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Changes;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Heuristic;
import com.google.errorprone.bugpatterns.argumentselectiondefects.NamedParameterComment;
import com.google.errorprone.util.Commented;
import com.google.errorprone.util.Comments;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;

class NameInCommentHeuristic
implements Heuristic {
    NameInCommentHeuristic() {
    }

    @Override
    public boolean isAcceptableChange(Changes changes, Tree node, Symbol.MethodSymbol symbol, VisitorState state) {
        ImmutableList<Commented<ExpressionTree>> comments = NameInCommentHeuristic.findCommentsForArguments(node, state);
        return changes.changedPairs().stream().noneMatch(p -> {
            NamedParameterComment.MatchType match = NamedParameterComment.match((Commented<ExpressionTree>)((Commented)comments.get(p.formal().index())), p.formal().name()).matchType();
            return match == NamedParameterComment.MatchType.EXACT_MATCH || match == NamedParameterComment.MatchType.APPROXIMATE_MATCH;
        });
    }

    private static ImmutableList<Commented<ExpressionTree>> findCommentsForArguments(Tree tree, VisitorState state) {
        switch (tree.getKind()) {
            case METHOD_INVOCATION: {
                return Comments.findCommentsForArguments((MethodInvocationTree)((MethodInvocationTree)tree), (VisitorState)state);
            }
            case NEW_CLASS: {
                return Comments.findCommentsForArguments((NewClassTree)((NewClassTree)tree), (VisitorState)state);
            }
        }
        throw new IllegalArgumentException("Only MethodInvocationTree or NewClassTree is supported");
    }
}

