// Copyright 2015 The Bazel Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.google.devtools.build.lib.rules.android;

import com.google.auto.value.AutoValue;
import com.google.common.base.Function;
import com.google.devtools.build.lib.analysis.TransitiveInfoCollection;
import com.google.devtools.build.lib.analysis.TransitiveInfoProvider;
import com.google.devtools.build.lib.concurrent.ThreadSafety.Immutable;
import com.google.devtools.build.lib.rules.cpp.AbstractCcLinkParamsStore;
import com.google.devtools.build.lib.rules.cpp.CcLinkParamsStore;

/** A target that provides C++ libraries to be linked into Android targets. */
@AutoValue
@Immutable
public abstract class AndroidCcLinkParamsProvider implements TransitiveInfoProvider {
  public static AndroidCcLinkParamsProvider create(AbstractCcLinkParamsStore store) {
    return new AutoValue_AndroidCcLinkParamsProvider(new CcLinkParamsStore(store));
  }

  public abstract AbstractCcLinkParamsStore getLinkParams();

  public static final Function<TransitiveInfoCollection, AbstractCcLinkParamsStore> TO_LINK_PARAMS =
      (TransitiveInfoCollection input) -> {
        AndroidCcLinkParamsProvider provider = input.getProvider(AndroidCcLinkParamsProvider.class);
        return provider == null ? null : provider.getLinkParams();
      };

  AndroidCcLinkParamsProvider() {}
}
