/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import com.sun.tools.javac.util.Assert;
import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Module;
import com.sun.tools.sjavac.Package;
import com.sun.tools.sjavac.Source;
import com.sun.tools.sjavac.Util;
import com.sun.tools.sjavac.pubapi.PubApi;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BuildState {
    private Map<String, Module> modules = new HashMap<String, Module>();
    private Map<String, Package> packages = new HashMap<String, Package>();
    private Map<String, Source> sources = new HashMap<String, Source>();
    private Map<String, File> artifacts = new HashMap<String, File>();
    private Map<String, Set<String>> dependents = new HashMap<String, Set<String>>();

    public Map<String, Module> modules() {
        return this.modules;
    }

    public Map<String, Package> packages() {
        return this.packages;
    }

    public Map<String, Source> sources() {
        return this.sources;
    }

    public Map<String, File> artifacts() {
        return this.artifacts;
    }

    public Map<String, Set<String>> dependents() {
        return this.dependents;
    }

    public Module lookupModule(String mod) {
        Module m = this.modules.get(mod);
        if (m == null) {
            m = new Module(mod, "???");
            this.modules.put(mod, m);
        }
        return m;
    }

    Module findModuleFromPackageName(String pkg) {
        int cp = pkg.indexOf(58);
        Assert.check(cp != -1, "Could not find package name");
        String mod = pkg.substring(0, cp);
        return this.lookupModule(mod);
    }

    public void flattenPackagesSourcesAndArtifacts(Map<String, Module> m) {
        this.modules = m;
        for (Module i : this.modules.values()) {
            for (Map.Entry<String, Package> j : i.packages().entrySet()) {
                Package p = this.packages.get(j.getKey());
                Assert.check(p == null || p == j.getValue());
                if (p == null) {
                    p = j.getValue();
                    this.packages.put(j.getKey(), j.getValue());
                }
                for (Map.Entry<String, Source> entry : p.sources().entrySet()) {
                    Source s = this.sources.get(entry.getKey());
                    Assert.check(s == null || s == entry.getValue());
                    if (s != null) continue;
                    s = entry.getValue();
                    this.sources.put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<String, Comparable<Source>> entry : p.artifacts().entrySet()) {
                    File f = this.artifacts.get(entry.getKey());
                    Assert.check(f == null || f == entry.getValue());
                    if (f != null) continue;
                    f = (File)entry.getValue();
                    this.artifacts.put(entry.getKey(), (File)entry.getValue());
                }
            }
        }
    }

    public void flattenArtifacts(Map<String, Module> m) {
        this.modules = m;
        for (Module i : this.modules.values()) {
            for (Map.Entry<String, Package> j : i.packages().entrySet()) {
                Package p = this.packages.get(j.getKey());
                Assert.check(p == null || p == j.getValue());
                p = j.getValue();
                this.packages.put(j.getKey(), j.getValue());
                for (Map.Entry<String, File> g : p.artifacts().entrySet()) {
                    File f = this.artifacts.get(g.getKey());
                    Assert.check(f == null || f == g.getValue());
                    this.artifacts.put(g.getKey(), g.getValue());
                }
            }
        }
    }

    public void calculateDependents() {
        this.dependents = new HashMap<String, Set<String>>();
        for (String s : this.packages.keySet()) {
            Package p = this.packages.get(s);
            Set<String> deps = p.typeDependencies().values().stream().reduce(Collections.emptySet(), Util::union);
            for (String dep : deps) {
                String depPkgStr = ":" + dep.substring(0, dep.lastIndexOf(46));
                this.dependents.merge(depPkgStr, Collections.singleton(s), Util::union);
                Package dp = this.packages.get(depPkgStr);
                if (dp == null) continue;
                dp.addDependent(p.name());
            }
        }
    }

    public void checkInternalState(String msg, boolean linkedOnly, Map<String, Source> srcs) {
        Source ss;
        boolean baad = false;
        HashMap<String, Source> original = new HashMap<String, Source>();
        HashMap<String, Source> calculated = new HashMap<String, Source>();
        for (String s : this.sources.keySet()) {
            ss = this.sources.get(s);
            if (ss.isLinkedOnly() != linkedOnly) continue;
            calculated.put(s, ss);
        }
        for (String s : srcs.keySet()) {
            ss = srcs.get(s);
            if (ss.isLinkedOnly() != linkedOnly) continue;
            original.put(s, ss);
        }
        if (original.size() != calculated.size()) {
            Log.error("INTERNAL ERROR " + msg + " original and calculated are not the same size!");
            baad = true;
        }
        if (!original.keySet().equals(calculated.keySet())) {
            Log.error("INTERNAL ERROR " + msg + " original and calculated do not have the same domain!");
            baad = true;
        }
        if (!baad) {
            for (String s : original.keySet()) {
                Source s1 = (Source)original.get(s);
                Source s2 = (Source)calculated.get(s);
                if (s1 == null || s2 == null || !s1.equals(s2)) {
                    Log.error("INTERNAL ERROR " + msg + " original and calculated have differing elements for " + s);
                }
                baad = true;
            }
        }
        if (baad) {
            Source sss;
            for (String s : original.keySet()) {
                ss = (Source)original.get(s);
                sss = (Source)calculated.get(s);
                if (sss != null) continue;
                Log.error("The file " + s + " does not exist in calculated tree of sources.");
            }
            for (String s : calculated.keySet()) {
                ss = (Source)calculated.get(s);
                sss = (Source)original.get(s);
                if (sss != null) continue;
                Log.error("The file " + s + " does not exist in original set of found sources.");
            }
        }
    }

    public Module loadModule(String l) {
        Module m = Module.load(l);
        this.modules.put(m.name(), m);
        return m;
    }

    public Package loadPackage(Module lastModule, String l) {
        Package p = Package.load(lastModule, l);
        lastModule.addPackage(p);
        this.packages.put(p.name(), p);
        return p;
    }

    public Source loadSource(Package lastPackage, String l, boolean is_generated) {
        Source s = Source.load(lastPackage, l, is_generated);
        lastPackage.addSource(s);
        this.sources.put(s.name(), s);
        return s;
    }

    public void copyPackagesExcept(BuildState prev, Set<String> recompiled, Set<String> removed) {
        for (String pkg : prev.packages().keySet()) {
            if (recompiled.contains(pkg) || removed.contains(pkg)) continue;
            Module mnew = this.findModuleFromPackageName(pkg);
            Package pprev = prev.packages().get(pkg);
            if (this.packages.containsKey(pkg)) {
                pprev.setPubapi(PubApi.mergeTypes(pprev.getPubApi(), this.packages.get(pkg).getPubApi()));
            }
            mnew.addPackage(pprev);
            this.packages.put(pkg, pprev);
        }
    }
}

