/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WebViewDetector
extends LayoutDetector {
    private static final Implementation IMPLEMENTATION = new Implementation(WebViewDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create((String)"WebViewLayout", (String)"WebViews in wrap_content parents", (String)"The WebView implementation has certain performance optimizations which will not work correctly if the parent view is using `wrap_content` rather than `match_parent`. This can lead to subtle UI bugs.", (Category)Category.CORRECTNESS, (int)7, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);

    public Speed getSpeed() {
        return Speed.FAST;
    }

    public Collection<String> getApplicableElements() {
        return Collections.singletonList("WebView");
    }

    public void visitElement(XmlContext context, Element element) {
        Node parentNode = element.getParentNode();
        if (parentNode != null && parentNode.getNodeType() == 1) {
            Element parent = (Element)parentNode;
            Attr width = parent.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "layout_width");
            Attr height = parent.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "layout_height");
            Attr attr = null;
            if (width != null && "wrap_content".equals(width.getValue())) {
                attr = width;
            }
            if (height != null && "wrap_content".equals(height.getValue())) {
                attr = height;
            }
            if (attr != null) {
                String message = String.format("Placing a `<WebView>` in a parent element that uses a `wrap_content %1$s` can lead to subtle bugs; use `match_parent` instead", attr.getLocalName());
                Location location = context.getLocation((Node)element);
                Location secondary = context.getLocation((Node)attr);
                secondary.setMessage("`wrap_content` here may not work well with WebView below");
                location.setSecondary(secondary);
                context.report(ISSUE, (Node)element, location, message);
            }
        }
    }
}

