/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import java.util.List;

@BugPattern(name="CatchAndPrintStackTrace", summary="Logging or rethrowing exceptions should usually be preferred to catching and calling printStackTrace", severity=BugPattern.SeverityLevel.WARNING)
public class CatchAndPrintStackTrace
extends BugChecker
implements BugChecker.CatchTreeMatcher {
    private static final Matcher<StatementTree> MATCHER = Matchers.expressionStatement((Matcher)MethodMatchers.instanceMethod().onDescendantOf("java.lang.Throwable").named("printStackTrace"));

    public Description matchCatch(CatchTree tree, VisitorState state) {
        List<? extends StatementTree> statements = tree.getBlock().getStatements();
        if (statements.size() != 1) {
            return Description.NO_MATCH;
        }
        StatementTree statement = (StatementTree)Iterables.getOnlyElement(statements);
        if (!MATCHER.matches((Tree)statement, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(statement);
    }
}

