/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.CompileTimeConstantExpressionMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.Iterator;

@BugPattern(name="CompileTimeConstant", summary="Non-compile-time constant expression passed to parameter with @CompileTimeConstant type annotation.", linkType=BugPattern.LinkType.NONE, category=BugPattern.Category.GUAVA, severity=BugPattern.SeverityLevel.ERROR, disableable=false, suppressionAnnotations={})
public class CompileTimeConstantChecker
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final String DID_YOU_MEAN_FINAL_FMT_MESSAGE = " Did you mean to make '%s' final?";
    private final Matcher<ExpressionTree> compileTimeConstExpressionMatcher = new CompileTimeConstantExpressionMatcher();

    private Description matchArguments(VisitorState state, Symbol.MethodSymbol calleeSymbol, Iterator<? extends ExpressionTree> actualParams) {
        Symbol lastFormalParam = null;
        for (Symbol.VarSymbol formalParam : calleeSymbol.getParameters()) {
            lastFormalParam = formalParam;
            if (!actualParams.hasNext()) {
                return Description.NO_MATCH;
            }
            ExpressionTree actualParam = actualParams.next();
            if (!CompileTimeConstantExpressionMatcher.hasCompileTimeConstantAnnotation((VisitorState)state, (Symbol)formalParam) || this.compileTimeConstExpressionMatcher.matches((Tree)actualParam, state)) continue;
            return this.handleMatch(actualParam, state);
        }
        if (lastFormalParam == null || (lastFormalParam.flags() & 0x400000000L) == 0L) {
            return Description.NO_MATCH;
        }
        if (!CompileTimeConstantExpressionMatcher.hasCompileTimeConstantAnnotation((VisitorState)state, (Symbol)lastFormalParam)) {
            return Description.NO_MATCH;
        }
        while (actualParams.hasNext()) {
            ExpressionTree actualParam = actualParams.next();
            if (this.compileTimeConstExpressionMatcher.matches((Tree)actualParam, state)) continue;
            return this.handleMatch(actualParam, state);
        }
        return Description.NO_MATCH;
    }

    private Description handleMatch(ExpressionTree actualParam, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol((Tree)actualParam);
        if (!(sym instanceof Symbol.VarSymbol)) {
            return this.describeMatch(actualParam);
        }
        Symbol.VarSymbol var = (Symbol.VarSymbol)sym;
        if (!CompileTimeConstantExpressionMatcher.hasCompileTimeConstantAnnotation((VisitorState)state, (Symbol)var)) {
            return this.describeMatch(actualParam);
        }
        return this.buildDescription(actualParam).setMessage(this.message() + String.format(DID_YOU_MEAN_FINAL_FMT_MESSAGE, var.getSimpleName())).build();
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((NewClassTree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        return this.matchArguments(state, sym, tree.getArguments().iterator());
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        return this.matchArguments(state, sym, tree.getArguments().iterator());
    }
}

