/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractMustBeClosedChecker;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;

@BugPattern(name="MustBeClosedChecker", summary="The result of this method must be closed.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, generateExamplesFromTestCases=false)
public class MustBeClosedChecker
extends AbstractMustBeClosedChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final Matcher<MethodTree> METHOD_RETURNS_AUTO_CLOSEABLE_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.not((Matcher)Matchers.methodIsConstructor()), Matchers.methodReturns((Matcher)Matchers.isSubtypeOf((String)"java.lang.AutoCloseable"))});
    private static final Matcher<MethodTree> AUTO_CLOSEABLE_CONSTRUCTOR_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsConstructor(), Matchers.enclosingClass((Matcher)Matchers.isSubtypeOf((String)"java.lang.AutoCloseable"))});

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (!HAS_MUST_BE_CLOSED_ANNOTATION.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        boolean isAConstructor = Matchers.methodIsConstructor().matches((Tree)tree, state);
        if (isAConstructor && !AUTO_CLOSEABLE_CONSTRUCTOR_MATCHER.matches((Tree)tree, state)) {
            return this.buildDescription(tree).setMessage("MustBeClosed should only annotate constructors of AutoCloseables.").build();
        }
        if (!isAConstructor && !METHOD_RETURNS_AUTO_CLOSEABLE_MATCHER.matches((Tree)tree, state)) {
            return this.buildDescription(tree).setMessage("MustBeClosed should only annotate methods that return an AutoCloseable.").build();
        }
        return Description.NO_MATCH;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!HAS_MUST_BE_CLOSED_ANNOTATION.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.matchNewClassOrMethodInvocation(tree, state);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!HAS_MUST_BE_CLOSED_ANNOTATION.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.matchNewClassOrMethodInvocation(tree, state);
    }
}

