/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.fixes;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.errorprone.fixes.AutoValue_Replacement;

@AutoValue
public abstract class Replacement {
    public static Replacement create(int startPosition, int endPosition, String replaceWith) {
        Preconditions.checkArgument((startPosition >= 0 && startPosition <= endPosition ? 1 : 0) != 0, (String)"invalid replacement: [%s, %s) (%s)", (Object)startPosition, (Object)endPosition, (Object)replaceWith);
        return new AutoValue_Replacement((Range<Integer>)Range.closedOpen((Comparable)Integer.valueOf(startPosition), (Comparable)Integer.valueOf(endPosition)), replaceWith);
    }

    public int startPosition() {
        return (Integer)this.range().lowerEndpoint();
    }

    public int length() {
        return this.endPosition() - this.startPosition();
    }

    public int endPosition() {
        return (Integer)this.range().upperEndpoint();
    }

    public abstract Range<Integer> range();

    public abstract String replaceWith();
}

