/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.jimfs;

import com.google.common.collect.ImmutableMap;
import com.google.common.jimfs.AclAttributeProvider;
import com.google.common.jimfs.AttributeProvider;
import com.google.common.jimfs.BasicAttributeProvider;
import com.google.common.jimfs.DosAttributeProvider;
import com.google.common.jimfs.OwnerAttributeProvider;
import com.google.common.jimfs.PosixAttributeProvider;
import com.google.common.jimfs.UnixAttributeProvider;
import com.google.common.jimfs.UserDefinedAttributeProvider;
import javax.annotation.Nullable;

final class StandardAttributeProviders {
    private static final ImmutableMap<String, AttributeProvider> PROVIDERS = new ImmutableMap.Builder().put((Object)"basic", (Object)new BasicAttributeProvider()).put((Object)"owner", (Object)new OwnerAttributeProvider()).put((Object)"posix", (Object)new PosixAttributeProvider()).put((Object)"dos", (Object)new DosAttributeProvider()).put((Object)"acl", (Object)new AclAttributeProvider()).put((Object)"user", (Object)new UserDefinedAttributeProvider()).build();

    private StandardAttributeProviders() {
    }

    @Nullable
    public static AttributeProvider get(String view) {
        AttributeProvider provider = (AttributeProvider)PROVIDERS.get((Object)view);
        if (provider == null && view.equals("unix")) {
            return new UnixAttributeProvider();
        }
        return provider;
    }
}

