# Copyright 2016 The Bazel Authors. All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License
"""Provides functionality to determine hosted configs based on Bazel version and
the container digest.

WARNING: Autogenerated file. Do not edit manually as changes may be overridden.
Contact repository owners if you wish to edit this file for instructions.
"""

_ENV1 = {
    "ABI_LIBC_VERSION": "glibc_2.19",
    "ABI_VERSION": "clang",
    "BAZEL_COMPILER": "clang",
    "BAZEL_HOST_SYSTEM": "i686-unknown-linux-gnu",
    "BAZEL_TARGET_CPU": "k8",
    "BAZEL_TARGET_LIBC": "glibc_2.19",
    "BAZEL_TARGET_SYSTEM": "x86_64-unknown-linux-gnu",
    "CC": "clang",
    "CC_TOOLCHAIN_NAME": "linux_gnu_x86",
}

_TOOLCHAIN_CONFIG_SPEC1 = struct(
    name = "9.0.0",
    java_home = "/usr/lib/jvm/java-8-openjdk-amd64",
    create_java_configs = True,
    create_cc_configs = True,
    config_repos = [],
    env = _ENV1,
)

_ENV2 = {
    "ABI_LIBC_VERSION": "glibc_2.19",
    "ABI_VERSION": "clang",
    "BAZEL_COMPILER": "clang",
    "BAZEL_HOST_SYSTEM": "i686-unknown-linux-gnu",
    "BAZEL_TARGET_CPU": "k8",
    "BAZEL_TARGET_LIBC": "glibc_2.19",
    "BAZEL_TARGET_SYSTEM": "x86_64-unknown-linux-gnu",
    "CC": "clang",
    "CC_TOOLCHAIN_NAME": "linux_gnu_x86",
}

_TOOLCHAIN_CONFIG_SPEC2 = struct(
    name = "8.0.0",
    java_home = "/usr/lib/jvm/java-8-openjdk-amd64",
    create_java_configs = True,
    create_cc_configs = True,
    config_repos = [],
    env = _ENV2,
)

_TOOLCHAIN_CONFIG_SPECS = [_TOOLCHAIN_CONFIG_SPEC1, _TOOLCHAIN_CONFIG_SPEC2]

_DEFAULT_TOOLCHAIN_CONFIG_SPEC = _TOOLCHAIN_CONFIG_SPEC1

# Returns a dict with suppported Bazel versions mapped to the config version to use.
_BAZEL_TO_CONFIG_SPEC_NAMES = {
    "0.24.1": ["9.0.0"],
}

# sha256 digest of the latest version of the toolchain container.
LATEST = "sha256:671d8b28e99c8a0a7aa2aaae072bf8e92c19def082b218ae46e209274cdd476e"

_CONTAINER_TO_CONFIG_SPEC_NAMES = {
    "sha256:671d8b28e99c8a0a7aa2aaae072bf8e92c19def082b218ae46e209274cdd476e": ["9.0.0"],
}

TOOLCHAIN_CONFIG_AUTOGEN_SPEC = struct(
    bazel_to_config_spec_names_map = _BAZEL_TO_CONFIG_SPEC_NAMES,
    container_to_config_spec_names_map = _CONTAINER_TO_CONFIG_SPEC_NAMES,
    default_toolchain_config_spec = _DEFAULT_TOOLCHAIN_CONFIG_SPEC,
    latest_container = LATEST,
    toolchain_config_specs = _TOOLCHAIN_CONFIG_SPECS,
)
