/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.collect.ImmutableMap;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import java.util.HashMap;
import javax.annotation.Nullable;

final class InternalHandlerRegistry {
    private final ImmutableMap<String, ServerMethodDefinition<?, ?>> methods;

    private InternalHandlerRegistry(ImmutableMap<String, ServerMethodDefinition<?, ?>> methods) {
        this.methods = methods;
    }

    @Nullable
    ServerMethodDefinition<?, ?> lookupMethod(String methodName) {
        return (ServerMethodDefinition)this.methods.get((Object)methodName);
    }

    static class Builder {
        private final HashMap<String, ServerServiceDefinition> services = new HashMap();

        Builder() {
        }

        Builder addService(ServerServiceDefinition service) {
            this.services.put(service.getServiceDescriptor().getName(), service);
            return this;
        }

        InternalHandlerRegistry build() {
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            for (ServerServiceDefinition service : this.services.values()) {
                for (ServerMethodDefinition<?, ?> method : service.getMethods()) {
                    mapBuilder.put((Object)method.getMethodDescriptor().getFullMethodName(), method);
                }
            }
            return new InternalHandlerRegistry(mapBuilder.build());
        }
    }
}

